<?php


/** support for widgets **/
/** http://automattic.com/code/widgets/themes/ **/

function tomk32_widget_links($args) {
	global $wp_db_version;
	extract($args);
	$style = get_option('tomk32_widget_links');
	if ($style != 'multiple') {
		echo $before_widget, $before_title, __('Links'), $after_title;
		$after_copy = $after_widget;
		$after_widget = $before_widget = "";
	}
	if ( $wp_db_version < 3582 ) {
		// This ONLY works with li/h2 sidebars.
		get_links_list();
	} else {
	  if ($style != 'multiple') {
	    echo '<ul>';
	    wp_list_bookmarks(array('title_before' => '<strong>', 
				    'title_after' => '</strong>'));
	    echo '</ul>';
	  } else
	    wp_list_bookmarks(array('category_before' => $before_widget, 
				    'category_after' => $after_widget, 
				    'title_before'=>$before_title, 
				    'title_after'=>$after_title));
	}
	if ($style != 'multiple')
		echo $after_copy;
}

function tomk32_widget_links_control() {
	if (isset($_POST['tomk32_widget_links']) && in_array($_POST['tomk32_widget_links'], array('single', 'multiple')))
		update_option('tomk32_widget_links', $_POST['tomk32_widget_links']);
	$style = get_option('tomk32_widget_links');
	if (empty($style)) $style = 'multiple';
?>
	<div>
		<label><?php _e('Display in a single box or multiple? Single is the better choice if you have many link-categories.'); ?><br />
			<select name="tomk32_widget_links">
				<option value="single"<?php echo ($style == 'single') ? 'selected="selected"' : ""; ?>><?php _e('Single'); ?></option>
				<option value="multiple"<?php echo ($style == 'multiple') ? 'selected="selected"' : ""; ?>><?php _e('Multiple'); ?></option>
			</select>
		</label>
	</div>
<?php
}

function widget_wp_theme_switcher($args) {
	extract($args);
	echo $before_widget;
	echo '<div class="title">', __('Themes'), '</div>';
	wp_theme_switcher();
	echo $after_widget;
}

function tomk32_widget_search($args) {
	extract($args);
?>
		<?php echo $before_widget; ?>
			<div class="title"><?php _e('Search'); ?></div>
			<form id="searchform" method="get" action="<?php bloginfo('home'); ?>">
			<div>
			<input type="text" name="s" id="s" size="15" /><br />
			<input type="submit" value="<?php _e('Search'); ?>" />
			</div>
			</form>
		<?php echo $after_widget; ?>
<?php
}
function tomk32_theme_widgets() {
	register_sidebar(array(
		'before_widget' => '
<div class="portlet" id="%1$s">',
		'after_widget' => '</div>',
		'before_title' => '
<div class="title">',
		'after_title' => '</div>',
	));

	register_sidebar_widget(__('Links') . ' (TomK32 theme)', 'tomk32_widget_links');
	register_widget_control(__('Links') . ' (TomK32 theme)', 'tomk32_widget_links_control');
	register_sidebar_widget(__('Search') . ' (TomK32 theme)', 'tomk32_widget_search');
	register_sidebar_widget('Theme switcher', 'widget_wp_theme_switcher');

}
add_action('widgets_init', tomk32_theme_widgets);



function tomk32_add_theme_page() {
	if ( $_GET['page'] == basename(__FILE__) ) {
		if ( isset($_REQUEST['createWeblinksPage']) ) {
			$postid = wp_insert_post(Array('post_type' => "page", 'post_status' => "publish",
				'post_title' => __('Weblinks'), 'post_type' => 'page',
				'page_template' => 'weblinks.php'));
			if ($postid > 1)
			update_option('tomk32green_weblinks', $postid);
		}
		if ( isset($_REQUEST['selectWeblinksPage']) ) {
			update_option('tomk32green_weblinks', intval($_REQUEST['selectWeblinksPage']));
			wp_update_post(Array('ID' => intval($_REQUEST['selectWeblinksPage']),
					'page_template' => 'weblinks.php'));
		}
		if (isset($_REQUEST['tomk32_theme_numfullentries']))
			update_option('tomk32_theme_numfullentries', intval($_REQUEST['tomk32_theme_numfullentries']));
		if (is_array($_REQUEST['tomk32_theme_widgets']))
			update_option('tomk32_theme_widgets', $_REQUEST['tomk32_theme_widgets']);
		if ( 'activate_style' == $_REQUEST['action'] ) {
			$styles = tomk32_theme_get_styles();
			if ( isset($styles[$_REQUEST['style']]) ) {
				update_option('tomk32green_colorstyle', $_REQUEST['style']);
			} else echo "Can't activate color style. Sorry guy.";
		}
		elseif ( 'save' == $_REQUEST['action'] ) {
		}
	}
	add_theme_page(__('Configure theme'), __('Configure theme'), 'edit_themes', basename(__FILE__), 'tomk32_theme_page');
}

add_action('admin_menu', 'tomk32_add_theme_page');


function tomk32_theme_page() {
	if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>', __('Modifications have been saved'), '</strong></p></div>';
?>
<div class='wrap'>
<h2><?php _e('General settings'); ?></h2>
<form action="<?php echo $_SERVER['REQUEST_URI']; ?>" method="post">
<fieldset>
<table class="optiontable">
<?php 
$sidebars_widgets = get_option('sidebars_widgets');
if (function_exists('widgets_init') && ! empty($sidebars_widgets)) : 
	$tomk32_theme_widgets = get_option('tomk32_theme_widgets');
?>
	<tr><th scope="row"><label for="tomk32_theme_widgets"><?php _e('Widgets to be fully shown. This works globally and not (yet) per sidebar. The collapsed widgets can be uncollapsed with a click.'); ?></label>
</th><td>
	<fieldset name="tomk32_theme_widgets" id="tomk32_theme_widgets">
<?php foreach ($sidebars_widgets as $sidebar => $s_widgets) : ?>
	<h3><?php echo $sidebar; ?></h3>
	<ul style="list-style: none;">
<?php
	foreach ($s_widgets as $widget) : 
	$checked = "";
	if (isset($tomk32_theme_widgets[$sidebar][$widget])) $checked = 'checked="checked"';
?>
	<li><label><input type="checkbox"<?php echo " $checked"; ?> name="tomk32_theme_widgets[<?php echo $sidebar, '][', $widget;?>]" value="1" /> <?php echo $widget; ?></label></li>
<?php endforeach; ?>
	</ul>
	<?php endforeach; ?>
</fieldset>
	</td></tr>
<?php endif; ?>
<?php $tomk32_theme_numfullentries = get_option('tomk32_theme_numfullentries');
if ($tomk32_theme_numfullentries < 1) $tomk32_theme_numfullentries = 5; ?>
	<tr><th scope="row"><label for="tomk32_theme_numfullentries"><?php _e('How many posts should be fully shown on the frontpage?'); ?></label>
</th><td>
<input name="tomk32_theme_numfullentries" type="text" id="tomk32_theme_numfullentries" value="<?php echo $tomk32_theme_numfullentries; ?>" size="3" /> <?php printf(__('posts of %s'), get_option('posts_per_page')); ?>
	</td></tr>
<?php if (!function_exists('widgets_init') && empty($registered_widgets)) : ?>
	<tr><th scope="row"><label for="createWeblinksPage"><?php _e('Create a page containing all Weblinks'); ?></label>
</th><td>
	<input type="submit" name="createWeblinksPage" value="Create page" />
	</td></tr>
	<tr><th scope="row"><label for="selectWeblinksPage"><?php _e('Select a page to contain all weblinks, this site will be link to from the sidebar. Its page template will be set to weblinks.php automatically but no content will be lost.'); ?></label>
</th><td >
	<select size="3" name="selectWeblinksPage">
<?php
$pages = get_pages(array('sort_column' => 'menu_order'));
$tomk32green_weblinks = get_option('tomk32green_weblinks');

foreach ($pages as $post)
	printf('		<option value="%d"%s>%s</option>
', $post->ID, ($post->ID == $tomk32green_weblinks) ? ' selected="selected"' : '', $post->post_title);
?>
	</select>
</td></tr>
<?php endif; ?>
<tr><td colspan="2">
	<input type="submit" />
</table>
</fieldset>
</form>

<?php
$styles = tomk32_theme_get_styles();
$cur_style = get_option('tomk32green_colorstyle');


if ( ! empty($cur_style)) {
?>
<h2><?php _e("Current style"); ?></h2>
<div id="currenttheme">
	<img src="<?php bloginfo('stylesheet_directory'); echo '/', $styles[$cur_style]['Screenshot']; ?>" alt="<?php _e('Preview of current style'); ?>" />
	<h3><?php printf(__('%s %s by %s'), $styles[$cur_style]['Title'], $styles[$cur_style]['Version'], $styles[$cur_style]['Author']); ?></h3>
	<p><?php echo $styles[$cur_style]['Description']; ?></p>
	<p><?php printf(__('The style file is located at <code>%1$s</code>'), str_replace(ABSPATH, '', get_theme_root()) ."/". get_option('stylesheet') . '/' . $styles[$cur_style]['File']); ?></p>
</div>
<?
}

echo "<h2>", __('Available color styles'), "</h2>\n";
if ( is_array($styles)) {
	foreach ($styles as $style) {
		if ($style['File'] == $cur_style) continue;
		tomk32_theme_display_style($style);
	}
}


$ct = current_theme_info();
?>
<h2><?php _e('More styles'); ?></h2>
	<p><?php printf(__('You can find more styles for this theme and information how to create your own style at the author\'s homepage: %s '), $ct->author); ?></p>

</div>
<?php
}

function tomk32_theme_display_style($style) {
if ( ! is_array($style)) return;
	$activate_link = wp_nonce_url("themes.php?page=functions.php&amp;action=activate_style&amp;style=" . $style['File'], 'switch-theme_' . $template);
	
?>
	<div class="available-theme">
		<h3><a><?php echo $style['Title']; ?></a></h3>
		<a href="<?php echo $activate_link; ?>" class="screenshot">
<img src="<?php bloginfo('stylesheet_directory'); echo '/', $style['Screenshot']; ?>" alt="" />
</a>
		<p><?php echo $style['Description']; ?></p>
	</div>
<?php
}



function tomk32_theme_get_styles() {
	$theme_dir = get_theme_root() ."/". get_option('stylesheet');
	
	$theme_loc = "/" . str_replace(ABSPATH, '', $theme_dir);
	$dir = opendir($theme_dir);
	if ( ! $dir) return sprintf(__("Can't open stylesheet directory '%s'."), $theme_dir);
	$colors = Array();
	while ($file = readdir($dir)) {
		if (substr($file, 0, 6) == "colors") {
			$style = tomk32_theme_get_style($file, $theme_dir);
			if ($style['Status'] == 'publish')
				$colors[$file] = $style;
		}
	}
	return $colors;
}

function tomk32_theme_get_style($file, $theme_dir) {
	preg_match("/colors-(.+).css/", $file, $col);
	$col = $col[1];
	foreach ( array('png', 'gif', 'jpg', 'jpeg') as $ext ) {
		if (file_exists("$theme_dir/screenshot-$col.$ext")) {
		$screenshot = "screenshot-$col.$ext";
		break;
		}
	}
	return (array_merge(get_theme_data($theme_dir."/".$file),
		Array("File" => $file,
			"Color" => $col,
			"Screenshot" => $screenshot
		)
	));
}

/** some Javascript **/
function tomk32_theme_head() {
	global $registered_widgets;
	$sidebar_widgets = get_option('sidebars_widgets');
	if ( empty($sidebar_widgets) || ! function_exists('dynamic_sidebar')) return;


	$tomk32_theme_widgets = get_option('tomk32_theme_widgets');
	echo '<script type="text/javascript" language="Javascript">
$(document).ready( function() {
';
	foreach ($tomk32_theme_widgets as $sidebar => $widgets) {
		foreach ($widgets as $widget => $tmp) {
			if (in_array($widget, $sidebar_widgets[$sidebar])) 
			echo "	$('#" , $registered_widgets[$widget]['id'], " .title').addClass('show');\n";
	}
	}
	echo '});
</script>
';
}

add_action('wp_head', 'tomk32_theme_head');

?>