<?php get_header(); ?>

<!-- start latest post -->
<div id="latest-post" class="wide-post">

	<?php if (have_posts()): the_post(); ?>
	
		<h1 class="title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h1>
		<div class="entry">
			<?php the_excerpt(); ?>
		
			<p>&nbsp;</p>
			<p class="links">
			
				<?php $arc_year = get_the_time('Y'); $arc_month = get_the_time('m'); $arc_day = get_the_time('d'); ?>
				<a href="<?php echo get_day_link("$arc_year", "$arc_month", "$arc_day"); ?>" class="date"><?php the_time('F jS, Y'); ?></a>
				
				&nbsp;&nbsp;&nbsp;&nbsp;
				
				<span class="author"><?php the_author_posts_link(); ?></span>
				
				&nbsp;&nbsp;&nbsp;&nbsp;
				
				<?php comments_popup_link('No Comments', '1 Comment', '% Comments', 'comments'); ?>
				( <span class="feeds"><?php comments_rss_link('RSS'); ?></span> )
				
			</p>
		</div>
	
	<?php else : ?>
	
		<h1 class="title">Not Found</h1>
		<div class="entry">
			<p>Sorry, but you are looking for something that isn't here.</p>
		</div>
	
	<?php endif; ?>
	
	<div class="bottom"></div>
</div>
<!-- end latest post -->

<!-- start recent posts & comments -->
<div class="two-columns">
	<ul id="recents">
		<?php if (!function_exists('dynamic_sidebar') || !dynamic_sidebar('RecentPostsCommentsBox')): ?>
			<li>Please put the 'Recent Posts' and 'Recent Comments' widgets here.</li>
		<?php endif; ?>
	</ul>
</div>
<!-- end recent posts & comments -->

<?php get_sidebar(); ?>

<?php get_footer(); ?>
