<?php get_header();?>
	<div id="content">
	 <?php if (have_posts()) : ?>
		<?php while (have_posts()) : the_post(); ?>
		<div class="post">
			<p class="posted">Published by <?php the_author(); ?> on <?php the_time('d M Y'); ?> at <?php the_time('h:i a')?> <?php edit_post_link('[edit this]'); ?></p>
			<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link: <?php the_title(); ?>"><?php the_title(); ?></a></h2>
			<div class="post-content">
				<?php the_content("Continue Reading &#187;"); ?>
				<?php wp_link_pages(); ?>
				<?php $sub_pages = wp_list_pages( 'sort_column=menu_order&depth=1&title_li=&echo=0&child_of=' . $id );?>
				<?php if ($sub_pages <> "" ){?>
					<p class="posted">This page has the following sub pages.</p>
					<ul><?php echo $sub_pages; ?></ul>
				<?php }?>
				<!--
					<?php trackback_rdf(); ?>
				-->
			</div>
			<p class="post-meta">
				<span class="comments"><?php comments_number(__('No Comments Yet'), __('One Comment'), __('% Comments')); ?></span>
				<span class="category"><?php the_category(',');?></span> 
		    </p>
			<?php comments_template(); ?>
		</div>
		<?php endwhile; ?>
			<p align="center"><?php posts_nav_link(' - ','&#171; Prev','Next &#187;') ?></p>		
		<?php else : ?>
		<h2 class="center">Not Found</h2>
		<p class="center">Sorry, but you are looking for something that isn't here.</p>		
	<?php endif; ?>
	</div>
	<?php get_sidebar();?>
<?php get_footer();?>