function AjaxComment(form) {
	var url = '/wordpress/wp-content/themes/imedia/comments-ajax.php';
	if (!$('commentlist')) { new Insertion.Before('pinglist', '<div id="commentlist"></div>'); };
	new Ajax.Updater( {
		success: 'commentlist',
		failure: 'error'
	}, url, {
		asynchronous: true,
		evalScripts: true,
		insertion: Insertion.Bottom,
		onLoading: function() { 
			Effect.Fade('submit', {duration: 0.5, queue: {position: 'front', scope: 'comment'}});
			Effect.Appear('commentload', {duration: 0.5, queue: {position: 'end', scope: 'comment'}});
		//	$('commentload').show();
			$('error').update('');
			$('error').setStyle( { visibility: 'hidden' } );
			Form.disable('respond');
		},
		onComplete: function(request) {
 			if (request.status == 200) {				
				if ($('leavecomment')) { $('leavecomment').remove(); }
				new Effect.Appear($('commentlist').lastChild, { duration: 1.0, afterFinish: function() { new Effect.ScrollTo($('commentlist').lastChild); } } );
				if ($('cmtnum')) { $('cmtnum').innerHTML = parseInt($('cmtnum').innerHTML) + 1; }
				Field.clear('comment');
				Form.disable('respond');
				setTimeout('Form.enable("respond")',15000);
			}
  		//	Element.hide('commentload');
			
			Effect.Fade('commentload', {duration: 0.5, queue: 'end'});
		},
		onFailure: function() {
			Effect.Fade('commentload', {duration: 0.5, queue: {position: 'front', scope: 'commenterror'}});
			$('error').setStyle( { visibility: 'visible' } );
			Effect.Appear('submit', {duration: 0.5, queue: {position: 'end', scope: 'commenterror'}});
			Effect.Appear('error', {duration: 0.5, queue: {position: 'end', scope: 'commenterror'}});
		//	$('error').show();
						Form.enable('respond');
		},
		parameters: Form.serialize(form) 
		}
	);
}

function initComment() {
	if ($('respond')) {
		$('respond').onsubmit = function() { AjaxComment(this); return false; };
		new Insertion.After('submit', '<span id="error"></span>');
		new Insertion.After('submit','<img src="/wordpress/wp-content/themes/imedia/images/spinner.gif" id="commentload" />');
		$('commentload').hide();
		$('error').hide();
	}
}

Event.observe(window, 'load', initComment, false);