<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head profile="http://gmpg.org/xfn/11">
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />

	<title><?php bloginfo('name'); ?><?php wp_title(); ?></title>
	
	<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" /> <!-- leave this for stats -->

	<style type="text/css" media="screen">
		@import url( <?php bloginfo('stylesheet_url'); ?> );
	</style>
	
	<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="alternate" type="text/xml" title="RSS .92" href="<?php bloginfo('rss_url'); ?>" />
	<link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

	<?php wp_get_archives('type=monthly&format=link'); ?>

	<?php wp_head(); ?>
</head>
<body>
	
<div id="wrapper">
	
		<div id="header">
			
			<div id="headerleft">
				<h1><a href="<?php echo get_settings('home'); ?>/"><?php bloginfo('name'); ?></a></h1>
				<div class="description"><?php bloginfo('description'); ?></div>
			</div>
			
			<div id="headerright">
				<div id="navcontainer">
				<ul id="navlist">
				<li><a href="#">Home</a></li>
				<li><a href="#">Archives</a></li>
				<li><a href="#">About</a></li>
				<li><a href="#">contact</a></li>
				</ul>
				</div>
			</div>
			<div class="clearing"></div>
		</div>
		
<?php /* End of header */ ?>

<?php	/* starting index */ ?>

<?php get_header(); ?>		
<?php if (have_posts()) : ?>

	<?php $post = $posts[0]; // Thanks Kubrick for this code ?>
	
	<?php if (is_category()) { ?>				
	<h2><?php _e('Archive for'); ?> <?php echo single_cat_title(); ?></h2>
	
  	<?php } elseif (is_day()) { ?>
	<h2><?php _e('Archive for'); ?> <?php the_time('F j, Y'); ?></h2>
	
 	<?php } elseif (is_month()) { ?>
	<h2><?php _e('Archive for'); ?> <?php the_time('F, Y'); ?></h2>

	<?php } elseif (is_year()) { ?>
	<h2><?php _e('Archive for'); ?> <?php the_time('Y'); ?></h2>

	<?php } elseif (is_author()) { ?>
	<h2><?php _e('Author Archive'); ?></h2>

	<?php } elseif (is_search()) { ?>
	<h2><?php _e('Search Results'); ?></h2>

	<?php } ?>
	
		<div id="main">
			<?php query_posts('showposts=3'); ?>	
					<?php while (have_posts()) : the_post(); ?>



			<div class="maintitle"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php _e('Permanent link to'); ?> <?php the_title(); ?>"><?php the_title(); ?></a><span class="comment"><?php comments_popup_link(__('0'), __('1'), __('%'), __('Closed')); ?></span></div>
			<div class="postdata">Posted on <?php the_time('m-d-Y') ?><?php _e(' under'); ?><?php the_category(', ') ?></div>
			
			<?php if (is_search()) { ?>
								<?php the_excerpt() ?>
							<?php } else { ?>
								<?php the_content(__('Read the rest of this entry &raquo;')); ?>
							<?php } ?>
			

			<!--
							<?php trackback_rdf(); ?>
							-->


			<?php endwhile; ?>



				<?php else : ?>
			<div align="center">
					<h2><?php _e('Not Found'); ?></h2>

					<p><?php _e('Sorry, but no posts matched your criteria.'); ?></p>

					<h3><?php _e('Search again?'); ?></h3>

					<?php include (TEMPLATEPATH . '/searchform.php'); ?>
			</div>
				<?php endif; ?>	
			
			
		</div>
			

<?php get_sidebar(); ?>

<?php get_footer(); ?>				

<?php	/* End of index */ ?>
<?php	/* Start sidebar */ ?>

<?php	/* End of sidebar */ ?>		
		
<?php	/* Start footer */ ?>
	<div id="footer">
<p>

<?php _e('Design by'); ?> <a href="http://www.xiapdesign.com/" title="Design par XiAP">XiAP
Design Studio</a> and <?php echo sprintf(__("powered by <a href='http://wordpress.org/' title='%s'><strong>WordPress</strong></a>"), __("Powered by WordPress, state-of-the-art semantic personal publishing platform.")); ?>. All contents copyrighted &copy; to P. Lassus 2006. 



<a href="http://jigsaw.w3.org/css-validator/validator?uri=http://xiapdesign.com/in/wp-content/themes/Pantone/style.css"><?php _e('<abbr title="Cascading Style Sheets">Validated CSS</abbr>'); ?></a>.
</p>
	</div>

</div>

<?php do_action('wp_footer'); ?>

</body>
</html>



<?php	/* End of footer */ ?>
