<?php
/*
Plugin Name: SimpleTags
Plugin URI: http://www.broobles.com/scripts/simpletags/
Description: Allows you to create a list of Technorati tags at the bottom of your post by providing a comma separated list of tags between the [tags] tags. You can use it with any blogging tool/method, not just when posting from WordPress itself (doesn't use custom fields). Supports multiple words within tags. Also allows in-post tagging of words by enclosing them in [tag] tags. Works with the WYSIWYG editor.
Version: 2.0
Date: January 3rd, 2006
Author: Broobles
Author URI: http://www.broobles.com
Contributors: Artur Ortega, Elias Schwerdtfeger <elias@weltretter.de>
*/ 

// Change these if you want something else to appear before and after the tags.
// Leave them blank ("") if you don't want any text to appear around the tags.
// <p> tags added in 1.2 for backward compatibility with previous versions.
$pre_replacement = '<p>Technorati Tags: ';
$post_replacement = '</p>';
// If you want to use the tags inside a div, you can do something like this:
// $pre_replacement = '<div class="simpletags">Technorati Tags: ';
// $post_replacement = '</div>';

$tag_url = "http://technorati.com/tag/";

function simpleTags($text) {
    
    global $tag_url;
    global $pre_replacement;
    global $post_replacement;
    
    $tag_pattern = '/(\[tag\](.*?)\[\/tag\])/i';
    // Following line used to be:
    // $tags_pattern = '/(\[tags\](.*?)\[\/tags\])/i'; 
    // Enhanced by Elias Schwerdtfeger in 1.2 to remove the superflous paragraph 
    // generated by WordPress and allow for valid XHTML (if you use divs, 
    // they would be enclosed withing a paragraph which is invalid).
    // For backward compatibility, we've added <p> and </p> to $pre_replacement
    // and $post_replacement respectively.
    $tags_pattern = '/((?:<p>)?\s*\[tags\](.*?)\[\/tags\]\s*(?:<\/p>)?)/i'; 
    
    $tags_count = 0;       
    $taglist_exists = 0;    # Set to 1 if the tags list is present
    
    # Check for in-post [tag] [/tag]
    if (preg_match_all ($tag_pattern, $text, $matches)) {
        unset($technotags);
        $technotags = $pre_replacement;
        for ($m=0; $m<count($matches[0]); $m++) {
            unset($ttags);
            $ttags = explode(",", $matches[2][$m]);
            for ($i=0; $i<count($ttags); $i++) {
                $technotags .= '<a href="' . $tag_url . urlencode(trim($ttags[$i])) . '" rel="tag">' . trim($ttags[$i]) . '</a>';
                if ($i<count($ttags)-1) {$technotags.= ", "; }
                $tags_count += 1;
            }
            $text = str_replace($matches[0][$m],$matches[2][$m],$text);
            if ($m<count($matches[0])-1) {$technotags.= ", "; }
        } 
    }
    
    # Check for [tags] [/tags]
    if (preg_match ($tags_pattern, $text, $matches)) {
        $taglist_exists = 1;
        if ($tags_count==0) { 
            $technotags = $pre_replacement; 
        } else { 
            $technotags .= ", "; 
        }
        
        unset($ttags);
        $ttags = explode(",", $matches[2]);
        for ($i=0; $i<count($ttags); $i++) {
            $technotags .= '<a href="' . $tag_url . urlencode(trim($ttags[$i])) . '" rel="tag">' . $ttags[$i] . '</a>';
            if ($i<count($ttags)-1) { $technotags .= ", "; }
            $tags_count += 1;
        }
    }
    
    # If tags were found, include them in the post
    if ($tags_count>0) {
        $technotags .= $post_replacement;
        if ($taglist_exists == 1) { 
            $text = preg_replace($tags_pattern,$technotags,$text); 
        } else {
            $text .= $technotags;
        }
    }
    
    return $text;
}

add_filter('the_content', 'simpleTags');

?>
