
<?php get_header(); ?>

<div id="contentwrapper">
    <div id="leftcolumn">
        <div id="topleftboxcontainer">
        <?php if (have_posts()) : ?>            
            <?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
            <div class="contentboxtabs">
                <ul>                        
                    <li><a href="javascript:void(null)" class="selected">
                        <?php /* If this is a category archive */ if (is_category()) { ?>               
                        <?php echo single_cat_title(); ?> Archive

                        <?php /* If this is a daily archive */ } elseif (is_day()) { ?>
                        <?php the_time('F jS, Y'); ?> Archive

                        <?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
                        <?php the_time('F, Y'); ?> Archive

                        <?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
                        <?php the_time('Y'); ?> Archive

                        <?php /* If this is a search */ } elseif (is_search()) { ?>
                        Search Results

                        <?php /* If this is an author archive */ } elseif (is_author()) { ?>
                        Author Archive

                        <?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
                        Blog Archives                        
                    <?php } ?></a></li>                        
                </ul>
            </div>
            <div class="contentbox">
                <div id="postbox">                                
                        <?php while (have_posts()) : the_post(); ?>

                            <div class="post" id="post-<?php the_ID(); ?>">
                                <div class="postdate"><?php the_time('F jS, Y') ?></div>
                                <h1 class="posttitle"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a>
                                </h1>
                                <div class="postauthor"><img src="<?php bloginfo('stylesheet_directory'); ?>/images/author.png" alt="author" style="vertical-align: middle;" /> <?php the_author() ?></div>
                                <div class="postcomments"><?php edit_post_link('Edit', '', ' | '); ?>  <?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?></div>
                                <div class="postcats"><img src="<?php bloginfo('stylesheet_directory'); ?>/images/tag.png" alt="categories" style="vertical-align: middle;" /> <?php the_category(','); ?></div>
                                <div class="postcontent">
                                    <?php the_content('Read the rest of this entry &raquo;'); ?>
                                </div>
                            </div>

                        <?php endwhile; ?>
                            <div class="navigation">
                                <div class="alignleft"><?php next_posts_link('&laquo; Previous Entries') ?></div>
                                <div class="alignright"><?php previous_posts_link('Next Entries &raquo;') ?></div>
                            </div>
                    <?php else : ?>

                        <h2 class="center">Not Found</h2>
                        <p class="center">Sorry, but you are looking for something that isn't here.</p>

                    <?php endif; ?>                        
                </div>                    
            </div>
        </div>

        <div id="bottomleftboxcontainer">
            <div class="contentboxtabs">
                <ul>                        
                    <li><a href="javascript:void(null)" class="selected">Recent Posts</a></li>
                </ul>
            </div>
            <div class="contentbox">
                <div id="recentpostbox">
                    <ul>
                        <?php                                
                            query_posts('showposts=10');
                        ?>                            
                        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                            <li><span class="recentpostheader"><span class="recentpostdate"><?php the_time('M j') ?></span> | <a href="<?php the_permalink() ?>"><?php the_title() ?></a></span>
                            <span class="recentpostinfo"><?php edit_post_link('Edit', '', ' | '); ?>  <?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?></span></li>
                        <?php endwhile; endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div> <!-- LEFTCOLUMN --> 
    
    <?php get_sidebar(); ?>
    
</div> <!-- CONTENTWRAPPER --> 
        
<?php get_footer(); ?>