<?php
/*
Plugin Name: fGallery
Plugin URI: http://www.fahlstad.se
Description: Image gallery plugin
Author: Fredrik Fahlstad
Version: 0.2
Author URI: http://www.fahlstad.se
*/
$version = "0.2";
require_once("functions/fim_functions.php");

// Some global stuff
global $wpdb;
$site = get_bloginfo('siteurl');
$image_folder = get_bloginfo('wpurl')."/wp-content/fgallery_images/";
$thumbs_folder = get_bloginfo('wpurl')."/wp-content/fgallery_thumbs/";

// Bug fix
require_once(ABSPATH . 'wp-includes/streams.php');
require_once(ABSPATH . 'wp-includes/gettext.php');

// Load language pack
$lang = get_option('fim_lang');
if($lang != '')
	load_textdomain('fgallery', ABSPATH . 'wp-content/plugins/fgallery/languages/'.$lang);

/***************************************************************/
// Callable from user template
/***************************************************************/
function fim_random_images($num = '1', $size = "")
{
	$size = ($size == "")?get_option('fim_th_size'):$size;
	fim_get_random($num, $size);
}
function fim_get_latest_images($num = '1', $size = "")
{
	$size = ($size == "")?get_option('fim_th_size'):$size;
	fim_get_latest($num, $size);
}
/***************************************************************/
// End callable from user template
/***************************************************************/

// Include CSS
function fim_css()
{	
?>
<link rel="stylesheet" type="text/css" href="<?php echo get_bloginfo('wpurl')."/wp-content/plugins/fgallery/css/fim_style.css";?>" />

<?php if(get_option('fim_use_lightbox') == 'true') 
{ ?>
<script type="text/javascript" src="<?php echo get_bloginfo('wpurl')."/wp-content/plugins/fgallery/lightbox/js/prototype.js";?>"></script>

<script type="text/javascript" src="<?php echo get_bloginfo('wpurl')."/wp-content/plugins/fgallery/lightbox/js/scriptaculous.js?load=effects";?>"></script>
<script type="text/javascript" 	src="<?php echo get_bloginfo('wpurl')."/wp-content/plugins/fgallery/lightbox/js/lightbox.js";?>"></script>

<link rel="stylesheet" href="<?php echo get_bloginfo('wpurl')."/wp-content/plugins/fgallery/lightbox/css/lightbox.css";?>" type="text/css" />
<?php
}
}

// Get css for resetting
function fim_get_css()
{
	return "
.fim {
	padding: 0px;
	margin: 0px;
	clear: both;
	width: 99%;
	min-width: none;
}
h3.fim-nav {
	padding:0px;
	margin:0px;
		border-bottom: 1px dashed #CCC;
}
.fim-album {
	clear: both;
	margin-top:20px;
}
.fim-title {
	color: #260;
	border-bottom: 1px dashed #CCC;
	margin: 0px 0px 0px 0px;
	padding: 0px 0px 0px 0px;
}
.fim-meta {
	margin: 0px 0px 5px 0px;
}
.fim-album-description {
	font-size: 11px;
	margin-top: 10px;
	margin-bottom: 10px;
}
.fim-tn-border-album {
	float: left;
	margin-top: 0px;
	margin-right: 4px;
	margin-bottom: 8px;
	margin-left: 4px;
	width:120px;
	height:120px;
}
.fim-tn-border-sidebar{
	float: left;
	margin-top: 0px;
	margin-right: 4px;
	margin-bottom: 8px;
	margin-left: 4px;
}
.fim-thumbnail {
	float: left;
	background: url(images/shadow.gif) no-repeat bottom right;
	float: left;
	margin: 5px 0px 0px 6px;
 	padding: 0px 0px 0px 0px;
}

.fim-thumbnail img {
		 background-color: #fff;
	 border: 1px solid #a9a9a9;
	 display: block;
	 margin: -5px 5px 5px -5px;
	 padding: 4px;
	 position: relative;
}
.fim-thumbnail img:hover {
	background-color: #ccd;
}

/*********************************************/
/* Image */
/*********************************************/

.fim-photo-block {
	float: left;
	margin: 10px 5px 10px 5px;
}
.fim-photo {
	background: url(images/shadow.gif) no-repeat bottom right;
	float: left;
}
.fim-photo img {
	 background-color: #fff;
	 border: 1px solid #a9a9a9;
	 display: block;
	 margin: -5px 5px 5px -5px;
	 padding: 4px;
	 position: relative;
}
.fim-photo-date{
	margin:0px;
	padding:0px;
}
/*********************************************/
/* Navigation */
/*********************************************/
.fim-photo-nav{
	width:99%;
	padding-top:15px;
	padding-bottom:15px;
}
.fim-nav-buttons{
	height:20px;
	float:left;
	text-align:center;
	border:1px solid #ccc;
	background:#F4F4F4;
	margin-top: 5px;
	margin-right: 10px;
	margin-bottom: 5px;
	margin-left: 10px;
	padding-top: 5px;
	padding-right: 10px;
	padding-bottom: 5px;
	padding-left: 10px;
}
/*********************************************/
/* Misc */
/*********************************************/

.fim_clear{
	clear:both;
}
";
}


// create new table
function fim_install () {

	global $table_prefix, $wpdb, $user_level;
	$table_name_images = $table_prefix . "fim_images";
	$table_name_cat = $table_prefix . "fim_cat";

	get_currentuserinfo();

	if ($user_level < 8)
	{
		return;
	}
	else
	{
		$sql = "CREATE TABLE ".$table_name_images." (
				id smallint(11) NOT NULL auto_increment,
				image varchar(255) default NULL,
				date datetime default NULL,
				title varchar(255) default NULL,
				description TEXT default NULL,
				cat varchar(10)  NOT NULL,
				status varchar(50) default 'include',
				PRIMARY KEY id (id)
				);";

		$sql2 =	"CREATE TABLE ".$table_name_cat." (
				catname VARCHAR(255) NOT NULL ,
				id INT NOT NULL AUTO_INCREMENT ,
				date datetime default NULL,
				description TEXT NOT NULL ,
				folder VARCHAR (255) NOT NULL,
				cover varchar(50) default '',
				PRIMARY KEY id (id)
				);";
	}
	require_once(ABSPATH . 'wp-admin/upgrade-functions.php');
	dbDelta($sql);
	dbDelta($sql2);
}

// Init
function fim_init()
{
	if (function_exists('add_menu_page')) {

		add_menu_page('fGallery', 'fGallery',6,dirname(__FILE__).'/functions/fim_main.php');

	}

	if (function_exists('add_submenu_page')) {

		add_submenu_page( dirname(__FILE__).'/functions/fim_main.php',
				__('Manage albums',
				'fgallery'),
				__('Manage albums',
				'fgallery'),
				6,
				dirname(__FILE__).'/functions/fim_gallery.php');

		add_submenu_page( dirname(__FILE__).'/functions/fim_main.php',
				__('Options',
				'fgallery'),
				__('Options',
				'fgallery'),
				6,
				dirname(__FILE__).'/functions/fim_options.php');

		add_submenu_page( dirname(__FILE__).'/functions/fim_main.php',
				__('Edit css',
				'fgallery'),
				__('Edit css',
				'fgallery'),
				6,
				dirname(__FILE__).'/functions/fim_edit_style.php');



	}
 }
 function fim_admin_head()
 {
 ?>
 		<script type='text/javascript' src="<?php echo get_bloginfo('wpurl')."/wp-content/plugins/fgallery/js/multifile.js"?>"></script>

<?php
}
// Hooks and filters
if (isset($_GET['activate']) && $_GET['activate'] == 'true')
{
	add_action('init', 'fim_install');
}

function fim_action_parse_query($wp_query) {
  if (defined('FIM') && constant('FIM')) {
    $wp_query->is_404 = false;
  }
}
add_action('parse_query', 'fim_action_parse_query');

add_action('admin_menu', 'fim_init');
add_filter('wp_head', 'fim_css');
add_filter('admin_head','fim_admin_head');
?>
