<?php
//require_once("class.imageMod.php");

/*Lets add some default options if they don't exist*/
add_option('fim_th_size', '128');
add_option('fim_image_size', '400');
add_option('fim_page', 'none');
add_option('fim_resize', 'true');
add_option('fim_num_th', '0');
add_option('fim_lang'. '');
add_option('fim_use_fancy_url', 'false');
add_option('fim_baseurl', 'photos');
add_option('fim_use_lightbox', 'false');

require_once("fim_functions.php");
function fim_rewrite_rule()
{
    // Complete url
    $url = get_bloginfo('wpurl');
    $urlparts = parse_url($url);
	$base = get_option('fim_baseurl');
	$rewrite = "# BEGIN FGALLERY\n<IfModule mod_rewrite.c>\nRewriteEngine On\nRewriteRule ^$base/?([^/]*)?/?([^/]*)?/?([^/]*)?/?([^/]*)?/?$   $urlparts[path]/wp-content/plugins/fgallery/fim_photos.php?$1=$2&$3=$4 [QSA,L]\n</IfModule>\n# END FGALLERY";
	
	return $rewrite;
}
if(isset($_POST['rewrite']))
{
	$url = $_POST['baseurl'];
	$url = strtolower($url);
	$url = str_replace(" ", "_", $url); 
	update_option('fim_baseurl', $url);
	$file = "../.htaccess";

	if(is_writable($file))
	{
		$content = file_get_contents ($file);
		$content = preg_replace("/(# BEGIN FGALLERY)(\n+.*)*(# END FGALLERY)/", "", $content);
				
		$content = fim_rewrite_rule().$content;
		$f = fopen("../.htaccess", "w");
		fwrite($f, $content);
		fclose($f);
		//echo "<pre>$content</pre>";
		echo "<div class='updated fade' id='message'><p>".__('Mod ReWrite rules successfully updated', 'fgallery').".</p></div>";

	}
	else
	{	
		?><div class="wrap">
		<h2><?php _e("Add ReWrite rules", 'fgallery');?></h2>
		<?php _e(".htaccess is not writable so you have to add add the following manually", 'fgallery');
		echo "<p>".__('This should be at the TOP of your .htacces file before the WordPress rules', 'fgallery').".</p>";?>
		<textarea cols="100" rows="5" wrap="off"><?php echo fim_rewrite_rule(); ?></textarea></div><?php
	}

}
if(isset($_POST['option_update']))
{
	if($_POST['fim_resize'] == "true")
		update_option('fim_resize', 'true');
	else
		update_option('fim_resize', 'false');
	
	if($_POST['fim_use_fancy_url'] == "true")
		update_option('fim_use_fancy_url', 'true');
	else
		update_option('fim_use_fancy_url', 'false');
		
	if($_POST['fim_use_lightbox'] == "true")
		update_option('fim_use_lightbox', 'true');	
	else
		update_option('fim_use_lightbox', 'false');
		
	update_option('fim_th_size', $_POST['fim_th_size']);
	update_option('fim_image_size', $_POST['fim_image_size']);
	update_option('fim_page', $_POST['fim_page']);
	update_option('fim_lang', $_POST['fim_lang']);
	update_option('fim_num_th', $_POST['fim_num_th']);

	echo "<div class='updated fade' id='message'><p>".__('Options updated', 'fgallery').".</p></div>";
}
/*
if(isset($_POST['resize_all']))
{
	$dirs = fim_get_all_folders();
	$path = "../wp-content/fgallery/";
	$files = array();
	if($_POST['fim_resize'] == "true")
		update_option('fim_resize', 'true');
	else
		update_option('fim_resize', 'false');
	
	if($_POST['fim_use_fancy_url'] == "true")
		update_option('fim_use_fancy_url', 'true');
	else
		update_option('fim_use_fancy_url', 'false');

	update_option('fim_th_size', $_POST['fim_th_size']);
	update_option('fim_image_size', $_POST['fim_image_size']);
	update_option('fim_page', $_POST['fim_page']);
	update_option('fim_lang', $_POST['fim_lang']);
	update_option('fim_num_th', $_POST['fim_num_th']);
	$thw = get_option('fim_th_size');
	foreach($dirs as $dir)
	{
		if (is_dir($path.$dir->folder)) 
		{
			if ($dh = opendir($path.$dir->folder)) 
			{
				while (($file = readdir($dh)) !== false) 
				{
					if($file != "." && $file != ".." && (substr($file, 0, 6) == "thumb_"))
					array_push($files, $file);
				}
				closedir($dh);
			}
		}
		foreach($files as $f)
		{
			//$resize = new imageMod($path.$dir->folder."/",$f, 'normal', $thw, $thw, 50);
			//$resize->resize();
			echo $path.$dir->folder."/".$f."<br>";
		}
	}
	echo "<div class='updated fade' id='message'><p>".__('Options updated', 'fgallery')."</p></div>";

}
*/
?>

<?php
	$dir = "../wp-content/plugins/fgallery/languages/";
	$ext = ".mo";
	$files = array();
// Open a known directory, and proceed to read its contents
	if (is_dir($dir))
	{
		if ($dh = opendir($dir)) 
		{
			while (($file = readdir($dh)) !== false) 
			{
				$ext = ereg_replace("^.+\\.([^.]+)$", "\\1", $file);
				if($ext == "mo")					
				array_push($files, $file);
			}
			closedir($dh);
		}
}
?>

<div class=wrap>
  <h2><?php _e('fGallery options', 'fgallery');?></h2>
	  <form method="post">
		<h3><?php _e('Album options', 'fgallery');?></h3>
		<table cellpadding="3" cellspacing="0">
		  	<tr>
		    <td align="right" ><strong><?php _e('Use nice urls', 'fgallery');?>:</strong></td>
		  	<td><input type="checkbox" name="fim_use_fancy_url" value="true" <?php echo get_option('fim_use_fancy_url') == 'true'?"CHECKED":"";?>/></td>
	      </tr>
	      
	      <tr>
		    <td align="right" ><strong><?php _e('Use Lightbox', 'fgallery');?>:</strong></td>
		  	<td><input type="checkbox" name="fim_use_lightbox" value="true" <?php echo get_option('fim_use_lightbox') == 'true'?"CHECKED":"";?>/></td>
	      </tr>
	      
				<tr>
		    <td align="right" ><strong><?php _e('Resize images','fgallery'); ?>:</strong></td>
		    <td><input type="checkbox" name="fim_resize" value="true" <?php echo get_option('fim_resize') == 'true'?"CHECKED":"";?>/></td>
	      </tr>
		  <tr>
			<td align="right" ><strong><?php _e('Thumbnail size', 'fgallery'); ?>:</strong></td>
			<td><input type="text" name="fim_th_size" size="10" value="<?php echo get_option('fim_th_size'); ?>"> 
			  px </td>
		  </tr>
		  <tr>
			<td align="right" ><strong><?php _e('Image size', 'fgallery'); ?>:</strong></td>
			<td><input name="fim_image_size" type="text" size="10" value="<?php echo get_option('fim_image_size'); ?>"> 
			  px </td>
		  </tr>
	
		</table>
		<h3> <?php _e('Language options', 'fgallery');?></h3>
		
		<?php
			$lang = get_option('fim_lang');
			
			echo "<p>".__('Choose language file', 'fgallery')."</p>";
		?>

		<select name="fim_lang">
			<?php
				foreach($files as $f)
				{
					if($lang == $f)
						echo "<option selected value='$f'>$f</option>";
					else
						echo "<option value='$f'>$f</option>";
				}
				if($lang == "")
						echo "<option selected value=''>Default (English)</option>";
				else
						echo "<option value=''>Default (English)</option>";
					
			?>
		</select>		
		<?php
			if(get_option('fim_use_fancy_url') == "true"){
				$rule = fim_rewrite_rule();
				echo "<h3>".__('Rewrite rules', 'fgallery')."</h3>";
					?>
					<table cellpadding="3" cellspacing="0">
					<tr>
						<td align="right"><strong><?php _e('Base url','fgallery');?>:</strong></td>
						<td><input type="text" name="baseurl" size="32" value="<?php echo get_option('fim_baseurl')?>"/></td>
					</tr>
					<tr>
						<td>&nbsp;</td>
						<td><input type="submit" name="rewrite"value="<?php _e('Update Mod ReWrite','fgallery');?>" /></td>
					</tr>
					<tr>
						<td colspan="2">
						<?php echo __('The link to the fgallery page is', 'fgallery');?>
						<a href="<?php echo get_bloginfo('wpurl')."/".get_option('fim_baseurl')?>"><?php echo get_bloginfo('wpurl')."/".get_option('fim_baseurl');?></a>
						</td>
					</tr>
					</table>
		<?php
					
			}
?>

		<div class="submit">
		  <input type="submit" name="option_update" value="<?php _e('Update options', 'fgallery')?> &raquo;" /><!--<input type="submit" name="resize_all" value="<?php _e('Resize all thumbnails', 'fgallery')?> &raquo;" />-->
		</div>
	  </form>
	  
</div>
