<?php

/* you need to specify the name as the widget was registered, and the callback for the widget */
function _widget_get_default_args($funcname,$name) {

	$id = sanitize_title($name);

	/* BUGBUGBUG FIXME */
	/* this doesn't cope with the fact that other default widget args may have been specified in register_sidebar */
	$default_widget_args = array(
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h2 class="widgettitle">',
		'after_title' => '</h2>');

	$default_widget_args["before_widget"] = sprintf($default_widget_args["before_widget"],$id,$funcname);
	
	return $default_widget_args;

}

function widget_execute_standalone($funcname,$name) {
	$funcname(_widget_get_default_args($funcname,$name));
}

/* widget definitions */

function widget_about_this_page($args) {
    extract($args);
?>
	<?php echo $before_widget; ?>

	<?php echo $before_title . 'About this page' . $after_title; ?>

	<?php /* If this is a 404 page */ if (is_404()) { ?>
	<p>This is a server-generated error page at the <a href="<?php echo get_settings('siteurl'); ?>"><?php bloginfo('name'); ?></a>.</p><p><?php echo revvedup_get_http_error_description(); ?></p>
	<?php /* If this is a single post */ } elseif (is_single()) { ?>
	<p><?php if (function_exists('jp_bct')) { jp_bct($root='/', $showhome=TRUE, $before='<span id="bct">This is ',$after="</span>",$divider=" &raquo; ",$eachlink='<a href="%url%" title="Browse to: %name%">%name%</a>',$current="<em>%name%</em>",$homename=get_settings('blogname')); echo " &ndash; "; } else { ?>You are currently reading <?php } ?> an <a href="<?php the_archives_permalink(); ?>">archived</a> article from <a href="<?php echo get_settings('siteurl'); ?>"><?php bloginfo('name'); ?></a>.</p>

	<?php /* If this is a category archive */ } elseif (is_category()) { ?>
	<p>You are currently browsing the <a href="<?php echo get_settings('siteurl'); ?>"><?php bloginfo('name'); ?></a> weblog <a href="<?php the_archives_permalink(); ?>">archives</a> for the <?php single_cat_title(''); ?> category.</p>
	
	<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
	<p>You are currently browsing <a href="<?php echo get_settings('siteurl'); ?>"><?php bloginfo('name'); ?></a> weblog <a href="<?php the_archives_permalink(); ?>">archives</a>
	for the day <?php the_time('l, F jS, Y'); ?>.</p>
	
	<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
	<p>You are currently browsing <a href="<?php echo get_settings('siteurl'); ?>"><?php bloginfo('name'); ?></a> weblog <a href="<?php the_archives_permalink(); ?>">archives</a>
	for <?php the_time('F, Y'); ?>.</p>


	<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
	<p>You are currently browsing <a href="<?php echo get_settings('siteurl'); ?>"><?php bloginfo('name'); ?></a> weblog <a href="<?php the_archives_permalink(); ?>">archives</a>
	for the year <?php the_time('Y'); ?>.</p>
	
	<?php /* If this is a search result */ } elseif (is_search()) { ?>
	<p>You have searched <a href="<?php echo get_settings('siteurl'); ?>"><?php bloginfo('name'); ?></a> weblog <a href="<?php the_archives_permalink(); ?>">archives</a>
	for <strong>'<?php echo wp_specialchars($s); ?>'</strong>. If you are unable to find anything in these search results, you should try one of the hyperlinks in this sidebar.</p>

	<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
	<p>You are currently browsing <a href="<?php echo get_settings('siteurl'); ?>"><?php bloginfo('name'); ?></a> weblog <a href="<?php the_archives_permalink(); ?>">archives</a>.</p>

	<?php /* If this is the archives master page */ } elseif (is_archives_page()) { ?>
	<p>You are currently viewing the complete <a href="<?php the_archives_permalink(); ?>">archives</a> for <a href="<?php echo get_settings('siteurl'); ?>"><?php bloginfo('name'); ?></a>.</p>

	<?php /* If this is the archives master page */ } elseif (is_directory_index()) { ?>
	<p>You are currently viewing the contents of a folder in <a href="<?php echo get_settings('siteurl'); ?>"><?php bloginfo('name'); ?></a>.</p>

	<?php /* If this is a page, not a post */ } elseif (is_page()) { ?>
		<p><?php if (function_exists('jp_bct')) { jp_bct($root='/', $showhome=TRUE, $before='<span id="bct">This is ',$after="</span>",$divider=" &raquo; ",$eachlink='<a href="%url%" title="Browse to: %name%">%name%</a>',$current="<em>%name%</em>",$homename=get_settings('blogname')); echo " &ndash; "; } else { ?>You are currently reading <?php } ?> a Web page in <a href="<?php echo get_settings('siteurl'); ?>"><?php echo bloginfo('name'); ?></a>.</p>
		
		<?php
		ob_start();
		global $id;
		if (function_exists("wswwpx_fold_page_list")) {
			wswwpx_fold_page_list("title_li=&sort_column=menu_order&child_of=$id");
			} else {
			wp_list_pages("title_li=&sort_column=menu_order&child_of=$id" );
		}
		$subpages = trim(ob_get_contents());
		ob_end_clean();
		?>
		<?php if ($subpages) { ?>
			<p>This page contains the following pages:</p>
			<ul><?php print $subpages; ?></ul>
		<?php } else {?>
		<?php } ?>

	<?php /* If this is the front page */ } else { ?>
	<p>You are reading <a href="<?php echo get_settings('siteurl'); ?>"><?php echo bloginfo('name'); ?></a>: my personal Weblog<?php if (function_exists("days_since_birth")) { ?>, created <?php days_since_birth() ?> days ago<?php } ?>.  I write about technology, life, women, music, philosophy and politics.  Sometimes I also write about me.
	</p>
	<?php } ?>

	<?php if (is_single()) { ?>
	<?php if (function_exists("all_in_series")) { ?>
	<?php
		if (function_exists('post_is_part_of_series')) {
			$series_name = post_is_part_of_series();
			if ($series_name) $series_order = 100; /* dummy val */
		} else {
			$series_name = get_post_meta($post->ID, 'series_name', true);
			$series_order = get_post_meta($post->ID, 'series_order', true);
		}
		if ($series_name && $series_order != "") {
	?>
	<p id="sidebar-series-toc-slug">This article is part of the <?php print $series_name; ?> series. Other articles in the series:</p>
	<div id="sidebar-series-toc"><?php series_table_of_contents(); ?></div>
	<?php } ?>
	<?php } ?>
	<p><?php previous_post_link('The previous post is %link.') ?> <?php next_post_link('The next post is %link.') ?></p>
	<?php /* only if this is not search, because that case's covered down - we are also overriding the older entries / newer entries navigation if this is a "showpage" page (generally the master archive page or a directory index page) */ } elseif (!is_search() && !is_404() && !is_template_page() && !is_useronline()) { ?>
	<div class="navigation"><div class="previous"><?php next_posts_link('&laquo; Older entries') ?></div><div class="next"><?php previous_posts_link('Newer entries &raquo;') ?></div></div>
	<?php } ?>
			
	<?php echo $after_widget; ?>

<?php
} if (function_exists('register_sidebar_widget')) register_sidebar_widget('About this page','widget_about_this_page');


function widget_search_with_nav($args) {
    extract($args);
?>
	<?php echo $before_widget; ?>
	<?php echo $before_title . 'Search this blog' . $after_title; ?>

	<?php include (TEMPLATEPATH . '/searchform.php'); ?>
	<?php /* If this is search */ if (is_search()) { ?>
	<div class="navigation"><div class="previous"><?php next_posts_link('&laquo; Previous results') ?></div><div class="next"><?php previous_posts_link('Next results &raquo;') ?></div></div>
	<?php } ?>

	<?php echo $after_widget; ?>
<?php
} if (function_exists('register_sidebar_widget')) register_sidebar_widget('Search with navigation','widget_search_with_nav');


function widget_pages_list($args) {
    extract($args);
?>
	<?php echo $before_widget; ?>
	<?php echo $before_title . 'Pages' . $after_title; ?>

	<ul><?php wp_list_pages('title_li=&sort_column=menu_order&depth=2' ); ?></ul>

	<?php echo $after_widget; ?>
<?php
} if (function_exists('register_sidebar_widget')) register_sidebar_widget('Fixed-depth page list','widget_pages_list');


function widget_calendar_archives($args) {
    extract($args);
?>
	<?php echo $before_widget; ?>
	<?php echo $before_title . 'Archives' . $after_title; ?>

	<div id="calendar-container">
	<?php get_calendar(1); ?>
	<div><a href="<?php the_archives_permalink(); ?>">Complete archives</a></div>
	</div>

	<?php echo $after_widget; ?>
<?php
} if (function_exists('register_sidebar_widget')) register_sidebar_widget('Calendar with archives link','widget_calendar_archives');


if (function_exists("g2_sidebarimageblock")) {

	function widget_gallery2_sidebar($args) {
	extract($args);
	?>
		<?php echo $before_widget; ?>
		<?php echo $before_title . 'Picture gallery' . $after_title; ?>
	
		<?php print g2_sidebarimageblock(); ?>
	
		<?php echo $after_widget; ?>
	<?php
	} if (function_exists('register_sidebar_widget')) register_sidebar_widget('WP-Gallery2 thumbnails','widget_gallery2_sidebar');

}

function widget_about_this_site($args) {
    extract($args);
?>
	<?php echo $before_widget; ?>
	<?php echo $before_title . "About "; bloginfo('name'); echo $after_title; ?>
	
	<ul>
		<li><?php if (function_exists("validator_campaign_short")) validator_campaign_short(); ?></li>
		<li><a href="http://gmpg.org/xfn/"><abbr title="XHTML Friends Network">XFN</abbr></a></li>
		<li><a href="http://rudd-o.com/projects/supercharged/" title="The best-of-breed selection of plugins and themes for WordPress">Supercharged</a> <a href="http://wordpress.org/" title="Powered by WordPress, state-of-the-art semantic personal publishing platform.">WordPress</a></li>
		<li><a href="http://rudd-o.com/projects/revvedup/" title="The RevvedUp theme for WordPress">This design is RevvedUp</a></li>
		<?php wp_meta(); ?>
		<?php revvedup_meta(); ?>
	</ul>

	<?php echo $after_widget; ?>
<?php
} if (function_exists('register_sidebar_widget')) register_sidebar_widget('About this site','widget_about_this_site');


function widget_subscribe($args) {
    extract($args);
?>
	<?php echo $before_widget; ?>
	<?php echo $before_title . 'Join us and subscribe' . $after_title; ?>

	<?php get_currentuserinfo(); global $user_ID; if ( $user_ID ) { ?>
	
		<p>You're currently logged in.  If you want to, you can <?php wp_loginout($before="",$after="") ?>.  If you have management privileges, you can also use the <?php wp_register($before="",$after=""); ?> tool.</p>
	
	<?php } else { ?>
	
		<?php if (get_settings("users_can_register")) { ?><p><?php wp_register($before="",$after=""); ?> at <?php bloginfo('name'); ?> today, and get your permanent nickname for comments and live chat!  Remember to <?php wp_loginout($before="",$after=""); ?> after you've subscribed.</p><?php } ?>
	
	<?php } ?>
	
	<?php if (function_exists("the_subscribe_links")) { ?>
		<p>Get the scoop on new articles, and be the first to know when <a href="<?php echo get_settings('siteurl'); ?>"><?php bloginfo('name'); ?></a> is updated:</p>
		<?php the_subscribe_links(); ?>
	<?php } ?>

	<?php echo $after_widget; ?>
<?php
} if (function_exists('register_sidebar_widget')) register_sidebar_widget('Join us and subscribe','widget_subscribe');


if (function_exists("related_posts")) {
	function widget_related_posts($args) {
	if (!is_single()) return; //only works for single post pages
	extract($args);
	?>
		<?php echo $before_widget; ?>
		<?php echo $before_title . 'Related articles' . $after_title; ?>
		<ul><?php related_posts(); ?></ul>
		<?php echo $after_widget; ?>
	<?php
	} if (function_exists('register_sidebar_widget')) register_sidebar_widget('Related posts','widget_related_posts');
}


if (function_exists("get_recent_comments")) {
	function widget_recent_comments_with_excerpts($args) {
	extract($args);
	?>
		<?php echo $before_widget; ?>
		<?php echo $before_title . 'Recent conversations' . $after_title; ?>
		<ul><?php get_recent_comments(); ?></ul>
		<?php echo $after_widget; ?>
	<?php
	} if (function_exists('register_sidebar_widget')) register_sidebar_widget('Recent comments with excerpts','widget_recent_comments_with_excerpts');
}


if (function_exists("bstat_recentpop")) {
	function widget_popular_posts($args) {
	extract($args);
	?>
		<?php echo $before_widget; ?>
		<?php echo $before_title . 'Popular articles' . $after_title; ?>
		<ul><?php bstat_recentpop($maxresults=5,$days=30,$before='<li>',$after='</li>'); ?></ul>
		<?php echo $after_widget; ?>
	<?php
	} if (function_exists('register_sidebar_widget')) register_sidebar_widget('Popular posts','widget_popular_posts');
}


if (function_exists("dates_to_remember")) {
	function widget_dates_to_remember($args) {
	extract($args);
	?>
		<?php
			ob_start();
			dates_to_remember(5);
			$dates_to_remember = trim(ob_get_contents());
			ob_end_clean();
			if ($dates_to_remember) {
		?>
		<?php echo $before_widget; ?>
		<?php echo $before_title . 'Upcoming events' . $after_title; ?>
		<ul>
			<?php print $dates_to_remember; ?>
		</ul>
		<?php echo $after_widget; ?>
		<?php } ?>
		
	<?php
	} if (function_exists('register_sidebar_widget')) register_sidebar_widget('Upcoming events','widget_dates_to_remember');
}


if (function_exists("wp_theme_switcher")) {
	function widget_wp_theme_switcher($args) {
	extract($args);
	?>
	<?php echo $before_widget; ?>
	<?php echo $before_title . 'Themes' . $after_title; ?>
	<?php wp_theme_switcher(); ?>
	<?php echo $after_widget; ?>
	<?php
	} if (function_exists('register_sidebar_widget')) register_sidebar_widget('Theme switcher','widget_wp_theme_switcher');
}




?>