<?php get_header(); ?>

	<div id="content">

	<?php if (have_posts()) : ?>
		
		<?php while (have_posts()) : the_post(); ?>
				
<!-- google_ad_section_start -->

			<div class="post" id="post-<?php the_ID(); ?>">
				<h1 class="storytitle"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h1>

				<div class="postmetadata">by <?php the_author() ?> — published on <?php the_time('F jS, Y') ?> <?php edit_post_link('Edit this entry.','',''); ?></div>

				<?php ad_after_title(); ?>
				
				<div class="entry">
					<?php ad_above_content(); ?>
					<?php the_content('Read the rest of this entry &raquo;'); ?>
				</div>

<!-- google_ad_section_end -->

				<?php ad_after_content(); ?>

				<?php ad_tip_block(); ?>

				<p class="postmetadata alt">
						This page was posted
						on <?php the_time('l, F jS, Y') ?> at <?php the_time() ?>.
						You can follow any responses to this entry through the <?php comments_rss_link('RSS 2.0'); ?> feed. 
						
						<?php if (('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
							// Both Comments and Pings are open ?>
							You can <a href="#respond">leave a response</a>, or <a href="<?php trackback_url(true); ?>" rel="trackback">trackback</a> from your own site.
						
						<?php } elseif (!('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
							// Only Pings are Open ?>
							Responses are currently closed, but you can <a href="<?php trackback_url(true); ?> " rel="trackback">trackback</a> from your own site.
						
						<?php } elseif (('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
							// Comments are open, Pings are not ?>
							You can skip to the end and leave a response. Pinging is currently not allowed.
			
						<?php } elseif (!('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
							// Neither Comments, nor Pings are open ?>
							Both comments and pings are currently closed.
						
						<?php } ?>
						
				<?php if (function_exists("wp_sociable")) { ?>You can also share and bookmark this article on the following services: <span id="sociable-links"><?php wp_sociable(); ?></span><?php } ?>

				</p>

				<?php if (function_exists('bccl_license_text_hyperlink')) { ?><p id="license-slug"><?php bccl_license_text_hyperlink(); ?> Except where expressly acknowledged, this work is distributed and licensed to you under the terms of <a href="<?php print bccl_get_license_deed_url(); ?>">this license</a>.  For other licenses, contact <?php the_author(); ?>.</p><?php } ?>

			</div>

	<?php comments_template(); ?>
	
	<?php if (function_exists("bstat_pulse")) { ?>
	<?php
			ob_start();
			bstat_pulse($post_id=$id,$maxwidth=350,$disptext=1,$dispcredit=0);
			$buffer = ob_get_contents();
			ob_end_clean();
			if ($buffer) {
				print '<h2>Page pulse</h2>';
				print $buffer;
			}
	 ?>
	<?php } ?>

		<?php endwhile; ?>

	<?php else : ?>

		<h1 class="pagetitle">Oops... not found!</h2>
		<p class="center">Sorry, but you are looking for something that isn't here.  Please use the following search form if you remember a few words of the text you're looking for.</p>
		<?php include (TEMPLATEPATH . "/searchform.php"); ?>

	<?php endif; ?>

	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
