<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head profile="http://gmpg.org/xfn/11">
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />

<title><?php
  $title = '';

      if (is_single() ) $title = get_option('mandigo_title_scheme_single');
  elseif (is_page()   ) $title = get_option('mandigo_title_scheme_page');
  elseif (is_archive()) {
    if (is_day() || is_month() || is_year()) $title = get_option('mandigo_title_scheme_date');
    else                                     $title = get_option('mandigo_title_scheme_category');
  }
  elseif (is_search() ) $title = get_option('mandigo_title_scheme_search');
  else                  $title = get_option('mandigo_title_scheme_index');

  $title = str_replace('%blogname%',get_bloginfo('name')       ,$title);
  $title = str_replace('%tagline%' ,get_bloginfo('description'),$title);
  $title = str_replace('%post%'    ,get_the_title()            ,$title);
  $title = str_replace('%search%'  ,$s                         ,$title);

  if (single_cat_title('',false)) $title = str_replace('%category%',single_cat_title('',false) ,$title);
  else                            $title = preg_replace("/<[^>]+>/","",str_replace('%category%',get_the_category_list(', '),$title));

  if     (is_day()  ) $title = str_replace('%date%',get_the_time(__('l, F jS, Y','mandigo')),$title);
  elseif (is_month()) $title = str_replace('%date%',get_the_time(__('F, Y','mandigo'))      ,$title);
  elseif (is_year() ) $title = str_replace('%date%',get_the_time('Y')                       ,$title);

  echo $title;
?></title>

<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" /> <!-- leave this for stats -->
<meta name="theme"     content="Mandigo <?php $themes = get_themes(); echo $themes['Mandigo']['Version']; ?>" />

<?php
  if (get_option('mandigo_scheme_random')) {
    $schemes = array("blue","red","green","pink","purple","orange","teal");
    update_option("mandigo_scheme",$schemes[array_rand($schemes,1)]);
  }
  if (get_option('mandigo_bold_links')) { $lastminutecss .= "  a { font-weight: bold; }\n"; };
  if (file_exists(TEMPLATEPATH.'/images/headers/'. $post->ID .'.jpg')) {
    $noheaderimg = 1;
    $lastminutecss .= "  #headerimg {   background: url(". get_bloginfo('stylesheet_directory') ."/images/headers/". $post->ID .".jpg) bottom center no-repeat; }\n";
  }
  elseif (get_option('mandigo_headers_random')) {
    $headersdir = opendir(TEMPLATEPATH.'/images/headers/');
    while (false !== ($file = readdir($headersdir))) {
      if (preg_match("/\.(?:jpe?g|png|gif|bmp)$/i",$file)) $headers[] = $file;
    }
    if (sizeof($headers)) {
      $noheaderimg = 1;
      $lastminutecss .= "  #headerimg {   background: url(". str_replace(' ','%20',get_bloginfo('stylesheet_directory')) ."/images/headers/". $headers[array_rand($headers,1)] .") bottom center no-repeat; }\n";
    }
  }
  $stroke = get_option('mandigo_stroke');
?>
<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>.php<?php echo ($noheaderimg ? '?noheaderimg' : '') ?>" type="text/css" media="screen" />
<link rel="stylesheet" href="<?php bloginfo('stylesheet_directory'); ?>/<?php echo get_option('mandigo_scheme'); ?>.css" type="text/css" media="screen" />
<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php 
  wp_head();
  if ($lastminutecss) echo "<style type=\"text/css\">\n$lastminutecss</style>\n";
  echo get_option('mandigo_inserts_header');
?>

</head>
<?php
  $bodytag = get_option('mandigo_inserts_body');
  echo (preg_match("/<body/i",$bodytag) ? $bodytag : "<body>");
?>

<div id="page">

<div id="header">
	<div id="headerimg">
<?php if (!get_option('mandigo_hide_blogname')): ?>
		<h1><a href="<?php echo get_option('home'); ?>/"><?php bloginfo('name'); ?></a></h1>
  <?php if (get_option('mandigo_drop_shadow')): ?>
		<span class="h1 text-shadow"><?php bloginfo('name'); ?></span>
  <?php endif; ?>
  <?php if ($stroke): ?>
		<span class="h1 text-stroke-tl"><?php bloginfo('name'); ?></span>
		<span class="h1 text-stroke-tr"><?php bloginfo('name'); ?></span>
		<span class="h1 text-stroke-bl"><?php bloginfo('name'); ?></span>
		<span class="h1 text-stroke-br"><?php bloginfo('name'); ?></span>
<?php
    endif;
  endif;
  if (!get_option('mandigo_hide_blogdesc') && get_bloginfo('description')):
?>
		<div class="description">
			<h6><?php bloginfo('description'); ?></h6>
  <?php if (get_option('mandigo_drop_shadow')): ?>
			<span class="h6 text-shadow"><?php bloginfo('description'); ?></span>
  <?php endif; ?>
  <?php if ($stroke): ?>
			<span class="h6 text-stroke-tl"><?php bloginfo('description'); ?></span>
			<span class="h6 text-stroke-tr"><?php bloginfo('description'); ?></span>
			<span class="h6 text-stroke-bl"><?php bloginfo('description'); ?></span>
			<span class="h6 text-stroke-br"><?php bloginfo('description'); ?></span>
  <?php endif; ?>
		</div>
<?php endif; ?>
		<ul class="pages<?php echo (get_option('mandigo_headoverlay') ? ' head_overlay' : ''); ?>">
			<li class="page_item"><a href="<?php echo get_option('home'); ?>/"><?php _e('Home','mandigo'); ?></a></li>
<?php wp_list_pages('sort_column=menu_order&depth=1&title_li=&exclude='.get_option('mandigo_exclude_pages')); ?>
</ul>
	</div>
</div>
<div id="main">
<?php get_option('mandigo_inserts_top'); ?>
<table>
<tr>
