<?php get_header(); ?>

<ul id="navlist">
	<li><a href="<?php bloginfo('url'); ?>" >Home</a> &bull;</li>
	<li><a href="<?php bloginfo('url'); ?>/archives" id="current" >Archives</a> &bull;</li>
	<li><a href="#">More</a> &bull;</li>
	<li><a href="#">Links</a> &bull;</li>
	<li><a href="#">Here</a></li>
</ul>

	<div id="content" class="narrowcolumn">

		<?php if (have_posts()) : ?>

		 <?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
<?php /* If this is a category archive */ if (is_category()) { ?>				
		<h2 class="pagetitle">Archive for the '<?php echo single_cat_title(); ?>' Category</h2>
		
 	  <?php /* If this is a daily archive */ } elseif (is_day()) { ?>
		<h2 class="pagetitle">Archive for <?php the_time('F jS, Y'); ?></h2>
		
	 <?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
		<h2 class="pagetitle">Archive for <?php the_time('F, Y'); ?></h2>

		<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
		<h2 class="pagetitle">Archive for <?php the_time('Y'); ?></h2>
		
	  <?php /* If this is a search */ } elseif (is_search()) { ?>
		<h2 class="pagetitle">Search Results</h2>
		
	  <?php /* If this is an author archive */ } elseif (is_author()) { ?>
		<h2 class="pagetitle">Author Archive</h2>

		<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
		<h2 class="pagetitle">Blog Archives</h2>

		<?php } ?>


		<div class="navigation" id="topnav">
			<div class="alignleft"><?php next_posts_link('&laquo; Previous Entries') ?></div>
			<div class="alignright"><?php previous_posts_link('More Recent items &raquo;') ?></div>
		</div>

		<?php while (have_posts()) : the_post(); ?>
		<div class="post">
				<p class="date"><?php the_time('l, F jS, Y') ?></p>
				<h2 class="posttitle" id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2>
				
				
				<div class="entry">
					<?php the_content() ?>
				</div>
		
				<p class="postmetadata">
				<?php comments_popup_link('No Comments', '1 person had his say', '% Comments','comments'); ?> 
				<a href="<?php the_permalink() ?>" rel="bookmark" class="permalink" title="Permanent Link to <?php the_title(); ?>">Permalink</a> 
				<span class="category">Filed under <?php the_category(', ') ?></span>
				</p> 

			</div>
	
		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php next_posts_link('&laquo; Previous Entries') ?></div>
			<div class="alignright"><?php previous_posts_link('More Recent items &raquo;') ?></div>
		</div>
	
	<?php else : ?>

		<h2 class="center">Not Found</h2>
		<form method="get" id="searchformarchive" action="<?php bloginfo('home'); ?>/">
			<input type="text" value="<?php echo wp_specialchars($s, 1); ?>" name="s" id="s" /><br/>
		
			<!--<input type="submit" id="searchsubmit" value="Search" />-->
			<input type="image" src="http://www.gtcentralrotary.org/wp-content/themes/rotary/images/searchbutton.gif" value="Search" id="searchsubmit" name="searchsubmit" alt="submit"/>
		
		</form>

	<?php endif; ?>
		
	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>