<?php
/*
Template Name: Contact_Template
*/
?>

<?php get_header(); ?>
	<ul id="navlist">
  		<li><a href="<?php bloginfo('url'); ?>">Home</a> &bull;</li>
		<li><a href="<?php bloginfo('url'); ?>/contact" id="current">Contact</a> &bull;</li>
		<li><a href="<?php bloginfo('url'); ?>/archives" accesskey="2">Archives</a> &bull;</li>
		<li><a href="#" accesskey="2">More</a> &bull;</li>
		<li><a href="#">Links</a> &bull;</li>
		<li><a href="#" accesskey="b">Here</a></li>
	</ul> 

	<div id="content" class="narrowcolumn">
	<h1>Contact</h1>
	
<?php
	if (isset($_POST['send']))
		echo "<p>Thanks for sending!</p>";
?>

		<!--Live javascript validation by Cody Lindley http://codylindley.com/Javascript/243/live-javascript-validation -->
		<p>You can <a href="mailto:your@email.com">email me</a> directly or use the contact form below.
		<span class="red"> All fields</span> are required.</p>
		
		<div id="errorwarning"><strong>Form Errors!</strong> Please fix the error's indicated in red below.</div>
		<form action="<?php bloginfo('url'); ?>/contact" method="post" id="cForm" onsubmit="return configureValidation2();">			
				
			<dl id="contactform">	
				<dt><label for="name" id="nameL">Name:</label></dt>
				<dd><input type="text" id="name" name="name" tabindex="1" onkeydown="return blockEnter(event)"/></dd>
				
				<dt><label for="email" id="emailL">Your email address:</label></dt>
				<dd><input type="text" id="email" name="email" tabindex="2" onkeydown="return blockEnter(event)"/></dd>
				
				<dt><label for="subject" id="subjectL">Subject:</label></dt>
				<dd><input type="text" id="subject" name="subject" tabindex="3" onkeydown="return blockEnter(event)"/></dd>

				<dt><label for="message" id="messageL">Message:</label></dt>
				<dd><textarea name="message" id="message" tabindex="4" rows="5" cols="20" onkeydown="return blockEnter(event)"></textarea></dd>
			
				<dt><input type="image" src="<?php bloginfo('template_directory');?>/images/sendbutton.gif" value="Submit" id="sendbutton" name="send" alt="submit" /></dt>
				<dd></dd>
			</dl>
			
			
	</form>
		
		<script language="JavaScript" type="text/JavaScript">

		//stop form submisson when enter key is used. Should be added to onload event handler
		function blockEnter(evt) {
			evt = (evt) ? evt : event;
			var charCode = (evt.charCode) ? evt.charCode :
				((evt.which) ? evt.which : evt.keyCode);
			if (charCode == 13) {
				return false;
			} else {
				return true;
			}
		}

		</script>

	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>