<?php
	/*
		Template Name: Archives
       */
?> 
<?php get_header(); ?>
	<div class="ncol"><!-- Begin of the narrow column -->
		<div class="lnks"><!-- Opens the Archives Div -->
			<h2>Archives by Month</h2>
				<ul>
					<?php get_archives('monthly', '', 'html', '', '', TRUE); ?>
				</ul>
			<br/>	
			<br/>	
			<h2>Archives by Category</h2>
				<ul>
					<?php wp_list_cats('optioncount=1&feed=RSS 2.0'); ?>
				</ul>
		</div><!-- Closes the Archives Div -->
	</div><!-- This closes the narrow column div, leave it where it is! do NOT place it before the php endif -->
	<div class="sidebar">
	<ul>
		<li><!-- Activity -->
			<h2><?php _e('Activity'); ?></h2>
			<!--This will show the last 10 posts, including the last one. To change the number of post shown
			edit the 'nuberposts=x' to whatever value you want, and to skip the last one (or last 2, 3, etc.) 
			increase the value of 'offset=x' (default is "0" so it will start by the last post)-->
				<ul><?php
						$posts = get_posts('numberposts=10&offset=0');
						foreach ($posts as $post) :
					?>
					<li>
					<a href="<?php the_permalink(); ?>" title="<?php the_title() ?>"><?php the_title() ?></a>
					</li>
					<?php
						endforeach;
					?>
				</ul>
		</li><!-- End of Activity -->
		<li>
			<h2><?php _e('Pages'); ?></h2>
				<ul>
				<?php wp_list_pages('title_li='); ?>
				</ul>
		</li> 
		<!-- Links -->
		<h2><?php _e('Links'); ?></h2>
		<br/>
			<?php
				$link_cats = $wpdb->get_results("SELECT cat_id, cat_name FROM $wpdb->linkcategories");
				foreach ($link_cats as $link_cat) {
			?>
			   <li>

					<h2 class="lnkname"><?php echo $link_cat->cat_name; ?></h2>
						<ul>
							<?php wp_get_links($link_cat->cat_id); ?>
						</ul>
				</li>
			<?php } ?>
		<!-- End of Links -->
	</ul>
</div>

<?php get_footer(); ?>