<?php get_header(); ?>
<div class="ncol"><!-- Begin of the narrow column -->
    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
		<div class="post"><!-- Post Div-->
			<h2 id="post-<?php the_ID(); ?>">
				<a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a>
			</h2>
			<div class="entry">
				<?php the_content(__('<strong>(more...)</strong>')); ?>
				<?php link_pages('<p class="postmetadata"><strong>Pages:</strong>', '</p>', 'number'); ?>
			</div>
		</div><!-- End of post div-->
	 <?php endwhile; endif; ?>
		<?php edit_post_link('Edit this page!', '<p>', '</p>'); ?>
</div>
<div class="sidebar"><!-- If you want the full sidebar replace the following code with the get_sidebar(); function -->
	<ul>
		<li><!-- Activity -->
			<h2><?php _e('Activity'); ?></h2>
			<!--This will show the last 10 posts, including the last one. To change the number of post shown
			edit the 'nuberposts=x' to whatever value you want, and to skip the last one (or last 2, 3, etc.) 
			increase the value of 'offset=x' (default is "0" so it will start by the last post)-->
				<ul><?php
						$posts = get_posts('numberposts=10&offset=0');
						foreach ($posts as $post) :
					?>
					<li>
					<a href="<?php the_permalink(); ?>" title="<?php the_title() ?>"><?php the_title() ?></a>
					</li>
					<?php
						endforeach;
					?>
				</ul>
		</li><!-- End of Activity -->
		<li>
			<h2><?php _e('Pages'); ?></h2>
				<ul>
				<?php wp_list_pages('title_li='); ?>
				</ul>
		</li> 
		<li><!-- Archives -->
			<h2><?php _e('Archives'); ?></h2>
				<ul>
					<?php wp_get_archives('type=monthly'); ?>
				</ul>
		</li><!-- End of Archives -->	
		<li><!-- Categories -->
			<h2><?php _e('Categories'); ?></h2>
				<ul>
					<?php wp_list_cats('optioncount=0'); ?>
				</ul>
		</li><!-- End of Categories -->		
	</ul>
</div>
<?php get_footer(); ?>