<?php
// Necessary for the widgets to work
if ( function_exists('register_sidebar') )
	register_sidebar();

// Current Weather, if it exists
function widget_current_weather() {
  $city = get_option('weather_city');
  if ($city == "") {
    add_option('weather_city','Muscatine, Iowa','The city to be displayed in the Weather sidebar widget.');
    $city = 'Muscatine, Iowa';
  }
?>
  <li><h2><?php _e('Current Weather'); ?></h2>
    <ul>
      <li class="weather"><?php echo $city; ?></li>
      <?php WeatherIcon('KMUT'); ?>
    </ul>
  </li>
<?php
}
function weather_city_control () {
  $city = get_option('weather_city');
  if ($city == "") {
    add_option('weather_city','Muscatine, Iowa','The city to be displayed in the Weather sidebar widget.');
    $city = 'Muscatine, Iowa';
  }
  if ( $_POST["city_update"] ) {
    $new_city = $_POST["weather_city_name"];
    if ($city != $new_city) {
      $city = $new_city;
      update_option('weather_city', $city);
    }
  }
  ?>
  <p>City: <input type="text" id="weather_city_name" name="weather_city_name" value="<?php echo $city; ?>" /></p>
  <p>This is the city name to be displayed on the Current Weather widget. To set all other options, go to Weather Icon's Options panel.</p>
  <input type="hidden" id="city_update" name="city_update" value="1" />
  <?php
}
if (function_exists('WeatherIcon') ) {
  if ( function_exists('register_sidebar_widget') ) {
	  register_sidebar_widget(array('Current Weather', 'widgets'), 'widget_current_weather');	  
    register_widget_control('Current Weather', 'weather_city_control',250,150);
  }
}

// BLaugh Popup - I have this so that the Image Manager plugin is necessary for it to work properly
function widget_blaugh_popup() {
?>
  <li>
    <ul>
      <li>
        <br /><small>See the latest</small><br />
        <a href="http://blaugh.com/latest-cartoons/latest400.gif" onclick="ps_imagemanager_popup(this.href,'Blaugh! - The Un-Official Comic of the Blogosphere!','400','225');return false" onfocus="this.blur()"	 ><img src="<?php bloginfo('stylesheet_directory'); ?>/buttons/button-blaugh.png" alt="Blaugh! - The Un-Official Comic of the Blogosphere!" title="Blaugh! - The Un-Official Comic of the Blogosphere!" /></a>
      </li>
    </ul>
  </li>
<?php
}
if (function_exists('ps_imagemanager_wp_head')) {
  if ( function_exists('register_sidebar_widget') )
    register_sidebar_widget(__('BLaugh'), 'widget_blaugh_popup');
}

function widget_mdv_recent_comments() {
?>
  <li><h2><?php _e('Recent Comments'); ?></h2>
    <ul>
      <?php mdv_recent_comments(7,6,'<li>','</li>',true); ?>
    </ul>
  </li>
<?php
}
if (function_exists('mdv_recent_comments')) {
  if ( function_exists('register_sidebar_widget') )
    register_sidebar_widget(__('MDV Recent Cmts'), 'widget_mdv_recent_comments');
}

function widget_mdv_recent_posts() {
?>
  <li><h2><?php _e('Recent Posts'); ?></h2>
    <ul>
      <?php mdv_recent_posts(7,'<li>','</li>',true,0,false); ?>
    </ul>
  </li>
<?php
}
if (function_exists('mdv_recent_posts')) {
  if ( function_exists('register_sidebar_widget') )
    register_sidebar_widget(__('MDV Recent Posts'), 'widget_mdv_recent_posts');
}

function widget_my_links() {
  if (get_bloginfo('version') < 2.1) {
?>
  <li><h2><?php _e('Links'); ?></h2>
    <ul>
      <?php get_links('-1', '<li>', '</li>', ' '); ?>
    </ul>
  </li>
<?php
  } else {
    wp_list_bookmarks('show_updated=1');
  }
}
if ( function_exists('register_sidebar_widget') )
  register_sidebar_widget(__('My Links'), 'widget_my_links');

function widget_dropdown_archives() {
?>
  <li><h2><?php _e('Archives'); ?></h2>
    <ul>
      <li>
        <form name="archiveform" action="">
          <select name="archive_chrono" onchange="window.location = (document.forms.archiveform.archive_chrono[document.forms.archiveform.archive_chrono.selectedIndex].value);">
            <option value=''>Select Month</option><?php get_archives('monthly','','option','','',false); ?>
          </select>
        </form>
      </li>
    </ul>
  </li>
<?php
}
if ( function_exists('register_sidebar_widget') )
	register_sidebar_widget(__('My Archives'), 'widget_dropdown_archives');

function widget_my_search() {
?>
  <li><h2><?php _e('Search'); ?></h2>
    <ul>
		  <li>
			  <form id="searchform" method="get" action="<?php echo $_SERVER['PHP_SELF']; ?>">
				  <div style="text-align:center">
					  <input type="text" name="s" id="s" size="15" />
					  <input type="submit" class="submit" name="submit" value="Search Me" />
				  </div>
			  </form>
		  </li>
	  </ul>
  </li>
<?php
}
if ( function_exists('register_sidebar_widget') )
	register_sidebar_widget(__('My Search'), 'widget_my_search');

function widget_meta_with_buttons() {
?>
	<li><h2><?php _e('Meta'); ?></h2>
    <ul>
      <li><?php if ( ! is_user_logged_in() ) {
          // login
		      $link = '<a href="' . get_option('siteurl') . '/wp-login.php"><img src="' . get_bloginfo('stylesheet_directory') . '/buttons/button-login.png" alt="Login" title="Login" /></a>';
		    }	else {
		      // logout
		      $link = '<a href="' . get_option('siteurl') . '/wp-login.php?action=logout"><img src="' . get_bloginfo('stylesheet_directory') . '/buttons/button-logout.png" alt="Log Out" title="Log Out" /></a>';
		    }
        // echo apply_filters('loginout', $link);
        echo $link; ?>
      </li>
      <li><?php	if ( ! is_user_logged_in() ) {
		      if ( get_option('users_can_register') ) {
		        // register users
	 		      $link = '<a href="' . get_option('siteurl') . '/wp-login.php?action=register"><img src="' . get_bloginfo('stylesheet_directory') . '/buttons/button-wpregister.png" alt="Register" title="Register" /></a>&nbsp;';
			    } else {
			      $link = '';
			    }
	      } else {
	        // site admin
		      $link = '<a href="' . get_option('siteurl') . '/wp-admin/"><img src="' . get_bloginfo('stylesheet_directory') . '/buttons/button-wpadmin.png" alt="WordPress Admin" title="WordPress Admin" /></a>';
	      }
        echo apply_filters('register', $link); ?>
      </li>
      <li><a href="<?php bloginfo('rss2_url'); ?>" target="_blank"><img src="<?php bloginfo('stylesheet_directory'); ?>/buttons/button-rss2.png" alt="Syndicate this site using RSS" title="Syndicate this site using RSS" /></a>&nbsp;
          <a href="<?php bloginfo('comments_rss2_url'); ?>" target="_blank"><img src="<?php bloginfo('stylesheet_directory'); ?>/buttons/button-comments.png" alt="The latest comments to all posts in RSS" title="The latest comments to all posts in RSS" /></a></li>
      <li><a href="<?php bloginfo('atom_url'); ?>" target="_blank"><img src="<?php bloginfo('stylesheet_directory'); ?>/buttons/button-atom.png" alt="Syndicate this site using Atom" title="Syndicate this site using Atom" /></a>&nbsp;
          <a href="http://wwwspreadfirefox.com/" target="_blank"><img src="<?php bloginfo('stylesheet_directory'); ?>/buttons/button-getfirefox.png" alt="Get Firefox! Take back the web!" title="Get Firefox! Take back the web!" /></a></li>
      <li><a href="http://www.php.net" target="_blank"><img src="<?php bloginfo('stylesheet_directory'); ?>/buttons/button-php.png" alt="This site is powered by PHP" title="This site is powered by PHP" /></a>&nbsp;
          <a href="http://www.mysql.com" target="_blank"><img src="<?php bloginfo('stylesheet_directory'); ?>/buttons/button-mysql.png" alt="Backend is MySQL" title="Backend is MySQL" /></a></li>
      <li><a href="http://gmpg.org/xfn/" target="_blank"><img src="<?php bloginfo('stylesheet_directory'); ?>/buttons/button-xfn.png" alt="XHTML Friends Network" title="XHTML Friends Network" /></a>&nbsp;
          <a href="http://jigsaw.w3.org/css-validator/validator?uri=<?php bloginfo('stylesheet_url') ?>&amp;usermedium=all" target="_blank"><img src="<?php bloginfo('stylesheet_directory'); ?>/buttons/button-css.png" alt="Valid CSS" title="Valid CSS" /></a></li>
      <li><a href="http://validator.w3.org/check/referer" target="_blank"><img src="<?php bloginfo('stylesheet_directory'); ?>/buttons/button-xhtml.png" alt="Valid XHTML 1.0 Transitional" title="Valid XHTML 1.0 Transitional" /></a>&nbsp;
          <a href="http://wordpress.org/" target="_blank"><img src="<?php bloginfo('stylesheet_directory'); ?>/buttons/button-wp.png" alt="Powered by WordPress; state-of-the-art semantic personal publishing platform" title="Powered by WordPress; state-of-the-art semantic personal publishing platform" /></a></li>
    </ul>
    <?php wp_meta(); ?>
  </li>
  <br /><br />
<?php   
}
if ( function_exists('register_sidebar_widget') )
	register_sidebar_widget(__('Meta Buttons'), 'widget_meta_with_buttons');
