<?php
/*
Plugin Name: Clean Archives Reloaded
Plugin URI: http://www.viper007bond.com/wordpress-plugins/clean-archives-reloaded/
Description: A nice, uniform, single-query, <a href="http://moofx.mad4milk.net/" title="A sweet prototype powered Javascript package">moo.fx</a>-enhanced way to display your post archives. <strong>Credits:</strong> <a href="http://cdcstudios.com/">Chris O'Rourke</a> for the moo.fx enhancement idea and <a href="http://www.sporadicnonsense.com/">Shawn Grimes</a> for <a href="http://www.sporadicnonsense.com/2005/04/28/clean-archives-plug-in/">the plugin</a> on which this plugin is based which used code by <a href="http://www.kingcosmonaut.de/">Sebastian Schmieg</a>.
Version: 1.0.1
Author: <a href="http://www.viper007bond.com/">Viper007Bond</a>
*/

// Set this to TRUE if you want to display password protected posts
$car_show_passworded_posts = FALSE;

// Set this to FALSE if you don't want to use the moo.fx effects
$car_use_moofx = TRUE;

# Non-novice users only past here!

// Uncomment these next lines or set these variables to TRUE elsewhere if you are already calling the moo.fx files in your site
//$prototype_loaded = TRUE;
//$moofx_main_loaded = TRUE;
//$moofx_pack_loaded = TRUE;

# Okay, now everyone stop editing here unless you REALLY know what you're doing. :)

// This function returns the total number of posts that this plugin will display
// You can do "echo car_total_posts();" if you'd like to output your total post count
function car_total_posts() {
	global $wpdb, $car_show_passworded_posts;

	$totalquery = "SELECT ID FROM $wpdb->posts WHERE post_date <'" . current_time('mysql') . "' AND post_status='publish'";
	if ($car_show_passworded_posts != TRUE) $totalquery .= " AND post_password=''";
	
	return $wpdb->query($totalquery);
}

// Call this function to output the archives list
function clean_archives_reloaded() {
	global $wpdb, $car_show_passworded_posts, $car_use_moofx, $prototype_loaded, $moofx_main_loaded, $moofx_pack_loaded;

	// Double check to make sure the cache is valid
	// While the hooks account for most things, posts made into the future can screw this cache up, so hence this check
	$totalposts = car_total_posts();

	// Get the current cache from the database
	$data = get_option('clean_archives_reloaded');

	// If there's no cache or the cache has less posts than there currently should be, regenerate the cache
	if ($totalposts != $data['totalposts']) $data = car_regenerate();
	
	// Start output
	echo "<!-- Start Clean Archives Reloaded Output | http://www.viper007bond.com/wordpress-plugins/ -->\n";

	// Now output the Javascript, if it's wanted
	if ($car_use_moofx && !$_GET['showall']) {
		$car_folder = get_bloginfo('wpurl') . '/wp-content/plugins/clean_archives_reloaded';

		// Only load up the Javascript files if they haven't been called already. Plugin/theme authors: feel free to use these vars in your plugin. :)
		if (!$prototype_loaded)		echo '<script src="' . $car_folder . '/moo.fx/prototype.lite.js" type="text/javascript"></script>' . "\n";
		if (!$moofx_main_loaded)	echo '<script src="' . $car_folder . '/moo.fx/moo.fx.js" type="text/javascript"></script>' . "\n";
		if (!$moofx_pack_loaded)	echo '<script src="' . $car_folder . '/moo.fx/moo.fx.pack.js" type="text/javascript"></script>' . "\n";

		echo '<script src="' . $car_folder . '/clean_archives_reloaded.js" type="text/javascript"></script>' . "\n\n";
	} // End Javascript output

	// Make the links to switch between moo.fx mode and classic mode
	if ($car_use_moofx) {
		if ($_GET['showall']) {
			echo '<p class="car_switcher"><a href="' . htmlspecialchars(add_query_arg('showall', '')) . '" title="Click here to return to the default, collapsed view">&laquo; Return To Collapsed View</a></p>';
		} else {
			echo '<p class="car_switcher"><a href="' . htmlspecialchars(add_query_arg('showall', '1')) . '" title="Click here to view all posts in a non-collapsed view">Expand All Months &raquo;</a></p>';
		}
		echo "\n\n";
	}

	// Output the cache
	echo $data['cache'];
	
	// Initiate the Javascript
	if ($car_use_moofx && !$_GET['showall']) {
		echo '<script type="text/javascript">cleanArchivesInit();</script>' . "\n";
	}
	
	echo "<!-- End Clean Archives Reloaded Output -->\n";
}

// This function generates the meat of this plugin and then caches it to the database
// Little of this is my (Viper007Bond) work -- most of it's by Shawn Grimes and/or Sebastian Schmieg
function car_regenerate() {
	global $month, $wpdb, $car_show_passworded_posts;

	$totalposts = 0;

	// Get all of the months that have posts
	$monthquery = "SELECT DISTINCT YEAR(post_date) AS year, MONTH(post_date) AS month, count(ID) as posts FROM " . $wpdb->posts . " WHERE post_date <'" . current_time('mysql') . "' AND post_status='publish'";
	if ($car_show_passworded_posts != TRUE) $monthquery .= " AND post_password=''";
	$monthquery .= " GROUP BY YEAR(post_date), MONTH(post_date) ORDER BY post_date DESC";
	$monthresults = $wpdb->get_results($monthquery);

	if ($monthresults) {
		// Loop through each month
		foreach ($monthresults as $monthresult) {
			$thismonth	= zeroise($monthresult->month, 2);
			$thisyear	= $monthresult->year;

			// Get all of the posts for the current month
			$postquery = "SELECT ID, post_date, post_title, comment_status FROM " . $wpdb->posts . " WHERE post_date LIKE '$thisyear-$thismonth-%' AND post_date AND post_status='publish'";
			if ($car_show_passworded_posts != TRUE) $postquery .= " AND post_password=''";
			$postquery .= " ORDER BY post_date DESC";
			$postresults = $wpdb->get_results($postquery);

			if ($postresults) {
				// The month year title things
				$text = sprintf('%s %d', $month[zeroise($monthresult->month,2)], $monthresult->year);
				$postcount = count($postresults);
				$output .= '<span style="cursor: pointer;" class="monthtitle" title="' . $monthresult->year . '-' . zeroise($monthresult->month,2) . '"><span title="Expand the ' . $postcount . ' post';
				if ($postcount != 1) $output .= 's';
				$output .= ' from ' . $text . '"><a href="#' . $monthresult->year . '-' . zeroise($monthresult->month,2) . '"><strong>' . $text . '</strong></a>&nbsp;(' . count($postresults) . ")</span></span>\n";

				$output .= "<ul class='postspermonth'>\n";
				foreach ($postresults as $postresult) {
					if ($postresult->post_date != '0000-00-00 00:00:00') {
						$url		= get_permalink($postresult->ID);
						$arc_title	= $postresult->post_title;

						if ($arc_title) $text = wptexturize(strip_tags($arc_title));
						else $text = $postresult->ID;
						$title_text = 'View this post, &quot;' . wp_specialchars($text, 1) . '&quot;';

						$output .= '	<li>' . mysql2date('d', $postresult->post_date) . ':&nbsp;' . "<a href='$url' title='$title_text'>$text</a>";
						$comments_count = $wpdb->get_var("SELECT COUNT(comment_id) FROM " . $wpdb->comments . " WHERE comment_post_ID=" . $postresult->ID . " AND comment_approved='1'");
						if ($postresult->comment_status == "open" OR $comments_count > 0) $output .= '&nbsp;(' . $comments_count . ')';
						$output .= "</li>\n";

						$totalposts++;
					}
				}
				$output .= "</ul>\n\n";
			}
		}
	} else {
		$output = '<strong>ERROR:</strong> No items were found to be displayed.';
	}

	$output = array(
		'totalposts' => $totalposts,
		'cache' => $output,
	);

	update_option('clean_archives_reloaded', $output);

	return $output;
}

/*
Anytime anything that affects us is changed, regenerate our cache.

You can comment out these actions if you'd like (say if you make tons of posts and few people visit
your archives page), but note that if you edit a post's title or stub, it's changes won't appear
here until the overall post count changes via a new post or post deletion.

And for those asking where "publish_post" is at, it's not needed (I think) as it'll +1 our total
post count and the cache check query will take care of that if all goes well.
*/

// Needed for post title/stub changes
add_action('edit_post', 'car_regenerate');

// Needed to incase a post is deleted and then a future post becomes a past post (which would
// result in the same number of total posts) before the archives page is viewed again.
add_action('delete_post', 'car_regenerate');

// Make sure the comment counts stay up to date
add_action('comment_post', 'car_regenerate');
add_action('delete_comment', 'car_regenerate');

?>