<?php
require('./wp-blog-header.php');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head profile="http://gmpg.org/xfn/11">
	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />

	<title><?php bloginfo('name'); ?><?php wp_title(); ?></title>
	
	<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" /> <!-- leave this for stats please -->

	<style type="text/css" media="screen">
		@import url( <?php bloginfo('stylesheet_url'); ?> );
	</style>

	<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
	<link rel="alternate" type="text/xml" title="RSS .92" href="<?php bloginfo('rss_url'); ?>" />
	<link rel="alternate" type="application/atom+xml" title="Atom 0.3" href="<?php bloginfo('atom_url'); ?>" />
	
	<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    <?php wp_get_archives('type=monthly&format=link'); ?>
	<?php //comments_popup_script(); // off by default ?>
	<?php wp_head(); ?>
</head>

<body>

<div id="container">
<div id="header"><a name="top"></a><h1><a href="<?php echo get_settings('home'); ?>"><?php bloginfo('name'); ?></a></h1>
<div class="description"><?php bloginfo('description'); ?></div></div>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<div id="sidebar">

<h2>Search:</h2>
<form method="get" id="searchform" action="<?php echo $_SERVER['PHP_SELF']; ?>">
<div><input type="text" value="<?php echo wp_specialchars($s, 1); ?>" name="s" id="s" />
<input type="submit" id="searchsubmit" value="Go" />
</div>
</form>
<br />

<h2><?php _e('Navigate'); ?></h2>
<ul>
<?php if (!is_page()): ?>
<li><a href="<?php bloginfo('url'); ?>">Home</a></li>
<?php else: ?>
<li><a href="<?php bloginfo('url'); ?>">Home</a></li>
<?php endif; ?>
<?php wp_list_pages('depth=1&title_li=0'); ?>
</ul>
<br />

<h2>About this entry:</h2>
<p>This entry was posted on <?php the_time('l, F jS, Y') ?> at <?php the_time() ?> and is filed under <?php the_category(', ') ?>. You can follow any responses to this entry through the <?php comments_rss_link('RSS 2.0'); ?> feed. You can <a href="#respond">leave a response</a>, or <a href="<?php trackback_url(display); ?>">trackback</a> from your own site.</p><br />

<h2>Other Recent Entries</h2>
<ul><?php get_archives('postbypost','5','custom','<li>','</li>'); ?></ul><br />

</div>
<div id="content">
		<div>
			<div class="alignleft"><?php previous_post('&laquo; %','','yes') ?></div>
			<div class="alignright"><?php next_post(' % &raquo;','','yes') ?></div>
		</div>
<br />
<br />
<div>
	 <h2><?php the_title(); ?></h2>
	 </div>
	 
	<div class="storycontent">
		<?php the_content(__('(more...)')); ?>
	</div>
	<br />
	<br />
	
    <!--
    <?php trackback_rdf(); ?>
    -->

<?php comments_template(); // Get wp-comments.php template ?>

</div>

<?php endwhile; else: ?>
<h2 class="center">Not Found</h2>
<p class="center"><?php _e("Sorry, but you are looking for something that isn't here."); ?></p>
<?php endif; ?>

<?php posts_nav_link(' &#8212; ', __('&laquo; Previous Page'), __('Next Page &raquo;')); ?>


<?php get_footer(); ?>