<?php get_header(); ?>
<?php if (have_posts()) : ?>
<?php $post = $posts[0]; // Hack. Set $post so that the_date() works. ?>
<?php /* If this is a category archive */ if (is_category()) { ?>
<h2 class="headline">Archive for the <?php echo single_cat_title(); ?> category</h2>
<?php /* If this is a daily archive */ } elseif (is_day()) { ?>
<h2 class="headline">Archive for
  <?php the_time('F jS, Y'); ?>
</h2>
<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>
<h2 class="headline">Archive for
  <?php the_time('F, Y'); ?>
</h2>
<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>
<h2 class="headline">Archive for
  <?php the_time('Y'); ?>
</h2>
<?php /* If this is a search */ } elseif (is_search()) { ?>
<h2 class="headline">Search results</h2>
<?php /* If this is an author archive */ } elseif (is_author()) { ?>
<h2 class="headline">Author archive</h2>
<?php /* If this is a paged archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>
  <h2 class="headline">Blog archives</h2>
  <?php } ?>
<div class="page-navigation">
  <div class="alignleft">
    <?php next_posts_link('Previous articles') ?>
  </div>
  <div class="alignright">
    <?php previous_posts_link('Next articles') ?>
  </div>
</div>
<?php while (have_posts()) : the_post(); ?>
<div class="post" id="post-<?php the_ID(); ?>">
  <div class="data">
    <?php the_time('F jS, Y') ?>
  </div>
  <h3 class="title"><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title(); ?>">
    <?php the_title(); ?>
    </a></h3>
  <div class="author">Posted 
    in
    <?php the_category(', ') ?>
    by
    <?php the_author() ?>
    <?php edit_post_link('Edit','&nbsp;|&nbsp;',''); ?>
  </div>
  <?php the_content('More'); ?>
  <?php wp_link_pages(); ?>
  <div class="feedback">
    <?php comments_popup_link(__('comments'), __('1 comments'), __('% comments'), '', __('comments off')); ?>
    <span class="link-category">See also in
    <?php the_category(', ') ?>
    </span> </div>
</div>
<?php endwhile; ?>
<div class="page-navigation">
  <div class="alignleft">
    <?php next_posts_link('Previous articles') ?>
  </div>
  <div class="alignright">
    <?php previous_posts_link('Next articles') ?>
  </div>
</div>
<?php else : ?>
<h2>Not found!</h2>
<?php include (TEMPLATEPATH . '/searchform.php'); ?>
<?php endif; ?>
<?php get_footer(); ?>