<?php get_header(); ?>

<div id="left">
  <?php if (have_posts()) : ?>
  <?php while (have_posts()) : the_post(); ?>
  <div class="entry_info" id="post-<?php the_ID(); ?>">
    <div class="entry_head"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>">
      <?php the_title(); ?>
      </a></div>
    <div class="entry_misc">
      <?php the_time('F jS, Y') ?>
      <!-- by <?php the_author() ?> -->
      <?php the_category(', ') ?>
    </div>
  </div>
  <div class="entry">
    <?php the_content('Read the rest of this entry &raquo;'); ?>
	  <?php comments_template(); // Get wp-comments.php template 
	  ?>
  </div>
  <div class="entry_bottom">
    <?php comments_popup_link('No Comments &#187;', '1 Comment &#187;', '% Comments &#187;'); ?>
  </div>
  <?php endwhile; ?>
  <?php else : ?>
  <h2 class="center">Not Found</h2>
  <p class="center">Sorry, but you are looking for something that isn't here.</p>
  <?php include (TEMPLATEPATH . "/searchform.php"); ?>
  <?php endif; ?>

</div>
<?php get_sidebar(); ?>

<?php get_footer(); ?>
