<?php

// Widgets
if ( function_exists('register_sidebar') )
    register_sidebar(array(
        'before_widget' => '',
        'after_widget' => '</div>',
        'before_title' => '<h4>',
        'after_title' => '</h4><div class="navigate">',
    ));


function widget_mytheme_search() {
?>
	<h4>Search</h4>
	<div class="navigate">
	<form method="get" id="searchform" action="<?php bloginfo('home'); ?>/">
	<input type="text" value="<?php echo wp_specialchars($s, 1); ?>" name="s" />
	</form>
	</div>
<?php
}
if ( function_exists('register_sidebar_widget') )
    register_sidebar_widget(__('Search'), 'widget_mytheme_search');


function widget_mytheme_links() {
?>
	<h4>Linkage</h4>
	<div class="navigate">
	<ul>
		<?php get_linksbyname('', '<li>', '</li>', '', FALSE, 'rand', FALSE, FALSE, -1); ?>
	</ul>
	</div>
<?php
}
if ( function_exists('register_sidebar_widget') )
    register_sidebar_widget(__('Links'), 'widget_mytheme_links');


function widget_mytheme_pages($args) {
	extract($args);
	$options = get_option('widget_pages');
	$title = empty($options['title']) ? __('Pages') : $options['title'];
?>
	<h4><?php echo "$title" ?></h4>
	<div class="navigate">
	<ul>
		<?php wp_list_pages('sort_column=menu_order&title_li='); ?>
	</ul>
	</div>
<?php
}
if ( function_exists('register_sidebar_widget') )
    register_sidebar_widget(__('Pages'), 'widget_mytheme_pages');


function widget_mytheme_recent_comments() {
} if ( function_exists('register_sidebar_widget') )
    register_sidebar_widget(__('Recent Comments'), 'widget_mytheme_recent_comments');



// Function: Get Recent Comments
function get_tenrecentcomments($mode = '', $limit = 10) {
    global $wpdb, $post;
	$where = '';
	if($mode == 'post') {
			$where = 'post_status = \'publish\'';
	} elseif($mode == 'page') {
			$where = 'post_status = \'static\'';
	} else {
			$where = '(post_status = \'publish\' OR post_status = \'static\')';
	}
    $tenrecentcomments = $wpdb->get_results("SELECT $wpdb->posts.ID, post_title, post_name, post_status, comment_author, post_date, comment_date FROM $wpdb->posts INNER JOIN $wpdb->comments ON $wpdb->posts.ID = $wpdb->comments.comment_post_ID WHERE comment_approved = '1' AND post_date < '".current_time('mysql')."' AND $where AND post_password = '' ORDER  BY comment_date DESC LIMIT $limit");
	if($tenrecentcomments) {
		foreach ($tenrecentcomments as $post) {
				$post_title = htmlspecialchars(stripslashes($post->post_title));
				$comment_author = htmlspecialchars(stripslashes($post->comment_author));
				$comment_date = mysql2date('m.d', $post->comment_date);
				echo "<li><span class=\"intr\">$comment_date</span><a href=\"".get_permalink()."\">$comment_author</a></li>\n";
		}
	} else {
		echo '<li>'.__('N/A').'</li>';
	}
}




//Original Link Drop Down Script by Owen of RedAlt

define('LINK_USE_UL', true);

function link_dropdown_page_callback($matches)
{
	global $wpdb;
	$output = '';
	
	$linkcats = $wpdb->get_results("SELECT DISTINCT cat_id, cat_name FROM {$wpdb->linkcategories}");
	$output .= '<div id="linkpage"><form id="linkcatselect" method="post">';
	$output .= '<div align="right" style="margin: 0 0 15px 0"><select name="linkcat">';
	$output .= '<option> </option>';
	$output .= '<option selected="selected" value="-1"> &nbsp; All Categories</option>';
	$output .= '<option> </option>';
	foreach($linkcats as $cat)
	{
		$output .= '<option value="' . $cat->cat_id . '"';
		if($cat->cat_id == $_REQUEST['linkcat']) $output .= ' selected="selected"';
		$output .= '>&nbsp; &nbsp; &nbsp; &#187; ' . $cat->cat_name . '</option>';
	}
	$output .= '<option> </option>';
	$output .= '</select> <input type="submit" id="linkcatsubmit" value="Change" /></div></form>';

	if(!isset($_REQUEST['linkcat'])) $_REQUEST['linkcat'] = -1;
	$ret = get_links($_REQUEST['linkcat'], '<li>', '</p></li>', '<p class="post-info">', true, 'name', true, false, -1, 1, false);
	if(LINK_USE_UL)
	{
		$output .= '<ul>' . $ret . '</ul></div>';
	}
	else
	{
		$repl = array('#<li>#'=>'<dt>','#</a>#'=>'</a></dt><dd>','#</li>#'=>'</dd>');
		$output .= '<dl id="linklist">' . preg_replace(array_keys($repl), array_values($repl), $ret) . '</dl>';
	}
	return $output;
}


function link_dropdown_page($content)
{
	$content = preg_replace_callback('|<!--linksdropdown-->|i', 'link_dropdown_page_callback', $content);
	return $content;
}

add_filter('the_content', 'link_dropdown_page');

?>