<?php
/*
File Name: Wordpress Theme Toolkit
Version: 1.0
Author: Ozh
Author URI: http://planetOzh.com/
*/

/************************************************************************************
 * THEME USERS : don't touch anything !! Or don't ask the theme author for support :)
 ************************************************************************************/

include(dirname(__FILE__).'/themetoolkit.php');

/************************************************************************************
 * THEME AUTHOR : edit the following function call :
 ************************************************************************************/

themetoolkit(
	'darkcash', /* Make yourself at home :
			* Name of the variable that will contain all the options of
			* your theme admin menu (in the form of an array)
			* Name it according to PHP naming rules (http://php.net/variables) */

	array(     /* Variables used by your theme features (i.e. things the end user will
			* want to customize through the admin menu)
 			* Syntax :
			* 'option_variable' => 'Option Title ## optionnal explanations',
			* 'option_variable' => 'Option Title {radio|value1|Text1|value2|Text2} ## optionnal explanations',
			* 'option_variable' => 'Option Title {textarea|rows|cols} ## optionnal explanations',
			* 'option_variable' => 'Option Title {checkbox|option_varname1|value1|Text1|option_varname2|value2|Text2} ## optionnal explanations',
			* Examples :
			* 'your_age' => 'Your Age',
			* 'cc_number' => 'Credit Card Number ## I can swear I will not misuse it :P',
			* 'gender' => 'Gender {radio|girl|You are a female|boy|You are a male} ## What is your gender ?'
			* Dont forget the comma at the end of each line ! */

	'sep1' => '<u>Main Options</u> {separator}',
	'themecolor' => 'Theme Colour: ## <small>Enter a HEX colour ("#a1b2c3", "#002080", etc...)<br />The default theme colour is <strong>#2c97a2</strong><br />You can find a HEX generator <a href="http://www.colorschemer.com/online.html" target="_blank">here</a></small>',
	'font' => 'Font type: {radio|normal|Normal (default)|special|Special} ## <small>If you require special characters for the headlines choose "special"<br />If your characters are still not showing up please read the readme file</small>',
	'case' => 'Headline case: {radio|capitalize|Capitalize|upper|Uppercase (default)|lower|Lowercase} ## <small>Change the case of the headlines within posts and the menu</small>',
	'author' => 'Post Author: {radio|on|On|off|Off (default)} ## <small>Turn the post author information within the post on and off</small>',
	'tagcat' => 'Tags or Categories: {radio|tags|Tags (default)|cats|Categories} ## <small>Would you like to use the term &quot;Tags&quot; or &quot;Categories&quot;?<br />This is only for optics, no significant changes are made to WordPress</small>',
	'vertline' => 'Vertical Menu Line: {radio|on|On (default)|off|Off} ## <small>Turn the vertical line seperating the menu and content on and off</small>',
	'rsslinks' => 'RSS Links in Footer: {radio|on|On (default)|off|Off} ## <small>Turn the RSS links in the footer on and off</small>',
	'sep2' => '<u>Logo Options</u> {separator}',
	'logo' => 'Logo/Title: {radio|image|Image (default)|title|Blog Title} ## <small>Choose if you would like to use an image or the blog title as your logo<br />Choose &quot;Image&quot; and overwrite &quot;logo.png&quot; in the &quot;images&quot; directory for your own logo',
	'reflection' => 'Logo Reflection: {radio|on|On (default)|off|Off} ## <small>Turn the reflection on the logo on and off (logo/title must be set to &quot;Image&quot;)</small>',
	'refheight' => 'Reflection Height: ## <small>Experiment with values between 1&ndash;100 to determine how high the reflection will be on the logo<br />Default value is <strong>35</strong></small>',
	'refopac' => 'Reflection Opacity: ## <small>Experiment with values between 1&ndash;100 to determine the opacity on the logo&rsquo;s reflection<br />Default value is <strong>40</strong></small>',
	'sep3' => '<u>E-mail Options</u> {separator}',
	'emailicon' => 'E-mail Icon: {radio|on|On|off|Off (default)} ## <small>Turn the e-mail address icon in the header on and off</small>',
	'emailaddy' => 'E-mail Address: ## <small>Enter your e-mail address that will be used with the e-mail icon</small>',


	/*'debug' => 'debug', 	/* this is a fake entry that will activate the "Programmer's Corner"
			 * showing you vars and values while you build your theme. Remove it
			 * when your theme is ready for shipping */
	),
	__FILE__	 /* Parent. DO NOT MODIFY THIS LINE !
			  * This is used to check which file (and thus theme) is calling
			  * the function (useful when another theme with a Theme Toolkit
			  * was installed before */
);
	
/************************************************************************************
 * THEME AUTHOR : Congratulations ! The hard work is all done now :)
 *
 * From now on, you can create functions for your theme that will use the array
 * of variables $darkcash->option. For example there will be now a variable
 * $darkcash->option['your_age'] with value as set by theme end-user in the admin menu.
 ************************************************************************************/

/***************************************
 * Additionnal Features and Functions
 *
 * Create your own functions using the array
 * of user defined variables $darkcash->option.
 *
 ************************************s**/

//Theme colour styles
	function darkcash_themecolor() {
		global $darkcash;
			if ( $darkcash->option['themecolor'] ) {
					print $darkcash->option['themecolor'];
				}
	}

//Headline Font
	function darkcash_font() {
		global $darkcash;
			if($darkcash->option['font'] == 'normal') { 
					print ".swf";
				}
			else {
					print "_special.swf";
				}
	}

//Headline case
	function darkcash_case() {
		global $darkcash;
			if($darkcash->option['case'] == 'lower') { 
					print "lower";
				}
			elseif($darkcash->option['case'] == 'capitalize') { 
					print "capitalize";
				}
			else {
					print "upper";
				}
	}

//Post author
	function darkcash_author() {
		global $darkcash;
			if($darkcash->option['author'] == 'on') { 
					print "famaut";
				}
			else {
					print "hide";
				}
	}

//Categories vs tags
	function darkcash_tagcat1() {
		global $darkcash;
			if($darkcash->option['tagcat'] == 'tags') { 
					print "Tags";
				}
			else {
					print "Categories";
				}
	}
	function darkcash_tagcat2() {
		global $darkcash;
			if($darkcash->option['tagcat'] == 'tags') { 
					print "Tagged as:";
				}
			else {
					print "Filed as:";
				}
	}
	function darkcash_tagcat3() {
		global $darkcash;
			if($darkcash->option['tagcat'] == 'tags') { 
					print "famtag";
				}
			else {
					print "famtab";
				}
	}

//Vertical line
	function darkcash_vertline() {
		global $darkcash;
			if($darkcash->option['vertline'] == 'on') { 
					print "#000 url(";
					print bloginfo('stylesheet_directory');
					print "/assets/images/bg_content.png) repeat-y center top";
				}
			else {
					print "#000";
				}
	}

//RSS links
	function darkcash_rsslinks() {
		global $darkcash;
			if($darkcash->option['rsslinks'] == 'on') { 
					print "unhide";
				}
			else {
					print "hide";
				}
	}

//Logo
	function darkcash_logo() {
		global $darkcash;
			if($darkcash->option['logo'] == 'image') { 
					print "unhide";
				}
			else {
					print "hide";
				}
	}

//Title
	function darkcash_title() {
		global $darkcash;
			if($darkcash->option['logo'] == 'title') { 
					print "unhide";
				}
			else {
					print "hide";
				}
	}

//Logo reflection
	function darkcash_reflection() {
		global $darkcash;
			if($darkcash->option['reflection'] == 'on') { 
					print "<script src=\"";
					print bloginfo('stylesheet_directory');
					print "/assets/scripts/reflection.js\" type=\"text/javascript\"></script>";
				}
	}

//Reflection height
	function darkcash_refheight() {
		global $darkcash;
			if($darkcash->option['reflection'] == 'on') { 
					print ' rheight';
					print $darkcash->option['refheight'];
				}
	}

//Reflection opacity
	function darkcash_refopac() {
		global $darkcash;
			if($darkcash->option['reflection'] == 'on') { 
					print ' ropacity';
					print $darkcash->option['refopac'];
				}
	}

//E-mail icon
	function darkcash_emailicon() {
		global $darkcash;
			if($darkcash->option['emailicon'] == 'on') { 
					print "unhide";
				}
			else {
					print "hide";
				}
	}

//E-mail address
	function darkcash_emailaddy() {
		global $darkcash;
			if($darkcash->option['emailicon'] == 'on') { 
					print $darkcash->option['emailaddy'];
				}
	}

// Set defaults
	if (!$darkcash->is_installed()) {
		$set_defaults['themecolor'] = '#2c97a2';
		$set_defaults['font'] = 'normal';
		$set_defaults['case'] = 'upper';
		$set_defaults['author'] = 'off';
		$set_defaults['tagcat'] = 'tags';
		$set_defaults['vertline'] = 'on';
		$set_defaults['rsslinks'] = 'on';
		$set_defaults['logo'] = 'image';
		$set_defaults['reflection'] = 'on';
		$set_defaults['refheight'] = '35';
		$set_defaults['refopac'] = '40';
		$set_defaults['emailicon'] = 'off';
		$result = $darkcash->store_options($set_defaults);
	} 

//Widgets
	if ( function_exists('register_sidebar') )
		register_sidebar();
?>