<?php 
/* Don't remove these lines. */
add_filter('comment_text', 'popuplinks');
foreach ($posts as $post) { start_wp();
?>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title><?php echo get_settings('blogname'); ?> - <?php echo sprintf(__("Comments on %s"), the_title('','',false)); ?></title>

	<script src="<?php bloginfo('stylesheet_directory'); ?>/assets/scripts/sifr.js" type="text/javascript"></script>

	<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php echo get_settings('blog_charset'); ?>" />
	
	<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
	<!--[if lt IE 7]>
		<link href="<?php bloginfo('stylesheet_directory'); ?>/assets/styles/style_ltie7.css" rel="stylesheet" type="text/css" media="screen" />
	<![endif]-->
	<link href="<?php bloginfo('stylesheet_directory'); ?>/assets/styles/style_print.css" rel="stylesheet" type="text/css" media="print" />

	<style type="text/css" media="screen">
		body {
			padding: 10px;
			background: #000;
			}
		h1 {
			margin-bottom: 20px;
			}
		h1 , h2 , h4 , a , a:visited , form em {color: <?php darkcash_themecolor() ?>;}
	</style>

</head>
<body id="commentspopup">

<!--<h1 id="header"><a href="#" title="<?php echo get_settings('blogname'); ?>"><?php echo get_settings('blogname'); ?></a></h1>-->

<h4 id="comments"><?php _e("Comments"); ?></h4>

<p>&raquo; <?php comments_rss_link(__('<abbr title="Really Simple Syndication">RSS</abbr> feed for comments on this post.')); ?></p>

<?php if ('open' == $post->ping_status) { ?>
<p>&raquo; <?php _e("The <acronym title=\"Uniform Resource Identifier\">URI</acronym> to TrackBack this entry is:"); ?> <em><?php trackback_url() ?></em></p>
<?php } ?>

<?php
// this line is WordPress' motor, do not delete it.
$commenter = wp_get_current_commenter();
extract($commenter);
$comments = get_approved_comments($id);
$commentstatus = get_post($id);
if (!empty($commentstatus->post_password) && $_COOKIE['wp-postpass_'. COOKIEHASH] != $commentstatus->post_password) {  // and it doesn't match the cookie
	echo(get_the_password_form());
} else { ?>


<span class="noprint">
<?php if ( comments_open() ) : ?>
	&raquo; <a href="#postcomment" title="<?php _e("Leave a comment"); ?>">Leave a comment now</a>
<?php endif; ?>
</span>


<?php if ($comments) { ?>
<ol id="commentlist">
<?php foreach ($comments as $comment) { ?>
	<li id="comment-<?php comment_ID() ?>"><span class="postnumber"><?php printf("%0d", ++$commentNr);?></span>
	<div class="commenttext"><?php comment_text() ?></div>
	<p><cite><?php comment_type(__('Comment'), __('Trackback'), __('Pingback')); ?> <?php _e('made by'); ?> <?php comment_author_link() ?> <?php _e('on'); ?> <?php comment_date() ?> @ <a href="#comment-<?php comment_ID() ?>"><?php comment_time() ?></a></cite><?php edit_comment_link(__("<span class=famedt>Edit Comment</span>"), '<br />'); ?></p>
	</li>

<?php } // end for each comment ?>
</ol>

<?php } else { // this is displayed if there are no comments so far ?>
	<p><?php _e("No comments yet."); ?></p>
<?php } ?>

<?php if ('open' == $commentstatus->comment_status) { ?>
<h4 id="postcomment"><?php _e('Leave a Comment'); ?></h4>

<form action="<?php echo get_settings('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

<fieldset>
	<ol>
	
		<li><label for="author"><?php _e("Name"); ?></label>
		<input type="text" name="author" id="author" class="textarea" value="<?php echo $comment_author; ?>" size="28" tabindex="1" />
	    <input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" />
		<input type="hidden" name="redirect_to" value="<?php echo wp_specialchars($_SERVER["REQUEST_URI"]); ?>" /></li>
		
		<li><label for="email"><?php _e("E-mail <small>(will not be published)</small>"); ?></label>
		<input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="28" tabindex="2" /></li>
		
		<li><label for="url"><?php _e("Website"); ?></label>
		<input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="28" tabindex="3" /></li>
		
		<li><blockquote class="tags"><p><small><strong>XHTML:</strong> You can use these tags: <?php echo allowed_tags(); ?></small></p></blockquote></li>
		
		<li><label for="comment"><?php _e("Your Comment"); ?></label>
		<textarea name="comment" id="comment" cols="70" rows="4" tabindex="4"></textarea></li>
		
		<li><input class="button" name="submit" type="submit" tabindex="5" value="<?php _e("Say It!"); ?>" /></li>
	  
	</ol>
</fieldset>

	<?php do_action('comment_form', $post->ID); ?>
</form>
<?php } else { // comments are closed ?>
<p><?php _e("Sorry, the comment form is closed at this time."); ?></p>
<?php }
} // end password check
?>

<div><strong><a href="javascript:window.close()"><?php _e("Close this window."); ?></a></strong></div>

<?php // if you delete this the sky will fall on your head
}
?>

<!-- // this is just the end of the motor - don't touch that line either :) -->
<?php //} ?> 
<?php // Seen at http://www.mijnkopthee.nl/log2/archive/2003/05/28/esc(18) ?>
<script type="text/javascript">
<!--
document.onkeypress = function esc(e) {	
	if(typeof(e) == "undefined") { e=event; }
	if (e.keyCode == 27) { self.close(); }
}
// -->
</script>

<!-- begin sIFR -->
	<script type="text/javascript">
		if(typeof sIFR == "function"){
			sIFR.replaceElement("h1", named({sFlashSrc: "<?php bloginfo('stylesheet_directory'); ?>/assets/fonts/centuragothic<?php darkcash_font() ?>", sColor: "<?php darkcash_themecolor() ?>", sHoverColor: "#ffffff", sBgColor: "#000000", sWmode: "transparent", sFlashVars: "textalign=right"}));
			sIFR.replaceElement("h4", named({sFlashSrc: "<?php bloginfo('stylesheet_directory'); ?>/assets/fonts/centuragothic<?php darkcash_font() ?>", sColor: "<?php darkcash_themecolor() ?>", sWmode: "transparent", sBgColor: "#000000", sFlashVars: "offsetLeft= 0"}));
		};
	</script>
<!-- end sIFR -->

</body>
</html>
