<?php get_header(); ?>

	<div id="content" class="narrowcolumn">

	<?php if (have_posts()) : ?>
		
		<?php while (have_posts()) : the_post(); ?>
				
			<div class="post" id="post-<?php the_ID(); ?>">
				<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2>
				<small style="text-transform: lowercase"><?php the_time('l, F jS, Y') ?></small>
				
				<div class="entry">
					<?php the_content('Read the rest of this entry &raquo;'); ?>
				</div>
		
				<p class="postmetadata">category: <?php the_category(', ') ?> | 
				by: <?php the_author() ?> | 
				<?php comments_popup_link('add comments &#187;', '1 comment &#187;', '% comments &#187;'); ?>
				<?php edit_post_link('edit', '<br />[', ']'); ?></p>
			</div>
			
			<div id="separator"></div>
	
		<?php endwhile; ?>

		<div class="navigation">
			<div class="alignleft"><?php previous_posts_link('&laquo; prev') ?></div>
			<div class="alignright"><?php next_posts_link('next &raquo;') ?></div>
		</div>

		
	<?php else : ?>

		<h2 class="center">Not Found</h2>
		<p class="center">Sorry, but you are looking for something that isn't here.</p>
		<?php include (TEMPLATEPATH . "/searchform.php"); ?>

	<?php endif; ?>


	
	</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
