<?php
/*
Template Name: Parent Page List

This template lists and links child pages of the current page in an unordered list.  If the child page has a custom field with the key "Excerpt", that value is also shown.
*/
?>

<?php get_header(); ?>

<?php if (have_posts()) : the_post(); ?>
		<a name="post-<?php the_ID(); ?>"></a>
		<div class="post" id="post-<?php the_ID(); ?>">
			<div class="post-header"><h2><?php the_title(); ?></h2></div>
			<div class="post-parent-page-list">
				<?php the_content(); ?>
				<ul class="parent-page-list">
					<?php
						global $id;
						$pages = & get_pages('child_of='.$id);
						foreach($pages as $page) {
							echo '<li><span class="parent-page-list-link"><a href="'.get_permalink($page->ID).'" title="'.$page->post_title.'">'.$page->post_title.'</a></span>';
							$excerpt = get_post_meta($page->ID, 'Excerpt', true);
							if (!empty($excerpt)) {
								echo ' <span class="parent-page-list-excerpt">'.$excerpt.'</span>';
							}
							echo '</li>'."\r\n";
						}
					?>
				</ul>
			</div>
		</div>
<?php else : ?>
	<?php include (TEMPLATEPATH . "/404content.php"); ?>
<?php endif; ?>

<?php get_footer(); ?>