<?php

function braille_info($show='') {
	echo get_braille_info($show);
}

function get_braille_info($show='') {
	global $themeVersion;

	switch ($show) {
		case 'version' :
    		$output = $themeVersion;
			break;
		case 'scheme' :
			$output = get_bloginfo('template_url') . '/schemes/' . get_option('braillescheme');
			break;
		case 'update' :
			if ( current_user_can('read') ) {
				$output = "<script src=\"http://martinhipp.com/braille/version.php?version=$themeVersion\" type=\"text/javascript\"></script>";
			}
			break;
	}
	return $output;
}

function get_braille_ping_type($trackbacktxt = 'Trackback', $pingbacktxt = 'Pingback') {
	$type = get_comment_type();
	switch( $type ) {
		case 'trackback' :
			return $trackbacktxt;
			break;
		case 'pingback' :
			return $pingbacktxt;
			break;
	}
	return false;
}

function braille_body_class( $print = true ) {
	global $wp_query, $current_user;

	$c = array('wordpress');

	braille_date_classes(time(), $c);

	is_home()       ? $c[] = 'home'       : null;
	is_archive()    ? $c[] = 'archive'    : null;
	is_date()       ? $c[] = 'date'       : null;
	is_search()     ? $c[] = 'search'     : null;
	is_paged()      ? $c[] = 'paged'      : null;
	is_attachment() ? $c[] = 'attachment' : null;
	is_404()        ? $c[] = 'four04'     : null;

	if ( is_single() ) {
		the_post();
		$c[] = 'single';
		if ( isset($wp_query->post->post_date) )
			braille_date_classes(mysql2date('U', $wp_query->post->post_date), $c, 's-');
		foreach ( (array) get_the_category() as $cat )
			$c[] = 's-category-' . $cat->category_nicename;
			$c[] = 's-author-' . get_the_author_login();
		rewind_posts();
	}

	else if ( is_author() ) {
		$author = $wp_query->get_queried_object();
		$c[] = 'author';
		$c[] = 'author-' . $author->user_nicename;
	}

	else if ( is_category() ) {
		$cat = $wp_query->get_queried_object();
		$c[] = 'category';
		$c[] = 'category-' . $cat->category_nicename;
	}

	else if ( is_page() ) {
		the_post();
		$c[] = 'page';
		$c[] = 'page-author-' . get_the_author_login();
		rewind_posts();
	}

	if ( $current_user->ID )
		$c[] = 'loggedin';

	$c = join(' ', apply_filters('body_class',  $c));

	return $print ? print($c) : $c;
}

function braille_post_class( $print = true ) {
	global $post, $braille_post_alt;

	$c = array('hentry', "p$braille_post_alt", $post->post_type, $post->post_status);

	$c[] = 'author-' . get_the_author_login();

	foreach ( (array) get_the_category() as $cat )
		$c[] = 'category-' . $cat->category_nicename;

	braille_date_classes(mysql2date('U', $post->post_date), $c);

	if ( ++$braille_post_alt % 2 )
		$c[] = 'alt';

	$c = join(' ', apply_filters('post_class', $c));

	return $print ? print($c) : $c;
}
$braille_post_alt = 1;

function braille_comment_class( $print = true ) {
	global $comment, $post, $braille_comment_alt;

	$c = array($comment->comment_type, "c$braille_comment_alt");

	if ( $comment->user_id > 0 ) {
		$user = get_userdata($comment->user_id);

		$c[] = "byuser commentauthor-$user->user_login";

		if ( $comment->user_id === $post->post_author )
			$c[] = 'bypostauthor';
	}

	braille_date_classes(mysql2date('U', $comment->comment_date), $c, 'c-');
	if ( ++$braille_comment_alt % 2 )
		$c[] = 'alt';
		
	if ( is_trackback() ) {
		$c[] = 'trackback';
	}

	$c = join(' ', apply_filters('comment_class', $c));

	return $print ? print($c) : $c;
}

function braille_date_classes($t, &$c, $p = '') {
	$t = $t + (get_settings('gmt_offset') * 3600);
	$c[] = $p . 'y' . gmdate('Y', $t);
	$c[] = $p . 'm' . gmdate('m', $t);
	$c[] = $p . 'd' . gmdate('d', $t);
	$c[] = $p . 'h' . gmdate('h', $t);
}

?>