<?php 

// This retrieves info from the style.css file
$themeInfo = get_theme_data(TEMPLATEPATH . '/style.css');
$themeVersion = $themeInfo['Version'];
if(!$themeVersion) {
	$themeVersion = "unknown";
}

// This adds the CSS to the Options page
add_action('admin_head', 'admin_css');

// This is the CSS for the Options page
function admin_css() { ?>
<style type="text/css">
.configure h3 {
	font: normal 2em Georgia;
	margin: 30px 0 0;
	color: #333;
}
.configure input[type=submit], select, textarea, #braille-menu {
	width: 300px;
}
select {
	width: 308px;
}
.configure {
	width: 80%;
	margin: 0 auto 2em;
	font-size: 1.1em;
	color: #666;
}
table {
	margin: 30px auto;
	padding: 0;
	border-spacing: 0;
}
table tr td {
	line-height: 25px;
}
table th {
	text-align: right;
	line-height: 25px;
	font-size: 0.9em;
}
table p {
	width: 310px;
	text-align: justify;
}
</style>
<?php }

// Initate Braille Options page
include(TEMPLATEPATH . '/options/braille.php');
braille::init();

include(TEMPLATEPATH . '/options/info.php');
include(TEMPLATEPATH . '/options/plugins.php');
include(TEMPLATEPATH . '/options/widgets.php');
include(TEMPLATEPATH . '/options/header.php');

?>
