<?php

if ( function_exists('register_sidebars') ) {
	register_sidebars(2, array(
		'name'			=>	'Sidebar %d',
		'before_widget'	=>	'<li class="%1$s">',
        'after_widget'	=>	'</li>',
        'before_title'	=>	'<h3>',
        'after_title'	=>	'</h3>',
	));

	register_sidebar_widget(__('Search'), 'braille_search');
	register_sidebar_widget(__('Admin', 'braille'), 'braille_admin_control');
	register_sidebar_widget(__('Syndicate', 'braille'), 'braille_feed_links');
	register_sidebar_widget(__('Categories'), 'braille_category_links');
	register_sidebar_widget(__('Archives'), 'braille_archive_links');
	register_sidebar_widget(__('Meta'), 'braille_meta_links');
	
	unregister_widget_control('search');
	unregister_widget_control('syndicate');
	unregister_widget_control('categories');
	unregister_widget_control('archives');
	unregister_widget_control('meta');

}

function braille_search() { ?>
	<li class="blog-search">
		<?php include (TEMPLATEPATH . '/searchform.php'); ?>
	</li>
<?php }

function braille_feed_links() { ?>
	<li class="feed-links">
		<h3><?php _e('Syndicate', 'braille'); ?></h3>
		<ul>
			<li><a href="<?php bloginfo('rss2_url'); ?>" title="<?php _e('RSS 2.0', 'braille'); ?>" rel="alternate" type="application/rss+xml"><?php _e('RSS 2.0', 'braille'); ?></a></li>
			<li><a href="<?php bloginfo('atom_url'); ?>" title="<?php _e('Atom 0.3', 'braille'); ?>" rel="alternate" type="application/atom+xml"><?php _e('Atom 0.3', 'braille'); ?></a></li>
		</ul>
	</li>
<?php }

function braille_category_links() { ?>
	<li class="category-links">
		<h3><?php _e('Categories', 'braille'); ?></h3>
		<ul>
			<?php wp_list_cats('sort_column=name&optioncount=1'); ?>
		</ul>
	</li>
<?php }

function braille_archive_links() { ?>
	<li class="archive-links">
		<h3><?php _e('Archives', 'braille'); ?></h3>
		<ul>
			<?php get_archives('monthly','','custom','<li>','</li>'); ?>
		</ul>
	</li>
<?php }

function braille_meta_links() { ?>
	<li class="meta-links">
		<h3><?php _e('Meta', 'braille'); ?></h3>
		<ul>
			<li><?php wp_loginout(); ?></li>
			<?php wp_meta(); ?>
		</ul>
	</li>
<?php }

function braille_post_links() { ?>
	<div class="navigation">
	<?php if (is_single()) { ?>
		<?php previous_post('<span class="nav-previous">&laquo; %</span>','','yes') ?>
		<?php next_post('<span class="nav-next">% &raquo;</span>','','yes') ?>
		<div class="clear"></div>
	<?php }
	else { ?>
		<?php posts_nav_link('','','<span class="nav-previous">&laquo; '.__('Previous Entries', 'braille').'</span>'); ?>
		<?php posts_nav_link('','<span class="nav-next">'.__('Next Entries', 'braille').' &raquo;</span>','');  ?>
		<div class="clear"></div>
	<?php } ?>
	</div>
<?php } ?>