<?php get_header(); ?>

<div id="search">

<?php if (have_posts()) { ?>

    <h1>Search Results for <em><?php _e(get_query_var('s')); ?></em></h1>

    <?php

        if (!is_paged()) {

            $from = 1;

            $to = ($wp_query->found_posts <= $wp_query->query_vars['posts_per_page']) ? $wp_query->found_posts : $wp_query->query_vars['posts_per_page'];

        } else {

            $from = ($wp_query->query_vars['paged'] * $wp_query->query_vars['posts_per_page']) - ($wp_query->query_vars['posts_per_page'] - 1);

            if ($wp_query->query_vars['paged'] == $wp_query->max_num_pages) {

                $to = $wp_query->found_posts;

            } else {

                $to = $wp_query->query_vars['paged'] * $wp_query->query_vars['posts_per_page'];

            }

        }

    ?>

    <p>Results <strong><?php echo $from; ?> - <?php echo $to; ?></strong> of <strong><?php echo $wp_query->found_posts; ?></strong> for <strong><?php _e(get_query_var('s')); ?></strong></p>

    <dl>

    <?php while (have_posts()) { the_post(); ?>

        <dt><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php echo $from; ?>. <?php the_title(); ?></a></dt>

        <dd>Posted by <?php the_author_posts_link(); ?> on <a href="<?php _e(get_month_link(get_the_time('Y'), get_the_time('m'))); ?>"><?php the_time(get_option('date_format')); ?></a> in <?php the_category(', '); ?><?php edit_post_link('Edit', ' | ', ''); ?></dd>

        <dd><?php the_excerpt(); ?></dd>

        <?php $from++; ?>

    <?php } ?>

    </dl>

    <?php include TEMPLATEPATH . '/includes/links.php'; ?>

<?php } else { ?>

    <div id="no-results">

        <h1>Search Results for <em><?php _e(get_query_var('s')); ?></em></h1>

        <p>Sorry, your search for <em><?php _e(get_query_var('s')); ?></em> returned no results.</p>

    </div><!-- /no-results -->

<?php } ?>

</div><!-- /search -->

<?php get_sidebar(); ?>

<?php get_footer(); ?>
