<?php get_header(); ?>

<div id="attachment">

<?php if (have_posts()) { ?>

    <?php while (have_posts()) { the_post(); ?>

        <h1><?php the_title(); ?></h1>

        <p>Posted by <?php the_author_posts_link(); ?> on <a href="<?php _e(get_month_link(get_the_time('Y'), get_the_time('m'))); ?>"><?php the_time(get_option('date_format')); ?></a> in <?php the_category(', '); ?><?php edit_post_link('Edit', ' | ', ''); ?></p>

        <?php the_content(); ?>

        <p><?php the_attachment_link(); ?> (<?php echo round(filesize(get_attached_file($post->ID)) / 1024); ?><abbr title="Kilobytes">Kb</abbr>)</p>

        <!--
        <?php trackback_rdf(); ?>

        -->

    <?php } ?>

    <?php comments_template(); ?>

    <div id="post-comments-rss">

        <h2>Subscribe</h2>

        <p>Follow comments by subscribing to the <?php comments_rss_link(get_the_title() . ' Comments RSS'); ?> feed.</p>

    </div><!-- /post-comments-rss -->

    <div id="author-posts">

        <h2>More</h2>

        <p>Read more posts by <?php the_author_posts_link(); ?></p>

    </div><!-- /author-posts -->

    <?php $author_id = get_the_author_ID(); $userdata = get_userdata($author_id); ?>

    <?php if ($userdata->description != '') { ?>

        <div id="about-author">

            <h2>About the Author</h2>

            <p><?php _e($userdata->description); ?></p>

        </div><!-- /about-author -->

    <?php } ?>

    <div id="post-links">

        <?php previous_post_link('%link'); ?> <?php next_post_link('%link'); ?>

    </div><!-- /post-links -->

<?php } else { ?>

    <?php include TEMPLATEPATH . '/includes/error.php'; ?>

<?php } ?>

</div><!-- /attachment -->

<?php get_sidebar(); ?>

<?php get_footer(); ?>
