<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head profile="http://gmpg.org/xfn/11">

<title><?php sd_the_title(); ?> - <?php bloginfo('name'); ?></title>

<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" />
<?php $theme_data = get_theme_data(get_template_directory() . '/style.css'); ?>
<meta name="theme" content="<?php echo $theme_data['Name']; ?> <?php echo $theme_data['Version']; ?>" />

<link rel="schema.DC" href="http://purl.org/dc/elements/1.1/" />
<?php sd_contributors($post->ID, $post_author); ?>
<meta name="DC.contributor" content="<?php bloginfo('name'); ?>" />
<meta name="DC.coverage" content="Earth" />
<meta name="DC.creator" content="<?php $post_author = get_userdata($post->post_author); echo $post_author->display_name; ?>" />
<meta name="DC.date" content="<?php sd_the_date($post->post_date); ?>" />
<meta name="DC.description" content="<?php sd_description($post); ?>" />
<meta name="DC.format" content="<?php echo ($post->post_mime_type == '') ? get_bloginfo('html_type') : $post->post_mime_type; ?>" />
<meta name="DC.identifier" content="<?php sd_the_url(); ?>" />
<meta name="DC.language" content="en" />
<meta name="DC.publisher" content="<?php bloginfo('name'); ?>" />
<meta name="DC.relation" content="<?php sd_the_url(); ?>" />
<meta name="DC.rights" content="Copyright <?php echo date('Y'); ?> by <?php bloginfo('name'); ?>" />
<meta name="DC.source" content="<?php sd_the_url(); ?>" />
<meta name="DC.subject" content="<?php sd_the_title(); ?>" />
<meta name="DC.title" content="<?php sd_the_title(); ?> - <?php bloginfo('name'); ?>" />
<meta name="DC.type" content="<?php echo ($post->post_mime_type == '') ? get_bloginfo('html_type') : $post->post_mime_type; ?>" />

<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS 2.0 Feed" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="alternate" type="application/rdf+xml" title="<?php bloginfo('name'); ?> RSS 1.0 Feed" href="<?php bloginfo('rdf_url'); ?>" />
<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS 0.92 Feed" href="<?php bloginfo('rss_url'); ?>" />
<link rel="alternate" type="application/atom+xml" title="<?php bloginfo('name'); ?> Atom Feed" href="<?php bloginfo('atom_url'); ?>" />
<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> Comments RSS 2.0 Feed" href="<?php bloginfo('comments_rss2_url'); ?>" />

<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />

<?php wp_get_archives('format=link'); ?>

<style type="text/css" media="screen">@import url("<?php bloginfo('stylesheet_url'); ?>");</style>
<style type="text/css" media="print">@import url("<?php bloginfo('template_url'); ?>/print.css");</style>

<?php wp_head(); ?>

</head>
<body>
    <div id="body">

        <div id="header">

            <div id="admin">

                <?php global $user_identity; get_currentuserinfo(); ?>

                <ul>

                    <?php echo ($user_identity != '') ? '<li>Hello, <a href="' . get_bloginfo('url') . '/wp-admin/profile.php">' . $user_identity . '</a></li>' : ''; ?>

                    <?php wp_register(); ?>

                    <li><?php wp_loginout(); ?></li>

                </ul>

            </div><!-- /admin -->

            <div id="banner">

                <p><a href="<?php bloginfo('url'); ?>/"><?php bloginfo('name'); ?></a></p>

                <p><?php bloginfo('description'); ?></p>

            </div><!-- /banner -->

            <div id="navigation">

                <ul>

                    <li class="page_item<?php echo (is_home()) ? ' current_page_item' : ''; ?>"><a href="<?php bloginfo('url'); ?>">Home</a></li>

                    <?php wp_list_pages('sort_column=menu_order&depth=1&title_li='); ?>

                </ul>

            </div><!-- /navigation -->

        </div><!-- /header -->

        <div id="content">
