<?php

if (function_exists('register_sidebar')) {
    register_sidebar(
        array(
            'before_widget' => "\r\n" . '<div id="%1$s" class="widget %2$s">',
            'after_widget'  => '</div><!-- /widget -->' . "\r\n",
            'before_title'  => '<h2>',
            'after_title'   => '</h2>',
        )
    );
}

function widget_sd_search()
{
?>

<div id="search-form">

    <h2>Search</h2>

    <form method="get" action="<?php echo get_option('home'); ?>/">
        <fieldset>
            <legend>Search</legend>
            <input name="s" type="text" />
            <input type="submit" value="<?php _e('Search'); ?>" />
        </fieldset>
    </form>

</div><!-- /search-form -->

<?php
}

if (function_exists('register_sidebar_widget')) {
    register_sidebar_widget(__('Search'), 'widget_sd_search');
}

function sd_the_title()
{
    $str = '';
    if (is_home()) {
        $str .= get_bloginfo('description');
    } elseif (is_search()) {
        $str .= 'Search Results' . ' for ' . get_query_var('s');
    } elseif (is_404()) {
        $str .= 'Recent Posts';
    } elseif (is_date()) {
        if (is_year()) {
            $str .= get_the_time('Y');
        } elseif (is_month()) {
            $str .= single_month_title(' ', false);
        } elseif (is_day()) {
            $str .= get_the_time(get_option('date_format'));
        }
    } else {
        $str .= trim(wp_title('', false));
    }
    _e(str_replace('  ', ' ', $str));
}

function sd_the_url()
{
    echo get_bloginfo('url') . str_replace('&', '&amp;', $_SERVER['REQUEST_URI']);
}

function sd_the_date($datetime)
{
    echo substr($datetime, 0, 10);
}

function sd_contributors($post_id, $post_author)
{
    $str = '';
    $approved_comments = get_approved_comments($post_id);
    $ary = array();
    foreach ($approved_comments as $comment) {
        if ($comment->comment_author != $post_author && $comment->comment_author != 'admin') {
            $ary[] = $comment->comment_author;
        }
    }
    $ary = array_unique($ary);
    foreach ($ary as $contributor) {
        $str .= '<meta name="DC.contributor" content="' . $contributor . '" />' . "\n";
    }
    echo $str;
}

function sd_description($post)
{
    $str = '';
    if ($post->post_excerpt != '') {
        $str .= $post->post_excerpt;
    } else {
        $str .= get_bloginfo('description');
    }
    echo _e(strip_tags($str));
}

?>
