<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title>
<?php bloginfo('name'); ?>
<?php if ( is_single() ) { ?>
&raquo; Blog Archive
<?php } ?>
<?php wp_title(); ?>
</title>
<meta name="generator" content="WordPress <?php bloginfo('version'); ?>" />
<!-- leave this for stats -->
<link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>" type="text/css" media="screen" />
<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php wp_head(); ?>
</head>
<body>
<!-- start header -->
<?php get_header(); ?>
<!-- end header -->
<hr />
<!-- start page -->
<div id="page">
  <!-- start sidebar one -->
	<div id="sidebar1" class="sidebar">
    <ul>
      <?php 	/* Widgetized sidebar, if you have the plugin installed. */
		if ( function_exists('dynamic_sidebar')  && dynamic_sidebar(2))  : else :  ?>
      <li>
        <h2>
          <?php _e('Recent Posts'); ?>
        </h2>
        <ul>
          <?php get_archives('postbypost', '10', 'custom', '<li>', '</li>'); ?>
        </ul>
      </li>
      <?php endif; ?>
    </ul>
  </div>
  <!-- end sidebar one -->
  <!-- start content -->
  <div id="content">
    <?php if (have_posts()) : ?>
    <?php while (have_posts()) : the_post(); ?>
    <div class="post" id="post-<?php the_ID(); ?>">
      <h1 class="title"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title_attribute(); ?>">
        <?php the_title(); ?>
        </a></h1>
      <p class="meta"></p>
      <div class="entry">
        <?php the_content('Read the rest of this entry &raquo;'); ?>
      </div>
      <div class="info">
        <p class="links">
          <?php the_author() ?>
          &nbsp;
          |&nbsp;
          <?php the_category(', ') ?>
          &nbsp;
          |&nbsp;
          <?php the_time('m jS, Y') ?>
          &nbsp;
          &nbsp;|&nbsp;
          <?php edit_post_link('Edit','','&nbsp;|&nbsp;'); ?>
          <?php comments_popup_link('No Comments &raquo;', '1 Comment &raquo;', '% Comments &raquo;'); ?>
        </p>
        <p class="tags">
          <?php the_tags('Tags: ', ', ', ' '); ?>
        </p>
      </div>
    </div>
    <?php endwhile; ?>
    <div class="navigation">
      <div class="alignleft">
        <?php next_posts_link('&laquo; Older Entries') ?>
      </div>
      <div class="alignright">
        <?php previous_posts_link('Newer Entries &raquo;') ?>
      </div>
    </div>
    <?php else : ?>
    <h2 class="center">Not Found</h2>
    <p class="center">Sorry, but you are looking for something that isn't here.</p>
    <?php include (TEMPLATEPATH . "/searchform.php"); ?>
    <?php endif; ?>
  </div>
  <!-- end content -->
 <?php get_sidebar(); ?>
  <!--
<div class="navigation">
	<div class="alignleft"><?php next_posts_link('&laquo; Older Entries') ?></div>
	<div class="alignright"><?php previous_posts_link('Newer Entries &raquo;') ?></div>
</div>
-->
  <div style="clear: both;">&nbsp;</div>
</div>
<!-- end page -->
<hr />
<!-- start footer -->
 <?php get_footer(); ?>
<!-- end footer -->
</body>
</html>
