<?php get_header(); ?>

<div id="content"><a name="content"></a>

<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

<?php $attachment_link = get_the_attachment_link($post->ID, true, array(450, 800)); // This also populates the iconsize for the next line ?>

<?php $_post = &get_post($post->ID); $classname = ($_post->iconsize[0] <= 128 ? 'small' : '') . 'attachment'; // This lets us style narrow icons specially ?>

<div class="post" id="post-<?php the_ID(); ?>">
<div class="date"><span>&nbsp;</span></div>

<h2><a href="<?php echo get_permalink($post->post_parent); ?>" rev="attachment"><?php echo get_the_title($post->post_parent); ?></a> &raquo; <a href="<?php echo get_permalink() ?>" rel="bookmark" title="Permanent Link: <?php the_title(); ?>"><?php the_title(); ?></a></h2>

<div class="entry">
<p class="<?php echo $classname; ?>"><?php echo $attachment_link; ?><br /><?php echo basename($post->guid); ?></p>
<?php the_content('<p class="serif">Read the rest of this entry &raquo;</p>'); ?>
<?php wp_link_pages(array('before' => '<p><strong>Pages:</strong> ', 'after' => '</p>', 'next_or_number' => 'number')); ?>
</div>

<div class="postmetadata"><span>&nbsp;</span></div>

</div> <!-- div.post -->

<div id="info">
This entry was posted
on <?php the_time('dHi\H M Y') ?> and is filed under <?php the_category(', ') ?>.

You can follow any responses to this entry through the <?php comments_rss_link('RSS 2.0'); ?> feed.

<?php if (('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
// Both Comments and Pings are open ?>
You can <a href="#respond">leave a response</a>, or <a href="<?php trackback_url(true); ?>" rel="trackback">trackback</a> from your own site.

<?php } elseif (!('open' == $post-> comment_status) && ('open' == $post->ping_status)) {
// Only Pings are Open ?>
Responses are currently closed, but you can <a href="<?php trackback_url(true); ?> " rel="trackback">trackback</a> from your own site.

<?php } elseif (('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
// Comments are open, Pings are not ?>
You can skip to the end and leave a response. Pinging is currently not allowed.

<?php } elseif (!('open' == $post-> comment_status) && !('open' == $post->ping_status)) {
// Neither Comments, nor Pings are open ?>
Both comments and pings are currently closed.

<?php } edit_post_link('Edit this entry.','',''); ?>
</p>
</div> <!-- div.info -->

<?php comments_template(); ?>

<?php endwhile; else: ?>

<div class="post">
<div class="date"><span>&nbsp;</span></div>

<h2 class="center">Not Found</h2>
<div class="entry">
<p>Sorry, no attachments matched your criteria.</p>
</div>
<div class="postmetadata"><span>&nbsp;</span></div>

</div>

<?php endif; ?>

</div> <!-- div#content -->

<?php get_sidebar(); ?>

<?php get_footer(); ?>