<?php get_header(); ?>

<div id="content">
  <?php if (have_posts()) : ?>
  <h2 class="pagetitle">Search Results</h2>
  <div class="navigation center">
    <?php next_posts_link('&laquo; Previous Entries') ?>
    -
    <?php previous_posts_link('Next Entries &raquo;') ?>
  </div>
  <?php while (have_posts()) : the_post(); ?>
  <div class="post">
    <h3 class="archive" id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>">
      <?php the_title(); ?>
      </a></h3>
    <p class="date-category">Filed under
      <?php the_category(', ') ?>
      |
      <?php the_time('l, F jS, Y') ?>
      <?php edit_post_link('Edit', '| ', ''); ?>
    </p>
    <div class="entry">
      <?php the_excerpt() ?>
    </div>
    <div class="comments">
      <p>
        <?php comments_popup_link('No Comments', '1 Comment', '% Comments'); ?>
      </p>
    </div>
  </div>
  <?php endwhile; ?>
  <div class="navigation center">
    <?php next_posts_link('&laquo; Previous Entries') ?>
    -
    <?php previous_posts_link('Next Entries &raquo;') ?>
  </div>
  <?php else : ?>
  <h2 class="center">No posts found. Try a different search?</h2>
  <?php include (TEMPLATEPATH . '/searchform.php'); ?>
  <?php endif; ?>
</div>
<?php get_sidebar(); ?>
<?php get_footer(); ?>
