<?php get_header(); ?>

<?php /* Counts the posts, comments and categories on your blog */
  $numposts = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->posts WHERE post_status = 'publish'");
  if (0 < $numposts) $numposts = number_format($numposts);

  $numcomms = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->comments WHERE comment_approved = '1'");
  if (0 < $numcomms) $numcomms = number_format($numcomms);

  $numcats = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->categories");
  if (0 < $numcats) $numcats = number_format($numcats);
?>

<div id="container">

  <div id="content">

    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

      <h1 class="archiveTitle" id="post-<?php the_ID(); ?>"><a href="<?php the_permalink() ?>" rel="bookmark" title='Permalink auf "<?php the_title(); ?>"'><?php the_title(); ?></a></h1>

      <div class="chapter">

        <div class="entry">
          <p>Du befindest dich auf der Startseite des Archivs von <?php bloginfo('name'); ?>. Derzeit umfassen die Archive
          <?php echo $numposts; ?> Artikel und <?php echo $numcomms; ?> Kommentare (T&uuml;ten Senf), verteilt auf magere <?php echo $numcats; ?> Kategorien.
          Auf dieser Seite kannst du bequem und schnell die Archive nach Datum oder Kategorie sortiert durchforsten.
          Wenn du auf der Suche nach etwas Speziellem bist, hilft dir eventuell die Tagwolke oder die Suchbox in der Sidebar weiter.</p>
        </div>
      </div>

          <?php if (function_exists('UTW_ShowWeightedTagSetAlphabetical')) { ?>

      <div class="chapter">
        <div class="entry">
          <h1>Tag Wolke</h1>
          <p>Mit der Tagwolke kannst du dir einen &Uuml;berblick &uuml;ber die hier auf <?php bloginfo('name'); ?> am h&auml;ufigsten verwendeten Schlagworte verschaffen. Die einzelnen Tags sind dabei nach H&auml;ufigkeit der Nutzung farblich und in der Schriftgr&ouml;&szlig;e relativ zueinander gewichtet.</p>

          <?php UTW_ShowWeightedTagSetAlphabetical("coloredsizedtagcloud"); ?>
        </div>
      </div>

          <?php } ?>

          <?php if (function_exists('af_ela_super_archive')) { ?>

      <div class="chapter">
        <div class="entry" style="min-height: 500px;">

          <h1><span>Live Archives</span></h1>
          <p>Dies hier ist die sogenannte 'Live Archiv Recherche', mit der 'Ausgrabungen' im <?php bloginfo('name'); ?> Repository schnell und effizient vonstatten gehen,
          ohne etliche komplette Seiten im Browser laden zu m&uuml;ssen.</p>

          <div id="livearchives">
            <?php af_ela_super_archive('num_posts_by_cat=50&truncate_title_length=40&hide_pingbacks_and_trackbacks=1&num_entries=1&num_comments=1&number_text=<span>%</span>&comment_text=<span>%</span>&selected_text='.urlencode('')); ?>
            <div style="clear:both;">&nbsp;</div>
          </div>
        </div>
      </div>

           <?php } ?>

    <?php endwhile; endif; ?>

  </div><!-- content //-->

  <?php get_sidebar(); ?>

</div>

<?php get_footer(); ?>