// Revision: 1.2
// Last updated: 10th March 2006
function commentAdded(theID, isPaged, commentCount, comments_per_page) {
	if (hideOnSubmit == 0)
	{
		new Effect.Fade($('commentbody'));
		$('comment').disabled = true; 	// if comment success. Comment box is disable to avoid spam
		$('submit').disabled = true;  	// if comment success. Submit button is disable to avoid spam
	} else {
		$('submit').disabled = false;  // re-enable submit button
		$('comment').disabled = false; // re-enable commentbox
	}
	if ($('error')) { Element.remove('error'); }
	$('cCount').innerHTML = parseInt($('cCount').innerHTML) + 1;
	new Effect.Highlight('cCount');
	if ((isPaged == 'simple') || (commentCount < comments_per_page))
	{
		new Effect.Appear($('commentlist').lastChild);
		Element.hide('nocommentyet'); 	// hide No Comments notice if first comment added
		Behaviour.apply();
	} else {
		var commentPage = Math.round(((commentCount + 1) / comments_per_page) + 0.5);
		loadPagedComments(theID, commentPage);
	}
}

function failure(request) {
	$('submit').disabled = false;  // re-enable submit button
	$('comment').disabled = false; // re-enable commentbox
	Element.show('error');
	$('error').innerHTML = "<p>" + request.responseText + "</p>";
	new Effect.Highlight('error',{queue:'end'});
}

function loading() {
	$('submit').disabled = true;
	$('comment').disabled = true;
	Element.show('loading');
}

function complete(request,theID,isPaged,commentCount,comments_per_page) {
	Element.hide('loading');
	Element.show('commentform');
	$('submit').disabled = true;  // avoid disabling submit button
	$('comment').disabled = true; // avoid disabling commentbox

	if (request.status == 200) {commentAdded(theID,isPaged,commentCount,comments_per_page)}
	else {failure(request)};
}
