<?php
// load text domain only if blog has been configured correctly!
if (WPLANG != '')
{
	load_theme_textdomain('4null4.de');
}

$current = '1.1.1'; // dated April 13th 2006
$bb_loc = '../themes/' . basename(dirname($file));
require(ABSPATH . '/wp-content/themes/' . get_template() .'/plugins/plugins.php');
require(ABSPATH . '/wp-content/themes/' . get_template() .'/plugins/pagedcomments.php');

// =====================================================
// BEGIN ENFORCE BLOG HOMEPAGE URL STRUCTURE
// =====================================================
// The following section was initially written by Mark Jaquith as a small plugin
// named Enforce <code>www.</code> Preference.
// The plugin can be found at http://txfx.net/code/wordpress/enforce-www-preference/
// It provides 301 redirects to queries with <strong>/index.php</strong> and enforces
// your use or non-use of <strong>www.</strong> as you have configured it in the
// general options of the admin panel.

if ( $_SERVER['REQUEST_URI'] == str_replace('http://' . $_SERVER['HTTP_HOST'], '', get_bloginfo('home')) . '/index.php' ) {
	header('HTTP/1.1 301 Moved Permanently');
	header('Location: ' . get_bloginfo('home') . '/');
	exit();
}

if ( strpos($_SERVER['HTTP_HOST'], 'www.') === 0  && strpos(get_bloginfo('home'), 'http://www.') === false ) {
	header('HTTP/1.1 301 Moved Permanently');
	header('Location: http://' . substr($_SERVER['HTTP_HOST'], 4) . $_SERVER['REQUEST_URI']);
	exit();
} elseif ( strpos($_SERVER['HTTP_HOST'], 'www.') !== 0 && strpos(get_bloginfo('home'), 'http://www.') === 0 ) {
	header('HTTP/1.1 301 Moved Permanently');
	header('Location: http://www.' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
	exit();
}

// =====================================================
// END ENFORCE BLOG HOMEPAGE URL STRUCTURE
// =====================================================
// BEGIN WIDGETS SIDEBAR SUPPORT
// =====================================================

if (function_exists('register_sidebars'))
{
	register_sidebars(1);
	//register_sidebars(2, array('name'=>'Sidebar %d'));

	// now have a look for all available additional widgets and activate them
	$widgets_dir = @ dir(ABSPATH . '/wp-content/themes/' . get_template() . '/widgets');
	if ($widgets_dir)
	{
		while(($file = $widgets_dir->read()) !== false)
		{
				if (!preg_match('|^\.+$|', $file) && preg_match('|\.php$|', $file))
					//$scheme_files[] = preg_replace('|\.php$|', '', $file);
					include(ABSPATH . '/wp-content/themes/' . get_template() . '/widgets/' . $file);
		}
	}
}

// =====================================================
// END WIDGETS SIDEBAR SUPPORT
// =====================================================
// BEGIN THEME CONFIGURATION
// =====================================================

function bb_info($show='')
{
	global $current;
	switch($show)
	{
		case 'version' :
			$info = 'Beta '. $current;
			break;
		case 'scheme' :
			$scheme = get_option('bb_scheme');
			if ($scheme == "")
				$info = '/Default.css';
			else
				$info = '/schemes/' . $scheme . '.scheme.css';
			break;
	}
	return $info;
}

// define the default values in case they do not already exist
function bb_set_defaults()
{
	$autoload = 'no';
	if (!get_option('bb_blog_language'))
		add_option('bb_blog_language', 'de', 'Define the primary blog language', $autoload);
	if (!get_option('bb_sidebar_pages'))
		add_option('bb_sidebar_pages', '1', 'Define whether pages should be displayed in the Sidebar', $autoload);
	if (!get_option('bb_livesearch'))
		add_option('bb_livesearch', '0', "If you don't trust JavaScript and Ajax, you can turn off LiveSearch. Otherwise I suggest you leave it on", $autoload); // (live & classic)
	if (!get_option('bb_archives'))
		add_option('bb_archives', '', 'Set whether bb has a Live Archive page', $autoload);
	if (!get_option('bb_scheme'))
		add_option('bb_scheme', 'True Blue', 'Choose the Scheme you want bb to use', $autoload);
	if (!get_option('bb_commentsubscription'))
		add_option('bb_commentsubscription', '1', 'Choose whether a comment must be entered to subscribe to comments', $autoload);
	if (!get_option('bb_fullpingbacks'))
		add_option('bb_fullpingbacks', '0', 'Set whether to use verbose or short pingback display', $autoload);
	if (!get_option('bb_nicetitle'))
		add_option('bb_nicetitle', '1', 'Set whether to use smart tooltips', $autoload);
	if (!get_option('bb_ie7support'))
		add_option('bb_ie7support', '1', 'Enhance MSIE CSS abilities with Dean Edwards IE7 script', $autoload);
	if (!get_option('bb_utwtechnoratitags'))
		add_option('bb_utwtechnoratitags', '0', 'Define whether to show technorati tags for posts on startpage', $autoload);
	if (!get_option('bb_utw_showposts'))
		add_option('bb_utw_showposts', 'tags', 'Define whether to display related posrs or the taglist', $autoload);
	if (!get_option('bb_livecomments'))
		add_option('bb_livecomments', '0', "If you don't trust JavaScript and Ajax, you can turn off Live Commenting. Otherwise I suggest you leave it on", $autoload);
	if (!get_option('bb_singlecommenting'))
		add_option('bb_singlecommenting', '0', "Antispam countermeasure for livecomments functionality", $autoload);
	if (!get_option('bb_asidescat'))
		add_option('bb_asidescat', '0', 'A category which will be treated differently from other categories', $autoload);
	if (!get_option('bb_asidespos'))
		add_option('bb_asidespos', 'inline', 'Whether to use inline or sidebar asides', $autoload);
	if (!get_option('bb_asidesnumber'))
		add_option('bb_asidesnumber', '3', 'The number of Asides to show in the Sidebar. Default is 3.', $autoload);
	if (!get_option('bb_enable_paged_comments'))
		add_option('bb_enable_paged_comments', 'paged', 'Whether to enable AJAX paged comments or not', $autoload);
	if (!get_option('bb_paged_comments_order'))
		add_option('bb_paged_comments_order', 'DESC', 'How to order the comments (ASC or DESC)', $autoload);
	if (!get_option('bb_paged_comments_range'))
		add_option('bb_paged_comments_range', '5', 'How many pages +/- around the current one shall be directly selectable', $autoload);
	if (!get_option('bb_paged_comments_amount'))
		add_option('bb_paged_comments_amount', '10', 'How many comments per page should be displayed?', $autoload);
	if (!get_option('bb_paged_comments_fancyurl'))
		add_option('bb_paged_comments_fancyurl', '0', 'Whether to use special urlrewrite rules for paged comments', $autoload);
	if (!get_option('bb_enforce_author'))
		add_option('bb_enforce_author', '1', 'Whether to show the author info in any case or not', $autoload);
	if (!get_option('bb_full_posts'))
		add_option('bb_full_posts', 'full', 'Whether to show full posts or only excerpts of each post', $autoload);
	if (!get_option('bb_postmeta_position'))
		add_option('bb_postmeta_position', 'lower', 'Set up where to show the post meta information - above or beyond the post content', $autoload);
	if (!get_option('bb_authorblob'))
		add_option('bb_authorblob', '', 'If you feel funky, add  a small paragraph about you as the blog author to your sidebar', $autoload);
}

function bb_update()
{
	global $current;
	update_option('bb_installed', $current);

	if (!empty($_POST))
	{
		if (isset($_POST['blog_language']))
		{
			$bb_blog_language = $_POST['blog_language'];
			update_option('bb_blog_language', $bb_blog_language);
		}
		if (isset($_POST['bb_enable_paged_comments']))
		{
			$bb_enable_paged_comments = $_POST['bb_enable_paged_comments'];
			update_option('bb_enable_paged_comments', $bb_enable_paged_comments);
		}
		if (isset($_POST['bb_paged_comments_order']))
		{
			$bb_paged_comments_order = $_POST['bb_paged_comments_order'];
			update_option('bb_paged_comments_order', $bb_paged_comments_order);
		}
		if (isset($_POST['bb_paged_comments_amount']))
		{
			$bb_paged_comments_amount = $_POST['bb_paged_comments_amount'];
			update_option('bb_paged_comments_amount', $bb_paged_comments_amount);
		}
		if (isset($_POST['bb_paged_comments_range']))
		{
			$bb_paged_comments_range = $_POST['bb_paged_comments_range'];
			update_option('bb_paged_comments_range', $bb_paged_comments_range);
		}
		if (isset($_POST['bb_paged_comments_fancyurl']))
		{
			$bb_paged_comments_fancyurl = $_POST['bb_paged_comments_fancyurl'];
			update_option('bb_paged_comments_fancyurl', $bb_paged_comments_fancyurl);
		}
		if (isset($_POST['schemeswitcher']))
		{
			$bb_schemeswitcher = $_POST['schemeswitcher'];
			update_option('bb_schemeswitcher', $bb_schemeswitcher);
		}
		if (isset($_POST['enforce_author']))
		{
			$bb_enforce_author = $_POST['enforce_author'];
			update_option('bb_enforce_author', $bb_enforce_author);
		}
		if (isset($_POST['full_posts']))
		{
			$bb_full_posts = $_POST['full_posts'];
			update_option('bb_full_posts', $bb_full_posts);
		}
		if (isset($_POST['bb_scheme_file']))
		{
			$bb_scheme_file = $_POST['bb_scheme_file'];
			update_option('bb_scheme', $bb_scheme_file);
		}
		if (isset($_POST['livesearch']))
		{
			$search = $_POST['livesearch'];
			update_option('bb_livesearch', $search);
		}
		if (isset($_POST['fullpingbacks']))
		{
			$fullpingbacks = $_POST['fullpingbacks'];
			update_option('bb_fullpingbacks', $fullpingbacks);
		}
		if (isset($_POST['commentsubscription']))
		{
			$search = $_POST['commentsubscription'];
			update_option('bb_commentsubscription', $search);
		}
		if (isset($_POST['nicetitle']))
		{
			$bb_nicetitle = $_POST['nicetitle'];
			update_option('bb_nicetitle', $bb_nicetitle);
		}
		if (isset($_POST['ie7support']))
		{
			$ie7support = $_POST['ie7support'];
			update_option('bb_ie7support', $ie7support);
		}
		if (isset($_POST['utwtechnoratitags']))
		{
			$utwtechnoratitags = $_POST['utwtechnoratitags'];
			update_option('bb_utwtechnoratitags', $utwtechnoratitags);
		}
		if (isset($_POST['utw_showposts']))
		{
			$bb_utw_showposts = $_POST['utw_showposts'];
			update_option('bb_utw_showposts', $bb_utw_showposts);
		}
		if (isset($_POST['livecommenting']))
		{
			$commenting = $_POST['livecommenting'];
			update_option('bb_livecomments', $commenting);
		}
		if (isset($_POST['singlecommenting']))
		{
			$singlecommenting = $_POST['singlecommenting'];
			update_option('bb_singlecommenting', $singlecommenting);
		}
		if (isset($_POST['bb_asidescat']) ) {
			$bb_asidescat = $_POST['bb_asidescat'];
			update_option('bb_asidescat', $bb_asidescat);
		}
		if (isset($_POST['bb_asidespos']) ) {
			$bb_asidesposition = $_POST['bb_asidespos'];
			update_option('bb_asidespos', $bb_asidesposition);
		}
		if (isset($_POST['bb_asidesnumber']) ) {
			$bb_asidesnumber = $_POST['bb_asidesnumber'];
			update_option('bb_asidesnumber', $bb_asidesnumber);
		}
		if (isset($_POST['archives']))
		{
			$add = $_POST['archives'];
			update_option('bb_archives', $add);
			create_archive();
		} else {
		// thanks to Michael Hampton, http://www.ioerror.us/ for the assist
			$remove = '';
			update_option('bb_archives', $remove);
			delete_archive();
		}
		if (isset($_POST['bb_postmeta_position']) ) {
			$bb_postmeta_position = $_POST['bb_postmeta_position'];
			update_option('bb_postmeta_position', $bb_postmeta_position);
		}
		if (isset($_POST['bb_authorblob']) ) {
			$bb_authorblob = $_POST['bb_authorblob'];
			update_option('bb_authorblob', $bb_authorblob);
		}
		if (isset($_POST['configela']))
		{
			if (!setup_archive()) unset($_POST['configela']);
		}
		if (isset($_POST['bb_sidebar_pages']))
		{
			$bb_sidebar_pages = $_POST['bb_sidebar_pages'];
			update_option('bb_sidebar_pages', $bb_sidebar_pages);
		}
	}
}

function bb_get_author_num()
{
	global $wpdb, $table_prefix;
	return $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->usermeta WHERE `meta_key` = '" . $table_prefix . "user_level' AND `meta_value` > 1");
}

function create_archive()
{
	global $wpdb, $user_ID;
	get_currentuserinfo();

	$check = $wpdb->query("SELECT * from $wpdb->posts WHERE post_title = 'Archives'");
	if (!$check)
	{
		$message = "Do not edit this page";
		$title_message = 'Archives';
		$content = apply_filters('content_save_pre', $message);
		$post_title = apply_filters('title_save_pre', $title_message);
		$now = current_time('mysql');
		$now_gmt = current_time('mysql', 1);
		$post_author = $user_ID;
		$id_result = $wpdb->get_row("SHOW TABLE STATUS LIKE '$wpdb->posts'");
		$post_ID = $id_result->Auto_increment;
		$post_name = sanitize_title($post_title, $post_ID);
		$ping_status = get_option('default_ping_status');
		$comment_status = get_option('default_comment_status');

		$postquery ="INSERT INTO $wpdb->posts
				(ID, post_author, post_date, post_date_gmt, post_content, post_title, post_excerpt,  post_status, comment_status, ping_status, post_password, post_name, to_ping, post_modified, post_modified_gmt, post_parent, menu_order)
				VALUES
				('$post_ID', '$post_author', '$now', '$now_gmt', '$content', '$post_title', '', 'static', '$comment_status', '$ping_status', '', '$post_name', '', '$now', '$now_gmt', '', '')";
		$result = $wpdb->query($postquery);
		$metaquery = "INSERT INTO $wpdb->postmeta(meta_id, post_id, meta_key, meta_value) VALUES('', '$post_ID', '_wp_page_template', 'page-archives.php')";
		$result2 = $wpdb->query($metaquery);
	}
}

function delete_archive()
{
	global $wpdb;
	$check = $wpdb->query("SELECT * from $wpdb->posts WHERE post_title = 'Archives'");
	if ($check)
	{
		$burninate = $wpdb->query("DELETE from $wpdb->posts WHERE post_title = 'Archives' and post_status = 'static'");
		$result = $wpdb->query($burninate);
	}
}

function setup_archive()
{
	global $wpdb;

	if (file_exists(ABSPATH . 'wp-content/plugins/UltimateTagWarrior/ultimate-tag-warrior-core.php') && in_array('UltimateTagWarrior/ultimate-tag-warrior.php', get_option('active_plugins'))) {
		$menu_order="chrono,tags,cats";
	} else {
		$menu_order="chrono,cats";
	}

	$initSettings = array(

	// we always set the character set from the blog settings
		'newest_first' => 0,
		'num_entries' => 1,
		'num_entries_tagged' => 0,
		'num_comments' => 1,
		'fade' => 1,
		'hide_pingbacks_and_trackbacks' => 1,
		'use_default_style' => 1,
		'paged_posts' => 1,
		'selected_text' => '',
		'selected_class' => 'selected',
		'comment_text' => '<span>%</span>',
		'number_text' => '<span>%</span>',
		'number_text_tagged' => '(%)',
		'closed_comment_text' => '<span>%</span>',
		'day_format' => 'jS',
		'error_class' => 'alert',
	// allow truncating of titles
		'truncate_title_length' => 0,
		'truncate_cat_length' => 25,
		'truncate_title_text' => '&#8230;',
		'truncate_title_at_space' => 1,
		'abbreviated_month' => 1,
		'tag_soup_cut' => 0,
		'tag_soup_X' => 0,
	// paged posts related stuff
		'paged_post_num' => 15,
		'paged_post_next' => 'next 15 posts &raquo;',
		'paged_post_prev' => '&laquo; previous 15 posts',
	// default text for the tab buttons
		'menu_order' => $menu_order,
		'menu_month' => 'Chronology',
		'menu_cat' => 'Taxonomy',
		'menu_tag' => 'Folksonomy',
		'before_child' => '&nbsp;&nbsp;&nbsp;',
		'after_child' => '',
		'loading_content' => '<img src="'.get_bloginfo('template_url').'/images/spinner.gif" class="elaload" alt="Spinner" />',
		'idle_content' => '',
		'excluded_categories' => '0');

	if (function_exists('af_ela_set_config'))
	{
		$ret = af_ela_set_config($initSettings);
	}
	return $ret;
}

// if we can't find bb_installed lets go ahead and install all the options that run Binary Blue.  This should run only one more time for all our existing users, then they will just be getting the upgrade function if it exists.
if (!get_option('bb_installed'))
{
	add_option('bb_installed', $current, 'Information whether Binary Blue already has been installed', $autoload);
	add_option('bb_blog_language', 'de', 'Define the primary blog language', $autoload);
	add_option('bb_livesearch', '0', "If you don't trust JavaScript and Ajax, you can turn off LiveSearch. Otherwise I suggest you leave it on", $autoload); // (live & classic)
	add_option('bb_archives', '', 'Set whether bb has a Live Archive page', $autoload);
	add_option('bb_scheme', 'True Blue', 'Choose the Scheme you want bb to use', $autoload);
	add_option('bb_commentsubscription', '1', 'Choose whether a comment must be entered to subscribe to comments', $autoload);
	add_option('bb_fullpingbacks', '0', 'Set whether to use verbose or short pingback display', $autoload);
	add_option('bb_nicetitle', '1', 'Set whether to use smart tooltips', $autoload);
	add_option('bb_ie7support', '1', 'Enhance MSIE CSS abilities with Dean Edwards IE7 script', $autoload);
	add_option('bb_utwtechnoratitags', '0', 'Define whether to show technorati tags for posts on startpage', $autoload);
	add_option('bb_utw_showposts', 'tags', 'Define whether to display related posrs or the taglist', $autoload);
	add_option('bb_livecomments', '0', "If you don't trust JavaScript and Ajax, you can turn off Live Commenting. Otherwise I suggest you leave it on", $autoload);
	add_option('bb_singlecommenting', '0', "Antispam countermeasure for livecomments functionality", $autoload);
	add_option('bb_asidescat', '0', 'A category which will be treated differently from other categories', $autoload);
	add_option('bb_asidespos', 'inline', 'Whether to use inline or sidebar asides', $autoload);
	add_option('bb_asidesnumber', '3', 'The number of Asides to show in the Sidebar. Default is 3.', $autoload);
	add_option('bb_enable_paged_comments', 'paged', 'Whether to enable AJAX paged comments or not', $autoload);
	add_option('bb_paged_comments_order', 'DESC', 'How to order the comments (ASC or DESC)', $autoload);
	add_option('bb_paged_comments_range', '5', 'How many pages +/- around the current one shall be directly selectable', $autoload);
	add_option('bb_paged_comments_amount', '10', 'How many comments per page should be displayed?', $autoload);
	add_option('bb_paged_comments_fancyurl', '0', 'Whether to use special urlrewrite rules for paged comments', $autoload);
	add_option('bb_enforce_author', '1', 'Whether to show the author info in any case or not', $autoload);
	add_option('bb_full_posts', 'full', 'Whether to show full posts or only excerpts of each post', $autoload);
	add_option('bb_postmeta_position', 'lower', 'Set up where to show the post meta information - above or beyond the post content', $autoload);
	add_option('bb_authorblob', '', 'If you feel funky, add  a small paragraph about you as the blog author to your sidebar', $autoload);
	add_option('bb_sidebar_pages', '1', 'Define whether pages should be displayed in the Sidebar', $autoload);
} elseif (get_option('bb_installed') < $current) {
	/* Do something! */
	update_option('bb_installed', $current);
	bb_set_defaults();
}

// =====================================================
// BEGIN THEME OPTIONS PAGE
// =====================================================

// checks whether there exists a newer version of the theme engine
function bb_check_version()
{
	global $current;
	require_once (ABSPATH . WPINC . '/rss-functions.php');
	$bb_version = (int) ereg_replace("[.]", "", $current);

	$rss = @fetch_rss('http://www.4null4.de/binaryblue.xml');
	if ($rss)
	{
		$rss->items = array_slice($rss->items, 0, 1);
		foreach ($rss->items as $item)
		{
			if ($item['description'] > $bb_version)
			{
				return $item['title'];
			} else {
				return false;
			}
		}
	} else {
		return false;
	}
}

// Let's add the options page.
add_action ('admin_menu', 'bb_menu');

function bb_menu() {
	bb_set_defaults();
	add_submenu_page('themes.php', __('Binary Blue Optionen', '4null4.de'), __('Binary Blue Optionen', '4null4.de'), 5, $bb_loc . 'functions.php', 'menu');
}

function menu() {
	load_plugin_textdomain('4null4.de');
	//this begins the admin page
?>
<?php if (WPLANG=='') : ?>
	<div class="error">
		<h1>YOU HAVEN'T CONFIGURED YOUR BLOG LANGUAGE IN wp-config.php YET! LOCALIZATION WON'T WORK WITHOUT SETTING YOUR LOCALE!</h1>
	</div>
<?php endif; ?>

<?php $latest = bb_check_version(); if ($latest > 0) : ?>
	<div class="updated">
		<p><?php printf(__('Es gibt bereits eine neue Version der Binary Blue Theme Engine. Die neueste Versionsnummer ist %s.', '4null4.de'), $latest); ?></p>
		<p><a href="www.4null4.de/wordpress-binary-blue-theme/"><?php _e('Hol sie dir, solange sie noch heiss ist.', '4null4.de'); ?></a></p>
	</div>
<?php endif; ?>

<?php if (isset($_POST['configela'])) : ?>
	<div class="updated">
		<p><?php _e('ELA Optionen f&uuml;r Binary Blue wurden gesetzt', '4null4.de'); ?></p>
	</div>
<?php endif; ?>

<?php if (isset($_POST['Submit'])) : ?>
	<div class="updated">
		<p><?php _e('Binary Blue Optionen wurden aktualisiert', '4null4.de'); ?></p>
	</div>
<?php endif; ?>

<div class="wrap">
<h2><?php _e('Binary Blue Optionen', '4null4.de'); ?></h2>
<p>Developed by Carsten Albrecht at 4null4.de. Check the <a href="http://www.4null4.de/wordpress-binary-blue-theme/" target="_blank">Binary Blue pages</a> for further information, additional schemes and widgets. This theme options page will tell you automatically if a newer version of the theme engine is available for public download.</p>
<p>If you happen to run into problems when using this theme, please check back at <a href="http://www.4null4.de/wordpress-binary-blue-theme/binary-blue-installation-update-and-faq/" target="_blank">the manual and FAQ page</a> on my site - there's some good chance that you'll find the solution for your problem there ;)</p>
</div>

<form name="dofollow" action="" method="post">
	<input type="hidden" name="action" value="<?php bb_update(); ?>" />
	<input type="hidden" name="page_options" value="'dofollow_timeout'" />


<div class="wrap">
	<h2><?php _e('Allgemeine Einstellungen', '4null4.de'); ?></h2>
	<table width="100%" cellspacing="2" cellpadding="5" class="editform">
		<colgroup>
			<col width="15%" />
			<col width="35%" />
			<col width="15%" />
			<col width="35%" />
		</colgroup>
		<tbody>
			<tr valign="top">
				<th scope="row"><label for="bb_scheme_file"><?php _e('Binary Blue Scheme', '4null4.de'); ?></label></th>
				<td>
					<?php
					global $wpdb;
					$name = get_option('bb_scheme');
					if ($name != '')
					{
						$scheme_title = $name;
					} else {
						$scheme_title = __('Kein Schema', '4null4.de');
					}
					?>
					<select name="bb_scheme_file" id="bb_scheme_file">
						<option value="<?php echo get_option('bb_scheme'); ?>"><?php echo$scheme_title; ?></option>
						<option value="-----">-----</option>
						<option value=""><?php _e("Kein Schema", "4null4.de"); ?></option>
						<?php
						$scheme_dir = @ dir(ABSPATH . '/wp-content/themes/' . get_template() . '/schemes');

						if ($scheme_dir) {
							while(($file = $scheme_dir->read()) !== false) {
									if (!preg_match('|^\.+$|', $file) && preg_match('|\.scheme\.css$|', $file))
									$scheme_files[] = preg_replace('|\.scheme\.css$|', '', $file);
								}
							}
							if ($scheme_dir || $scheme_files) {
								foreach($scheme_files as $scheme_file) {
								echo '<option value="' . $scheme_file . '">' . $scheme_file . '</option>';
							}
						}
						?>
					</select>
					<p><small><?php _e("W&auml;hle dein bevorzugtes Farbschema f&uuml;r dein Blog.", "4null4.de"); ?></small></p>
				</td>

				<th scope="row"><?php _e('Scheme Switcher', '4null4.de'); ?></th>
				<td>
					<input name="schemeswitcher" id="schemeswitcher1" type="radio" value="0" <?php checked('0', get_option('bb_schemeswitcher')); ?> />
					<label for="schemeswitcher1"><?php _e('Scheme Switcher aktiv (Default)', '4null4.de') ?></label><br />
					<input name="schemeswitcher" id="schemeswitcher2" type="radio" value="1" <?php checked('1', get_option('bb_schemeswitcher')); ?> />
					<label for="schemeswitcher2"><?php _e('Scheme Switcher inaktiv', '4null4.de') ?></label>
					<p><small><?php _e("Der Scheme Switcher erm&ouml;glicht deinen Besuchern, das Aussehen deines Blogs aus den installierten Schemes auszuw&auml;hlen und damit deine Vorgabe zu &uuml;berschreiben.", "4null4.de"); ?></small></p>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('/IE7/ Unterst&uuml;tzung', '4null4.de'); ?></th>
				<td>
					<input name="ie7support" id="ie7support1" type="radio" value="0" <?php checked('0', get_option('bb_ie7support')); ?> />
					<label for="ie7support1"><?php _e('/IE7/ aktiv', '4null4.de') ?></label><br />
					<input name="ie7support" id="ie7support2" type="radio" value="1" <?php checked('1', get_option('bb_ie7support')); ?> />
					<label for="ie7support2"><?php _e('/IE7/ inaktiv (Default)', '4null4.de') ?></label>
					<p><small><?php _e("/IE7/ ist eine Javascript-basierte L&ouml;sung von <a href=\"http://dean.edwards.name/IE7/\">Dean Edwards</a>, um MSIE6 einige Bugs auszutreiben.", "4null4.de"); ?> <a href="http://blog.bitflux.ch/wiki/LiveSearch"><?php _e("Willst du mehr dazu erfahren?", "4null4.de"); ?></a></small></p>
				</td>
				<th scope="row"><?php _e('SmartTooltip Support', '4null4.de'); ?></th>
				<td>
					<input name="nicetitle" id="nicetitle1" type="radio" value="0" <?php checked('0', get_option('bb_nicetitle')); ?> />
					<label for="nicetitle1"><?php _e('Smart Tooltips aktiv', '4null4.de') ?></label><br />
					<input name="nicetitle" id="nicetitle2" type="radio" value="1" <?php checked('1', get_option('bb_nicetitle')); ?> />
					<label for="nicetitle2"><?php _e('Smart Tooltips inaktiv (Default)', '4null4.de') ?></label>
					<p><small><?php _e("Smart Tooltips ersetzen die Tooltip-Funktion der Browser durch eine optisch angepasste Darstellung.", "4null4.de"); ?></small></p>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Livesearch', '4null4.de'); ?></th>
				<td>
					<input name="livesearch" id="livesearch1" type="radio" value="0" <?php checked('0', get_option('bb_livesearch')); ?> />
					<label for="livesearch1"><?php _e('Livesearch aktiv (Default)', '4null4.de') ?></label><br />
					<input name="livesearch" id="livesearch2" type="radio" value="1" <?php checked('1', get_option('bb_livesearch')); ?> />
					<label for="livesearch2"><?php _e('Livesearch inaktiv', '4null4.de') ?></label>
					<p><small><?php _e("Livesearch ist eine Javascript-basierte Suche-w&auml;hrend-du-tippst-L&ouml;sung. Ist Javascript im Browser des Besuchers deaktiviert, funktioniert die Suche ganz normal (mit Laden der Suchergebnis-Seite).", "4null4.de"); ?> <a href="http://blog.bitflux.ch/wiki/LiveSearch"><?php _e("Willst du mehr dazu erfahren?", "4null4.de"); ?></a></small></p>
				</td>
				<th scope="row"><?php _e('Blogsprache', '4null4.de'); ?></th>
				<td>
					<input name="blog_language" id="blog_language" type="text" value="<?php echo get_option('bb_blog_language'); ?>" size="2" />
					<p><small><?php _e('Definiere hier die prim&auml;re Sprache deines Blogs in Form der g&auml;ngigen L&auml;nderk&uuml;rzel, z.B. "de" f&uuml;r "deutsch" oder "en" f&uuml;r "englisch".', '4null4.de'); ?></small></p>
				</td>
			</tr>

			<tr valign="top">
				<th scope="row"><?php _e('Artikelsicht', '4null4.de'); ?></th>
				<td>
					<input name="full_posts" id="full_posts1" type="radio" value="full" <?php checked('full', get_option('bb_full_posts')); ?> />
					<label for="full_posts1"><?php _e('Vollansicht aktiv (Default)', '4null4.de') ?></label><br />
					<input name="full_posts" id="full_posts2" type="radio" value="excerpt" <?php checked('excerpt', get_option('bb_full_posts')); ?> />
					<label for="full_posts2"><?php _e('Textauszug aktiv', '4null4.de') ?></label>
					<p><small><?php _e('Diese Option bestimmt, ob auf der Startseite jeweils der volle Artikeltext oder lediglich Artikelausz&uuml;ge dargestellt werden sollen.', '4null4.de'); ?></small></p>
				</td>
				<th scope="row"><?php _e('Postmeta-Position', '4null4.de'); ?></th>
				<td>
					<input name="bb_postmeta_position" id="bb_postmeta_position1" type="radio" value="upper" <?php checked('upper', get_option('bb_postmeta_position')); ?> />
					<label for="bb_postmeta_position1"><?php _e('&Uuml;ber dem Artikelinhalt', '4null4.de') ?></label><br />
					<input name="bb_postmeta_position" id="bb_postmeta_position2" type="radio" value="lower" <?php checked('lower', get_option('bb_postmeta_position')); ?> />
					<label for="bb_postmeta_position2"><?php _e('Unter dem Artikelinhalt (Default)', '4null4.de') ?></label>
					<p><small><?php _e('Diese Option bestimmt, ob die Metainformationen eines Artikels jeweils direkt unter der &Uuml;berschrift oder unter dem Artikelinhalt ausgegeben werden sollen.', '4null4.de'); ?></small></p>
				</td>
			</tr>

			<tr valign="top">
				<th scope="row"><?php _e('Page-Position', '4null4.de'); ?></th>
				<td>
					<input name="bb_sidebar_pages" id="bb_sidebar_pages1" type="radio" value="0" <?php checked('0', get_option('bb_sidebar_pages')); ?> />
					<label for="bb_sidebar_pages1"><?php _e('Als Sidebar-Block', '4null4.de') ?></label><br />
					<input name="bb_sidebar_pages" id="bb_sidebar_pages2" type="radio" value="1" <?php checked('1', get_option('bb_sidebar_pages')); ?> />
					<label for="bb_sidebar_pages2"><?php _e('Als Topmen&uuml; (Default)', '4null4.de') ?></label>
					<p><small><?php _e('Diese Option bestimmt, ob statische Seiten (Pages) als oberes Topmen&uuml; oder als eigener Block in der Sidebar angezeigt werden sollen.', '4null4.de'); ?></small></p>
				</td>
				<td colspan="2">&nbsp;</td>
			</tr>

			<?php if (function_exists('UTW_ShowTagsForCurrentPost')) { ?>
			<tr valign="top">
				<th scope="row"><?php _e('Technoratitags f&uuml;r Posts anzeigen', '4null4.de'); ?></th>
				<td>
					<input name="utwtechnoratitags" id="classic" type="radio" value="0" <?php checked('0', get_option('bb_utwtechnoratitags')); ?> />
					<label for="utwtechnoratitags1"><?php _e("Technoratitags aktiv (Default)", "4null4.de") ?></label><br />
					<input name="utwtechnoratitags" id="live" type="radio" value="1" <?php checked('1', get_option('bb_utwtechnoratitags')); ?> />
					<label for="utwtechnoratitags2"><?php _e("Technoratitags inaktiv", "4null4.de") ?></label>
					<p><small><?php _e("Definiere, ob in der Artikel&uuml;bersicht Technoratitags unter den Artikeln angezeigt werden sollen (performancelastig).", "4null4.de"); ?></small></p>
				</td>
				<th scope="row"><?php _e('Tags/Posts anzeigen', '4null4.de'); ?></th>
				<td>
					<input name="utw_showposts" id="utw_showposts1" type="radio" value="tags" <?php checked('tags', get_option('bb_utw_showposts')); ?> />
					<label for="utw_showposts1"><?php _e("Zeige Tags (Default)", "4null4.de") ?></label><br />
					<input name="utw_showposts" id="utw_showposts2" type="radio" value="posts" <?php checked('posts', get_option('bb_utw_showposts')); ?> />
					<label for="utw_showposts2"><?php _e("Zeige verwandte Posts", "4null4.de") ?></label>
					<p><small><?php _e("Definiere, ob in der Anzeige eines einzelnen Artikels eine &Uml;bersicht verwandter Artikel oder aber die Tagliste angezeigt werden soll.", "4null4.de"); ?></small></p>
				</td>
			</tr>
			<?php } ?>
		</tbody>
	</table>
</div>

<div class="wrap">
	<h2><?php _e('Kommentareinstellungen', '4null4.de'); ?></h2>
	<table width="100%" cellspacing="2" cellpadding="5" class="editform">
		<colgroup>
			<col width="15%" />
			<col width="35%" />
			<col width="15%" />
			<col width="35%" />
		</colgroup>
		<tbody>
			<tr valign="top">
				<th scope="row"><?php _e('Live Comments', '4null4.de'); ?></th>
				<td>
					<input name="livecommenting" id="livecommenting1" type="radio" value="0" <?php checked('0', get_option('bb_livecomments')); ?> />
					<label for="livecommenting1"><?php _e('Live Comments aktiv (Default)', '4null4.de') ?></label><br />
					<input name="livecommenting" id="livecommenting2" type="radio" value="1" <?php checked('1', get_option('bb_livecomments')); ?> />
					<label for="livecommenting2"><?php _e('Live Comments inaktiv', '4null4.de') ?></label>
					<p><small><?php _e('Livecomments erm&ouml;glichen die direkte Anzeige eines abgesendeten Kommentars ohne Neuladen der Seite. Hierzu wird auf Javascript-Funktionen zur&uuml;ckgegriffen. Ist Javascript im Browser des Besuchers deaktiviert, funktioniert die Kommentarfunktion ganz normal (mit Neuladen der Seite).', '4null4.de'); ?></small></p>
				</td>
				<th scope="row"><?php _e('Single Comments', '4null4.de'); ?></th>
				<td>
					<input name="singlecommenting" id="singlecommenting1" type="radio" value="0" <?php checked('0', get_option('bb_singlecommenting')); ?> />
					<label for="singlecommenting1"><?php _e('Ein Kommentar pro Request (Default)', '4null4.de') ?></label><br />
					<input name="singlecommenting" id="singlecommenting2" type="radio" value="1" <?php checked('1', get_option('bb_singlecommenting')); ?> />
					<label for="singlecommenting2"><?php _e('Beliebig viele Kommentare', '4null4.de') ?></label>
					<p><small><?php _e('Per Default blendet sich das Kommentarformular nach einem erfolgreichen Post aus, wenn Live Comments eingeschaltet sind (Spamschutz).', '4null4.de'); ?></small></p>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('AJAX Paged Comments', '4null4.de'); ?></th>
				<td>
					<input name="bb_enable_paged_comments" id="bb_enable_paged_comments1" type="radio" value="paged" <?php checked('paged', get_option('bb_enable_paged_comments')); ?> />
					<label for="bb_enable_paged_comments1"><?php _e('AJAX Paged Comments aktiv (Default)', '4null4.de') ?></label><br />
					<input name="bb_enable_paged_comments" id="bb_enable_paged_comments2" type="radio" value="simple" <?php checked('simple', get_option('bb_enable_paged_comments')); ?> />
					<label for="bb_enable_paged_comments2"><?php _e('AJAX Paged Comments inaktiv', '4null4.de') ?></label>
					<p><small><?php _e('Bei Aktivierung dieser Funktion werden Kommentare zu einem Post seitenweise ausgegeben. Mittels Javascript k&ouml;nnen die Kommenzarseiten ohne Neuladen der Seite durchb&auml;ttert werden. Bei deaktiviertem Javascript funktioniert das Bl&auml;ttern wie mit einem Paged-Comments-Plugin.', '4null4.de'); ?></small></p>
				</td>
				<th scope="row"><?php _e('Paged Comments Reihenfolge', '4null4.de'); ?></th>
				<td>
					<input name="bb_paged_comments_order" id="bb_paged_comments_order1" type="radio" value="DESC" <?php checked('DESC', get_option('bb_paged_comments_order')); ?> />
					<label for="bb_paged_comments_order1"><?php _e('Absteigend - neueste zuerst (Default)', '4null4.de') ?></label><br />
					<input name="bb_paged_comments_order" id="bb_paged_comments_order2" type="radio" value="ASC" <?php checked('ASC', get_option('bb_paged_comments_order')); ?> />
					<label for="bb_paged_comments_order2"><?php _e('Aufsteigend - &auml;lteste zuerst', '4null4.de') ?></label>
					<p><small><?php _e('Mit dieser Einstellung wird beeinflusst, ob die Kommentare in normaler oder in umgekehrter chronologischer Reihenfolge angezeigt werden sollen.', '4null4.de'); ?></small></p>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Anzahl Kommentare pro Seite', '4null4.de'); ?></th>
				<td>
					<input name="bb_paged_comments_amount" id="bb_paged_comments_amount" type="text" value="<?php echo get_option('bb_paged_comments_amount'); ?>" size="2" />
					<p><small><?php _e('Setzt die Anzahl Kommentare, die je Kommentarseite angezeigt werden. Defaultwert ist zehn.', '4null4.de'); ?></small></p>
				</td>
				<th scope="row"><?php _e('Anzahl sichtbare Seiten', '4null4.de'); ?></th>
				<td>
					<input name="bb_paged_comments_range" id="bb_paged_comments_range" type="text" value="<?php echo get_option('bb_paged_comments_range'); ?>" size="2" />
					<p><small><?php _e('Setzt die Anzahl an Seitenzahlen, die direkt anw&auml;hlbar sind. Defaultwert ist f&uuml;nf.', '4null4.de'); ?></small></p>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Paged Comments Fancy URLs', '4null4.de'); ?></th>
				<td>
					<input name="bb_paged_comments_fancyurl" id="bb_paged_comments_fancyurl1" type="radio" value="0" <?php checked('0', get_option('bb_paged_comments_fancyurl')); ?> />
					<label for="bb_paged_comments_fancyurl1"><?php _e('Fancy URLs eingeschaltet (Default)', '4null4.de') ?></label><br />
					<input name="bb_paged_comments_fancyurl" id="bb_paged_comments_fancyurl2" type="radio" value="1" <?php checked('1', get_option('bb_paged_comments_fancyurl')); ?> />
					<label for="bb_paged_comments_fancyurl2"><?php _e('Fancy URLs ausgeschaltet', '4null4.de') ?></label>
					<p><small><?php _e('Ist diese Einstellung aktiviert, wird die Permalink-Struktur um einen Zusatz f&uuml;r seitenweise Kommentardarstellung erg&auml;nzt.', '4null4.de'); ?></small></p>
				</td>
				<th scope="row"><?php _e('Pingback-Anzeige', '4null4.de'); ?></th>
				<td>
					<input name="fullpingbacks" id="fullpingbacks1" type="radio" value="0" <?php checked('0', get_option('bb_fullpingbacks')); ?> />
					<label for="fullpingbacks1"><?php _e('Ausf&uuml;hrliche Darstellung (Default)', '4null4.de') ?></label><br />
					<input name="fullpingbacks" id="fullpingbacks2" type="radio" value="1" <?php checked('1', get_option('bb_fullpingbacks')); ?> />
					<label for="fullpingbacks2"><?php _e('Kurze Darstellung', '4null4.de') ?></label>
					<p><small><?php _e("Die ausf&uuml;hrliche Darstellung zeigt Pingbacks und Trackbacks wie Kommentare an, die verk&uuml;rzte Darstellung zeigt sie als Liste von Links.", "4null4.de"); ?></small></p>
				</td>
			</tr>
			<?php if (function_exists('show_manual_subscription_form')) { ?>
			<tr valign="top">
				<th scope="row"><?php _e('Kommentar-Abo ohne Kommentar zulassen', '4null4.de'); ?></th>
				<td>
					<input name="commentsubscription" id="commentsubscription1" type="radio" value="0" <?php checked('0', get_option('bb_commentsubscription')); ?> />
					<label for="commentsubscription1"><?php _e("Abo zulassen", "4null4.de") ?></label><br />
					<input name="commentsubscription" id="commentsubscription2" type="radio" value="1" <?php checked('1', get_option('bb_commentsubscription')); ?> />
					<label for="commentsubscription2"><?php _e("Abo nicht zulassen (Default)", "4null4.de") ?></label>
					<p><small><?php _e("Definiere, ob Leser eines Artikels die Kommentare per Email abonnieren d&uuml;rfen, ohne selbst zu kommentieren.", "4null4.de"); ?> <?php _e('Voraussetzung: <a href="http://txfx.net/code/wordpress/subscribe-to-comments/" target="_blank">Subscribe-to-Comments-Plugin</a>', '4null4.de'); ?>
					</small></p>
				</td>
				<td colspan="2">&nbsp;</td>
			</tr>
			<?php } ?>
		</tbody>
	</table>
</div>

<div class="wrap">
	<h2><?php _e('Asides-Einstellungen', '4null4.de'); ?></h2>
	<table width="100%" cellspacing="2" cellpadding="5" class="editform">
		<colgroup>
			<col width="15%" />
			<col width="35%" />
			<col width="15%" />
			<col width="35%" />
		</colgroup>
		<tbody>
			<tr valign="top">
				<th scope="row"><label for="bb_asidescat"><?php _e('Asides Kategorie', '4null4.de'); ?></label></th>
				<td>
					<?php
					global $wpdb;
					$id = get_option('bb_asidescat');
					if ($id != 0) {
						$asides_title = $wpdb->get_var('SELECT cat_name from '.$wpdb->categories.' WHERE cat_ID = '.$id);
					} else {
						$asides_title=__('Ohne Asides','4null4.de');
					}
					?>
					<select name="bb_asidescat" id="bb_asidescat" style="width: auto;">
					<option value="<?php echo get_option('bb_asidescat'); ?>"><?php echo $asides_title; ?></option>
					<option value="-----">----</option>
					<option value="0"><?php _e('Ohne Asides', '4null4.de'); ?></option>
					<?php
					$asides_cats = $wpdb->get_results('SELECT cat_ID, cat_name from '.$wpdb->categories);
					foreach ($asides_cats as $cat) {
						echo '<option value="' . $cat->cat_ID . '">' . $cat->cat_name . '</option>';
					}
					?>
					</select>
					<p><small><?php _e('W&auml;hle eine Kategorie, die unter Verwendung von <a href="http://photomatt.net/2004/05/19/asides/">Matt\'s Asides Technique</a> als Aside eingesetzt werden soll', '4null4.de'); ?></small></p>
				</td>
				<th scope="row"><?php _e('Asides'); ?></th>
				<td>
					<input name="bb_asidespos" id="bb_asidespos1" type="radio" value="inline" <?php checked('inline', get_option('bb_asidespos')); ?> />
					<label for="bb_asidespos1"><?php _e('Inline Asides') ?></label><br />
					<input name="bb_asidespos" id="bb_asidespos2" type="radio" value="sidebar" <?php checked('sidebar', get_option('bb_asidespos')); ?> />
					<label for="bb_asidespos2"><?php _e('Sidebar Asides') ?></label>
					<p><small><?php _e('W&auml;hle, ob deine Asides (sofern aktiv) inline oder in der Sidebar angezeigt werden sollen.', '4null4.de'); ?></small></p>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Anzahl Asides', '4null4.de'); ?></th>
				<td>
					<input name="bb_asidesnumber" id="bb_asidesnumber" type="text" value="<?php echo get_option('bb_asidesnumber'); ?>" size="2" />
					<p><small><?php _e('Setzt die Anzahl Asides, die in der Sidebar angezeigt werden. Defaultwert ist drei.', '4null4.de'); ?></small></p>
				</td>
				<td colspan="2">&nbsp;</td>
			</tr>
		</tbody>
	</table>
</div>

<div class="wrap">
	<h2><?php _e('Archiveinstellungen', '4null4.de'); ?></h2>
	<table width="100%" cellspacing="2" cellpadding="5" class="editform">
		<colgroup>
			<col width="15%" />
			<col width="35%" />
			<col width="15%" />
			<col width="35%" />
		</colgroup>
		<tbody>
			<tr valign="top">
				<th scope="row"><?php _e('Archiv-Seite', '4null4.de'); ?></th>
				<td>
					<input name="archives" id="add_archive" type="checkbox" value="add_archive" <?php checked('add_archive', get_option('bb_archives')); ?> />
					<label for="add_archive"><?php _e('Binary Blue Archiv-Seite aktivieren', '4null4.de') ?></label>
					<p><small><?php _e("Durch Aktivierung dieser Checkbox wird eine spezielle Archivseite eingerichtet, mit deren Hilfe dein Blog sehr komfortabel durchsucht werden kann.", "4null4.de"); ?></small></p>
				</td>
			<?php if (function_exists('af_ela_set_config')) { ?>
				<th scope="row"><?php _e('Extended Live Archive konfigurieren', '4null4.de'); ?></th>
				<td>
					<p><input name="configela" id="configela" type="submit" value="<?php _e('ELA f&uuml;r Binary Blue Archiv-Seite konfigurieren', '4null4.de') ?>" /></p><br />
					<p><small><?php _e("Konfiguriere Arnaud's gro&szlig;artiges <a href=\"http://www.sonsofskadi.net/index.php/extended-live-archive/\" title=\"Information about ELA\">Extended Live Archives</a> f&uuml;r Binary Blue.", "4null4.de"); ?></small></p>
				</td>
			<?php } else { ?>
				<td colspan="2">&nbsp;</td>
			<?php }?>
			</tr>
		</tbody>
	</table>
</div>

<div class="wrap">
	<h2><?php _e('Autoreneinstellungen', '4null4.de'); ?></h2>
	<table width="100%" cellspacing="2" cellpadding="5" class="editform">
		<colgroup>
			<col width="15%" />
			<col width="35%" />
			<col width="15%" />
			<col width="35%" />
		</colgroup>
		<tbody>
			<tr valign="top">
				<th scope="row"><label for="bb_authorblob"><?php _e('Autoreninfo', '4null4.de'); ?></label></th>
				<td>
					<textarea name="bb_authorblob" style="width: 98%;" rows="5" id="bb_authorblob"><?php echo stripslashes(get_option('bb_authorblob')); ?></textarea>
					<p><small><?php _e("Hier kannst du einen kurzen Infotext &uuml;ber dich als Autor des Blogs eingeben. Dieser Text wird dann in der Sidebar deines Blogs in der Authorinfo-Box angezeigt. Der von dir eingegebene Text darf auch HTML-Code enthalten.", "4null4.de"); ?></small></p>
				</td>
				<th scope="row"><?php _e('Autorenanzeige', '4null4.de'); ?></th>
				<td>
					<input name="enforce_author" id="enforce_author1" type="radio" value="0" <?php checked('0', get_option('bb_enforce_author')); ?> />
					<label for="enforce_author1"><?php _e('Autorenanzeige aktiv', '4null4.de') ?></label><br />
					<input name="enforce_author" id="enforce_author2" type="radio" value="1" <?php checked('1', get_option('bb_enforce_author')); ?> />
					<label for="enforce_author2"><?php _e('Autorenanzeige inaktiv (Default)', '4null4.de') ?></label>
					<p><small><?php _e('Diese Option bestimmt, ob der Autorenname auch dann angezeigt werden soll, wenn es nur einen einzigen Autor im Blog gibt.', '4null4.de'); ?></small></p>
				</td>
			</tr>
		</tbody>
	</table>
</div>

<div class="wrap">
	<p class="submit"><input type="submit" name="Submit" value="<?php _e('Einstellungen speichern', '4null4.de') ?> &raquo;" /></p>
</div>
</form>

<?php } // this ends the admin page
// =====================================================
// END OF THEME CONFIGURATION
// =====================================================
// BEGIN SIDEBAR ASIDES MAINPAGE DISPLAY FILTER SETTINGS
// =====================================================
// if Asides are configured to be shown in the sidebar, they must not be counted in the loop
// so we add the following filter - the solution based on the following two functions makes
// use of two rarely used filter hooks - posts_join and posts_where

function bb_asidesfilter_join($join)
{
	global $wpdb;
	// If the page is not a category page, then we need the JOIN.
	if (!is_category() && !is_admin() && !is_single()){
		return " LEFT JOIN {$wpdb->post2cat} ON {$wpdb->posts}.ID = {$wpdb->post2cat}.post_id " . $join;
	}
	else {
		return $join;
	}
}

function bb_asidesfilter_where($where)
{
	global $wpdb;
	$bb_asides_cat = get_option('bb_asidescat');
	$sidebar_asides = get_option('bb_asidespos');

	if (('0' != $bb_asides_cat) && ('sidebar' == $sidebar_asides) && !is_admin() && !is_category() && !is_single())
	{
		$where = $where." AND (".$wpdb->post2cat.".category_id NOT IN (".$bb_asides_cat.'))';
	}
	return $where;
}

// apply the sidebar asides filters only if appropriate
if (get_option('bb_asidescat') != '0' && get_option('bb_asidespos') == 'sidebar' && (!is_single() && in_category(get_option('bb_asidescat'))))
{
	add_filter('posts_join', 'bb_asidesfilter_join');
	add_filter('posts_where', 'bb_asidesfilter_where');
}

// =====================================================
// END SIDEBAR ASIDES MAINPAGE DISPLAY FILTER SETTINGS
// =====================================================
?>
