<?php

// Admin stuff for Similar Posts Plugin, Version 2.3.6

function similar_posts_option_menu() {
	if (function_exists('current_user_can')) {
		if (!current_user_can('manage_options')) return;
	} else {
		global $user_level;
		get_currentuserinfo();
		if ($user_level < 8) return;
	}
	if (function_exists('add_options_page')) {
		add_options_page(__('Similar Posts Options'), __('Similar Posts'), 1, __FILE__, 'similar_posts_options_page');
	}
}

add_action('admin_menu', 'similar_posts_option_menu');

function similar_posts_manage_menu($nothing) {
	if (function_exists('current_user_can')) {
		if (!current_user_can('manage_options')) return;
	} else {
		global $user_level;
		get_currentuserinfo();
		if ($user_level < 8) return;
	}
	if (function_exists('add_management_page')) {
		add_management_page(__('Similar Posts'), __('Similar Posts'), 1, __FILE__, 'similar_posts_manage_page');	
	}
}

add_action('admin_menu', 'similar_posts_manage_menu');

function similar_posts_options_page(){
	global $wpdb, $wp_version;
	// This bit stores any updated values when the Update button has been pressed
	if (isset($_POST['update_options'])) {
		if (defined('POC_CACHE')) {
			// the cache needs to be cleared since we've changed the options
			$cache = POC_Cache::clear_all();
		}
		// Fill up the options array as necessary
		$options['limit'] = $_POST['limit'];
		if ('' === trim($options['limit'])) $options['limit'] = '0';
		$options['skip'] = $_POST['skip'];
		if ('' === trim($options['skip'])) $options['skip'] = '0';
		$options['trim_before'] = $_POST['trim_before'];
		$options['omit_current_post'] = $_POST['omit_current_post'];
		$options['show_private'] = $_POST['show_private'];
		$options['show_pages'] = $_POST['show_pages'];
		$options['none_text'] = $_POST['none_text'];
		$options['tag_str'] = trim($_POST['tag_str']);
		// the posted variable is an array but we want to store it as a comma separated list of values ... '9999' === no categories
		if ($_POST['excluded_cats']) {
			if (function_exists('get_term_children')) {
				$catarray = $_POST['excluded_cats'];
				foreach ( $catarray as $cat ) {
					$catarray = array_merge($catarray, get_term_children($cat, 'category'));
				}
				$_POST['excluded_cats'] = array_unique($catarray);
			}
			$options['excluded_cats'] = rtrim(implode(',', $_POST['excluded_cats']), ',');
		} else {
			$options['excluded_cats'] = '9999';
		}
		// the posted variable is an array but we want to store it as a comma separated list of values ... '9999' === no categories
		if ($_POST['included_cats']) {
			if (function_exists('get_term_children')) {
				$catarray = $_POST['included_cats'];
				foreach ( $catarray as $cat ) {
					$catarray = array_merge($catarray, get_term_children($cat, 'category'));
				}
				$_POST['included_cats'] = array_unique($catarray);
			}
			$options['included_cats'] = rtrim(implode(',', $_POST['included_cats']), ',');
		} else {
			$options['included_cats'] = '9999';
		}
		// the posted variable is an array but we want to store it as a comma separated list of values ... '9999' === no authors
		if ($_POST['excluded_authors']) {
			$options['excluded_authors'] = rtrim(implode(',', $_POST['excluded_authors']), ',');
		} else {
			$options['excluded_authors'] = '9999';
		}
		if ($_POST['included_authors']) {
			$options['included_authors'] = rtrim(implode(',', $_POST['included_authors']), ',');
		} else {
			$options['included_authors'] = '9999';
		}
		$options['excluded_posts'] = rtrim($_POST['excluded_posts']);
		// this is a complicated option to store ... two matched arrays of tags
		$st = explode("\n", trim($_POST['starttags']));
		$se = explode("\n", trim($_POST['endtags']));
		if (count($st) != count($se)) {
			$options['stripcodes'] = array(array());
		} else {
			$num = count($st);
			for ($i = 0; $i < $num; $i++) {
				$options['stripcodes'][$i]['start'] = $st[$i];
				$options['stripcodes'][$i]['end'] = $se[$i];
			}
		}

		$options['prefix'] = $_POST['prefix'];
		$options['suffix'] = $_POST['suffix'];
		$options['output_template'] = $_POST['output_template'];
		
		//options just for Similar Posts
		$options['match_cat'] = $_POST['match_cat'];
		$options['match_tags'] = $_POST['match_tags'];
		$options['bias_title'] = $_POST['bias_title'];
		$options['utf8'] = $_POST['utf8'];
		$options['num_terms'] = $_POST['num_terms'];
		if ($options['num_terms'] < 1) $options['num_terms'] = 20;

		// store the option values under the plugin filename
		update_option('similar-posts', $options);
		
		// Show a message to say we've done something
		echo '<div class="updated"><p>' . __('Options saved') . '</p></div>';
	} else {
		// If we are just displaying the page we first load up the options array
		$options = get_option('similar-posts');
	}
	//now we drop into html to display the option page form
	?>
		<div class="wrap">
		<h2><?php _e('Similar Posts Options'); ?></h2>
		<h3><a href="http://rmarsh.com/plugins/post-options/">Help and Instructions</a></h3>
		<form method="post" action="">
		<fieldset class="options">
		<table class="optiontable">
			<tr valign="top">
				<th scope="row"><?php _e('Number of posts to show:') ?></th>
				<td><input name="limit" type="text" id="limit" value="<?php echo $options['limit']; ?>" size="2" /></td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Number of posts to skip:') ?></th>
				<td><input name="skip" type="text" id="skip" value="<?php echo $options['skip']; ?>" size="2" /></td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Omit the current post?') ?></th>
				<td>
				<select name="omit_current_post" id="omit_current_post">
				<option <?php if($options['omit_current_post'] == 'false') { echo 'selected="selected"'; } ?> value="false">No</option>
				<option <?php if($options['omit_current_post'] == 'true') { echo 'selected="selected"'; } ?> value="true">Yes</option>
				</select> 
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Show password-protected posts?') ?></th>
				<td>
				<select name="show_private" id="show_private">
				<option <?php if($options['show_private'] == 'false') { echo 'selected="selected"'; } ?> value="false">No</option>
				<option <?php if($options['show_private'] == 'true') { echo 'selected="selected"'; } ?> value="true">Yes</option>
				</select> 
				</td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Show static pages?') ?></th>
				<td>
					<select name="show_pages" id="show_pages">
					<option <?php if($options['show_pages'] == 'false') { echo 'selected="selected"'; } ?> value="false">No</option>
					<option <?php if($options['show_pages'] == 'true') { echo 'selected="selected"'; } ?> value="true">Yes</option>
					</select>
				</td> 
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Match the current post\'s category?') ?></th>
				<td>
					<select name="match_cat" id="match_cat">
					<option <?php if($options['match_cat'] == 'false') { echo 'selected="selected"'; } ?> value="false">No</option>
					<option <?php if($options['match_cat'] == 'true') { echo 'selected="selected"'; } ?> value="true">Yes</option>
					</select>
				</td> 
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Match the current post\'s tags?') ?></th>
				<td>
					<select name="match_tags" id="match_tags" <?php if ($wp_version < 2.3) echo 'disabled="true"'; ?> >
					<option <?php if($options['match_tags'] == 'false') { echo 'selected="selected"'; } ?> value="false">No</option>
					<option <?php if($options['match_tags'] == 'any') { echo 'selected="selected"'; } ?> value="any">Any tag</option>
					<option <?php if($options['match_tags'] == 'all') { echo 'selected="selected"'; } ?> value="all">Every tag</option>
					</select>
				</td> 
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Maximum number of words to use for match:') ?></th>
				<td><input name="num_terms" type="text" id="num_terms" value="<?php echo $options['num_terms']; ?>" size="3" /></td>
			</tr>
			<tr valign="top">
				<th scope="row" title=""><?php _e('Relative weight of post title vs. content:') ?></th>
				<td>
					<select name="bias_title" id="bias_title">
					<option <?php if($options['bias_title'] == 'high') { echo 'selected="selected"'; } ?> value="high">High</option>
					<option <?php if($options['bias_title'] == 'equal') { echo 'selected="selected"'; } ?> value="equal">Equal</option>
					<option <?php if($options['bias_title'] == 'low') { echo 'selected="selected"'; } ?> value="low">Low</option>
					</select>
				</td> 
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Handle extended characters?') ?></th>
				<td>
					<select name="utf8" id="utf8">
					<option <?php if($options['utf8'] == 'false') { echo 'selected="selected"'; } ?> value="false">No (faster)</option>
					<option <?php if($options['utf8'] == 'true') { echo 'selected="selected"'; } ?> value="true">Yes (slower)</option>
					</select>
				</td> 
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Default display if no matches:') ?></th>
				<td><input name="none_text" type="text" id="none_text" value="<?php echo htmlspecialchars(stripslashes($options['none_text'])); ?>" size="40" /></td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Text and codes before the list:') ?></th>
				<td><input name="prefix" type="text" id="prefix" value="<?php echo htmlspecialchars(stripslashes($options['prefix'])); ?>" size="40" /></td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Text and codes after the list:') ?></th>
				<td><input name="suffix" type="text" id="suffix" value="<?php echo htmlspecialchars(stripslashes($options['suffix'])); ?>" size="40" /></td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Output template:') ?></th>
				<td><textarea name="output_template" id="output_template" rows="4" cols="60"><?php echo htmlspecialchars(stripslashes($options['output_template'])); ?></textarea></td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Text to trim at start:') ?></th>
				<td><input name="trim_before" type="text" id="trim_before" value="<?php echo $options['trim_before']; ?>" size="10" /></td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Match posts with tags:<br />(a,b matches posts with either tag, a+b only matches posts with both tags)') ?></th>
				<td><input name="tag_str" type="text" id="tag_str" value="<?php echo $options['tag_str']; ?>" <?php if ($wp_version < 2.3) echo 'disabled="true"'; ?> size="40" /></td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Posts to exclude:') ?></th>
				<td><input name="excluded_posts" type="text" id="excluded_posts" value="<?php echo $options['excluded_posts']; ?>" size="20" /> <?php _e('comma-separated IDs'); ?></td>
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Authors to exclude/include:') ?></th>
				<td>
					<table border="1">	
					<?php 
						$users = $wpdb->get_results("SELECT ID, user_login FROM $wpdb->users ORDER BY user_login");
						if ($users) {
							$excluded = explode(',', $options['excluded_authors']);
							$included = explode(',', $options['included_authors']);
							echo "\n\t<tr valign=\"top\"><td><strong>Author</strong></td><td>Exclude</td><td>Include</td></tr>";
							foreach ($users as $user) {
								if (false === in_array($user->ID, $excluded)) {
									$ex_ischecked = '';
								} else {
									$ex_ischecked = 'checked';
								}
								if (false === in_array($user->ID, $included)) {
									$in_ischecked = '';
								} else {
									$in_ischecked = 'checked';
								}
								echo "\n\t<tr valign=\"top\"><td>$user->user_login</td><td><input type=\"checkbox\" name=\"excluded_authors[]\" value=\"$user->ID\" $ex_ischecked /></td><td><input type=\"checkbox\" name=\"included_authors[]\" value=\"$user->ID\" $in_ischecked /></td></tr>";
							}
						}	
					?>
					</table>
				</td> 
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Categories to exclude/include:') ?></th>
				<td>
					<table border="1">	
					<?php 
						if (function_exists("get_categories")) {
							$categories = get_categories('&hide_empty=0');
						} else {
							$categories = $wpdb->get_results("SELECT * FROM $wpdb->categories ORDER BY cat_name");
						}
						if ($categories) {
							echo "\n\t<tr valign=\"top\"><td><strong>Category</strong></td><td>Exclude</td><td>Include</td></tr>";
							$excluded = explode(',', $options['excluded_cats']);
							$included = explode(',', $options['included_cats']);
							$level = 0;
							$cats_added = array();
							$last_parent = 0;
							$cat_parent = 0;
							foreach ($categories as $category) {
								$category->cat_name = wp_specialchars($category->cat_name);
								if (false === in_array($category->cat_ID, $excluded)) {
									$ex_ischecked = '';
								} else {
									$ex_ischecked = 'checked';
								}
								if (false === in_array($category->cat_ID, $included)) {
									$in_ischecked = '';
								} else {
									$in_ischecked = 'checked';
								}
								$last_parent = $cat_parent;
								$cat_parent = $category->category_parent;
								if ($cat_parent == 0) {
									$level = 0;
								} elseif ($last_parent != $cat_parent) {
									if (in_array($cat_parent, $cats_added)) {
										$level = $level - 1;
									} else {
										$level = $level + 1;
									}
									$cats_added[] = $cat_parent;
								}
								$pad = str_repeat('&nbsp;', 3*$level);
								echo "\n\t<tr valign=\"top\"><td>$pad$category->cat_name</td><td><input type=\"checkbox\" name=\"excluded_cats[]\" value=\"$category->cat_ID\" $ex_ischecked /></td><td><input type=\"checkbox\" name=\"included_cats[]\" value=\"$category->cat_ID\" $in_ischecked /></td></tr>";
							}
						}
					?>
					</table>
				</td> 
			</tr>
			<tr valign="top">
				<th scope="row"><?php _e('Other plugins\' tags to remove from snippet:') ?></th>
				<td>
					<table>	
					<tr><td><?php _e('opening') ?></td><td><?php _e('closing') ?></td></tr>
					<tr valign="top"><td><textarea name="starttags" id="starttags" rows="4" cols="10"><?php foreach ($options['stripcodes'] as $tag) echo htmlspecialchars(stripslashes($tag['start']))."\n"; ?></textarea></td><td><textarea name="endtags" id="endtags" rows="4" cols="10"><?php foreach ($options['stripcodes'] as $tag) echo htmlspecialchars(stripslashes($tag['end']))."\n"; ?></textarea></td></tr>
					</table>
				</td> 
			</tr>
		</table>
		</fieldset>
		<div class="submit"><input type="submit" name="update_options" value="<?php _e('Update') ?>"  style="font-weight:bold;" /></div>
		</form>    		
	</div>
	<?php	
}

/*
	Work through every post and make sure it has its custom field set
*/
function save_similar_terms_for_all_posts () {
	global $wpdb;
	$termcount = 0;
	//get every post's ID
	$postIDs = $wpdb->get_results("SELECT ID FROM $wpdb->posts", ARRAY_A);
	if (!is_null($postIDs)) {
		$options = get_option('similar-posts');
		//for each post
		foreach ($postIDs as $pID) {
			$postID = $pID['ID'];
			//check if it already has its custom field
			$metaid = $wpdb->get_var("SELECT meta_id FROM $wpdb->postmeta WHERE post_id=$postID AND meta_key='similarterms' limit 1");
			if (is_null($metaid)) {
				//if not process the content for similar terms
				$content = $wpdb->get_row("SELECT post_content, post_title FROM $wpdb->posts WHERE ID = $postID", ARRAY_A);
				$terms = get_similar_terms($content['post_content'], $content['post_title'], $options['utf8'] == 'true', $options['bias_title'], $options['num_terms']);
				//and store them
				$wpdb->query("INSERT INTO $wpdb->postmeta (post_id, meta_key, meta_value) VALUES ($postID, 'similarterms', \"$terms\")");
				$termcount = $termcount + 1;
			}
		}
	}
	return $termcount;
}

/*
	Remove ALL similarterms custom fields
*/
function clear_similar_terms_for_all_posts () {
	global $wpdb;
	$numdeleted = $wpdb->query("DELETE FROM $wpdb->postmeta WHERE meta_key = 'similarterms'");
	if (!$numdeleted) {
		$numdeleted = 0;
	}
	return $numdeleted;
}

/*
	Import all Related Posts 'keywords' into 'similarterms'
*/
function import_related_posts_keywords () {
	global $wpdb;
	$postcount = 0;
	$keycount = 0;
	//get every post's ID
	$postIDs = $wpdb->get_results("SELECT ID FROM $wpdb->posts", ARRAY_A);
	if (!is_null($postIDs)) {
		//for each post
		foreach ($postIDs as $pID) {
			$postID = $pID['ID'];
			//get the custom 'keyword' field if any
			$keywords = $wpdb->get_results("SELECT meta_value FROM $wpdb->postmeta WHERE post_id=$postID AND meta_key='keyword'", ARRAY_A);
			if (!empty($keywords)) {
				$postcount = $postcount + 1;
				$keycount = $keycount + count($keywords);
				$terms = '';
				foreach ($keywords as $keywordinfo) {
					$terms = $terms . $keywordinfo['meta_value']. ' ';
				}
				$terms = trim(addslashes($terms));
				//check if it already has its custom field
				$metaid = $wpdb->get_var("SELECT meta_id FROM $wpdb->postmeta WHERE post_id=$postID AND meta_key='similarterms' limit 1");
				if (is_null($metaid)) {
					$wpdb->query("INSERT INTO $wpdb->postmeta (post_id, meta_key, meta_value) VALUES ($postID, 'similarterms', \"$terms\")");
				} else {
					$wpdb->query("UPDATE $wpdb->postmeta SET meta_value = \"$terms\" WHERE post_ID = $postID AND meta_key = 'similarterms'");
				}
			}
		}
	}
	$counter = array('posts' => $postcount, 'keywords' => $keycount);
	return $counter;
}

function similar_posts_manage_page() {
	global $wpdb;
	// we respond to the correct button click...
	// Handle the bulk processing of similar terms
	if (isset($_POST['process_all'])) {
		//make sure we do this just the once per press
		unset($_POST['process_all']);
		//do the dirty work
		$termcount = save_similar_terms_for_all_posts ();
		//show a message
		echo '<div class="updated"><p>' . __('Saved terms for ') . $termcount . __(' posts.') . '</p></div>';
     }
	// Handle the clearing of all similar terms
	if (isset($_POST['clear_all'])) {
		//make sure we do this just the once per press
		unset($_POST['clear_all']);
		//do the dirty work
		$numkeys = clear_similar_terms_for_all_posts ();
		//show a message
		echo '<div class="updated"><p>' . __('Cleared ') . $numkeys . __(' keys') .'</p></div>';
     }
	// Handle the import of keywords from the Related Posts plugin
	if (isset($_POST['import_all'])) {
		//make sure we do this just the once per press
		unset($_POST['import_all']);
		//do the dirty work
		$counter = import_related_posts_keywords ();
		//show a message
		echo '<div class="updated"><p>' . __('Imported ') . $counter['keywords'] . __(' keywords from ') . $counter['posts'] . __(' posts.') .'</p></div>';
     }
	
	?>
    <div class="wrap"> 
		<h2><?php _e('Manage Similar Posts Custom Fields') ?></h2>
		<h3><a href="http://rmarsh.com/plugins/post-options/">Help and Instructions</a></h3>
		<form method="post" action="">		
		<p><?php _e('By default this plugin processes every post each time it is viewed to find the terms to match. 
		This adds an avoidable overhead which can be bypassed if the pre-processed terms are stored
		in a custom field (called "similarterms"). This is done automatically whenever a post is published or edited
		but you can also opt to pre-process every post at once by pressing the <strong>Process</strong> 
		button below. It may take half a second per post. It will not overwrite any values that have 
		already been stored.') ?></p>
		<div class="submit">	
		<input type="submit" name="process_all" value="<?php _e('Process') ?>" style="font-weight:bold;" />
		</div>		
		<p><?php _e('There is also the option to clear <em>all</em> Similar Posts\' custom fields by pressing 
		the <strong>Clear</strong> button below.') ?></p>
		<div class="submit">
		<input type="submit" name="clear_all" value="<?php _e('Clear') ?>" style="font-weight:bold;" />
		</div> 		
		<p><?php _e('If you have been using the Related Posts plugin and have created keywords to
		sharpen up your matches you can import all your keywords into Similar Posts. This 
		overwrites the corresponding Similar Posts custom fields. To begin the import press the <strong>Import</strong> 
		button below.') ?></p>
		<div class="submit">
		<input type="submit" name="import_all" value="<?php _e('Import') ?>" style="font-weight:bold;" />
		</div>   
		</form>       
    </div>
	<?php
}

// this function gets called when the plugin is installed to set up the index and default options
function similar_posts_install() {
   	global $wpdb;
	// try and make sure the table is MyISAM format
	$wpdb->query('ALTER TABLE `'.$wpdb->posts.'` type=MYISAM');
	//try and set up the new index
	$wpdb->query('ALTER TABLE `'.$wpdb->posts.'` ADD FULLTEXT `post_similar` ( `post_title` ,' . ' `post_content` )');

	$options = get_option('similar-posts');
	// check each of the option values and, if empty, assign a default (doing it this long way
	// lets us add new options in later versions)
	if (!isset($options['limit'])) $options['limit'] = 5;
	if (!isset($options['skip'])) $options['skip'] = 0;
	if (!isset($options['trim_before'])) $options['trim_before'] = '';
	if (!isset($options['omit_current_post'])) $options['omit_current_post'] = 'true';
	if (!isset($options['show_private'])) $options['show_private'] = 'false';
	if (!isset($options['show_pages'])) $options['show_pages'] = 'false';
	if (!isset($options['none_text'])) $options['none_text'] = '<li>'.__('None Found').'</li>';
	if (!isset($options['tag_str'])) $options['tag_str'] = '';
	if (!isset($options['excluded_cats'])) $options['excluded_cats'] = '9999';
	if (!isset($options['included_cats'])) $options['included_cats'] = '9999';
	if (!isset($options['excluded_authors'])) $options['excluded_authors'] = '9999';
	if (!isset($options['included_authors'])) $options['included_authors'] = '9999';
	if (!isset($options['excluded_posts'])) $options['excluded_posts'] = '';
	if (!isset($options['stripcodes'])) $options['stripcodes'] = array(array());
	if (!isset($options['prefix'])) $options['prefix'] = '<ul>';
	if (!isset($options['suffix'])) $options['suffix'] = '</ul>';
	if (!isset($options['output_template'])) $options['output_template'] = '<li>{link}</li>';
	if (!isset($options['match_cat'])) $options['match_cat'] = 'false';
	if (!isset($options['match_tags'])) $options['match_tags'] = 'false';
	if (!isset($options['bias_title'])) $options['bias_title'] = 'equal';
	if (!isset($options['utf8'])) $options['utf8'] = 'false';
	if (!isset($options['num_terms'])) $options['num_terms'] = 20;
	update_option('similar-posts', $options);
	
}

add_action('activate_Similar_Posts/similar-posts.php','similar_posts_install');

?>