<?php 
get_header();
?>

<div id="post">
<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
	
<div class="post" id="post-<?php the_ID(); ?>">
	 <h2><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h2>
	
	<h3>
		<?php the_content(__('( Leer mas ...)')); ?>
	</h3>
	
	<h4>
			<p>Escrito por <strong><?php the_author() ?></strong> el <?php the_time('l') ?>, <?php the_time('j') ?> de <?php the_time('F') ?> del <?php the_time('Y') ?> a las <?php the_time() ?></p>
            <p><?php comments_popup_link(__('No hay comentarios'), __('Comentarios (1)'), __('Comentarios (%)')); ?></p>
			<p><?php _e("Categoria:"); ?> <?php the_category(',') ?></p>
			
	</h4>

<?php comments_template(); // Get wp-comments.php template ?>
</div>


<?php endwhile; else: ?>
	<div class="post">
		 <h2>No se encontraron resultados</h2>
		
		<h3>
			Lo siento, no se encontro nada.
		</h3>
		
	</div>
<?php endif; ?>

<?php posts_nav_link(' &#8212; ', __('&laquo; Previous Page'), __('Next Page &raquo;')); ?>



<?php get_footer(); ?>
