<?php

/*

Template Name: Archives Template

*/

?>



<?php get_header(); ?>



<div id="content">



<?php if (have_posts()) : ?>



<?php /* If this is a 404 page */ if (is_404()) { ?>

<?php /* If this is a category archive */ } elseif (is_category()) { ?>

<p class="alt">You are currently browsing the archives for the <?php single_cat_title(''); ?> category.</p>



<?php /* If this is a yearly archive */ } elseif (is_day()) { ?>

<p class="alt">You are currently browsing the <a href="<?php bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> weblog archives

for the day <?php the_time('l, F jS, Y'); ?>.</p>



<?php /* If this is a monthly archive */ } elseif (is_month()) { ?>

<p class="alt">You are currently browsing the <a href="<?php bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> weblog archives

for <?php the_time('F, Y'); ?>.</p>



<?php /* If this is a yearly archive */ } elseif (is_year()) { ?>

<p class="alt">You are currently browsing the <a href="<?php bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> weblog archives

for the year <?php the_time('Y'); ?>.</p>



<?php /* If this is a monthly archive */ } elseif (is_search()) { ?>

<p class="alt">You have searched the <a href="<?php echo bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> weblog archives

for <strong>'<?php echo wp_specialchars($s); ?>'</strong>. If you are unable to find anything in these search results, you can try one of these links.</p>



<?php /* If this is a monthly archive */ } elseif (isset($_GET['paged']) && !empty($_GET['paged'])) { ?>

<p class="alt">You are currently browsing the <a href="<?php echo bloginfo('home'); ?>/"><?php echo bloginfo('name'); ?></a> weblog archives.</p>



<?php } ?>



<?php while (have_posts()) : the_post(); ?>



<div class="post" id="post-<?php the_ID(); ?>">



<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>"><?php the_title(); ?></a></h2>



<div class="entry">

<?php the_excerpt(); ?>

</div>



<div class="postmetadata"><p>Posted by <?php the_author(); ?> on <?php the_time('d M Y') ?> at <?php the_time() ?> under <?php the_category(', ') ?> | <a href="<?php the_permalink() ?>" rel="bookmark" title="Permanent Link to <?php the_title(); ?>">Link</a>

<?php edit_post_link('Edit this entry', ' | ', ''); ?> 

</p></div>



</div>



<?php endwhile; ?>



<div class="navigation">

<div class="align-left"><?php next_posts_link('&laquo; Previous Entries') ?></div>

<div class="align-right"><?php previous_posts_link('Next Entries &raquo;') ?></div>

</div>



<?php else : ?>



<div class="post">

<h2>Page Not Found</h2>

<div class="entry">

<p>Sorry, the page you tried to access cannot be found.

</div>

</div>



<?php endif; ?>



</div> <!-- end of content div -->



<?php get_sidebar(); ?>



<?php get_footer(); ?>