<?php
// General Settings
$current = '1.0';

// Custom CSS Settings
function unnamed_fontcolor() {
	$color = get_option('unnamed_fontcolor');
	if (get_option('unnamed_fontcolor') == '')	return '#ddd';
	return $color;
}

function unnamed_linkcolor() {
	$linkcolor = get_option('unnamed_linkcolor');
	if (get_option('unnamed_linkcolor') == '')	return '#5D8BB3';
	return $linkcolor;
}

function unnamed_hovercolor() {
	$hovercolor = get_option('unnamed_hovercolor');
	if (get_option('unnamed_hovercolor') == '') return '#fc0';
	return $hovercolor;
}

function unnamed_bgcolor() {
	$bgcolor = get_option('unnamed_bgcolor');
	if (get_option('unnamed_bgcolor') == '') return '#333';
	return $bgcolor;
}

// Function for seperating comments from track- and pingbacks.
function comment_type_detection($commenttxt = 'Comment',$trackbacktxt = 'Trackback',$pingbacktxt = 'Pingback') {
	global $comment;
	if (preg_match('|trackback|',$comment->comment_type))
		return $trackbacktxt;
	elseif (preg_match('|pingback|',$comment->comment_type))
		return $pingbacktxt;
	else
		return $commenttxt;
}

// Get theme info
function unnamed_info($show='') {
	echo get_unnamed_info($show);
}

function get_unnamed_info($show='') {
	global $current;

	switch ($show) {
		case 'version' :
    		$output = $current;
			break;
		case 'scheme' :
			$output = get_bloginfo('template_url') . '/styles/' . get_option('unnamed_scheme');
			break;
		case 'js_url' :
			$template_url = get_bloginfo('template_url');

			if(preg_match('/^http:\/\/[^\/]+(.+)/',$template_url,$url_parts)) {
				$output = "window.location.href.match(/^(http:\\/\\/[^\\/]+)/)[1] + '" . $url_parts[1] . "'";
			// This should never be executed,but it's well to be on the safe side
			} else {
				$output = $template_url;
			}
	}
	return $output;
}
?>
<?php
class UnnamedOptions {
	function unnamed_init() {
		load_theme_textdomain('unnamed');
		// Function for Sidebar Widgets
		if (function_exists('register_sidebar')) { register_sidebars(3,array('name'=>'Sidebar %d')); }
		//Check installation
		global $current;
		if (!get_option('unnamed_installed') || get_option('unnamed_installed') <= $current) { UnnamedOptions::unnamed_install(); }
		// Add menus
		add_action('admin_menu',array('UnnamedOptions','unnamed_add_menu'));
		// Check if this page is the one being shown,if so then add stuff to the header
		if($_GET['page'] == 'unnamed-options') {
			add_action("admin_head",array('UnnamedFunctions','unnamed_admin_css'),50);
			add_action("admin_head",array('UnnamedFunctions','unnamed_admin_js'),51);
		}
	}
	
	function unnamed_add_menu() {
		// Add the submenus
		add_submenu_page('themes.php',__('Unnamed Options','unnamed'),__('Unnamed Options','unnamed'),5,'unnamed-options','unnamed_admin');
	}

	// install unnamed
	function unnamed_install() {
		global $current;
		// Add / update the version number
		if (!get_option('unnamed_installed')) {
			add_option('unnamed_installed',$curent,'This options simply tells me if unnamed has been installed before');
		} else {
			update_option('unnamed_installed',$current);
		}
		add_option('unnamed_scriptloader','0','Enable to use the wordpress 2.1 script loader');
		add_option('unnamed_livesearch','1',"Disable Live Search to use classic Search"); 
		add_option('unnamed_shelf','1',"If you don't trust JavaScript and Ajax,just turn it off. Otherwise I suggest you leave it on"); 
		add_option('unnamed_ajaxcommenting','1',"Disable to use classic comment");
		add_option('unnamed_showsidebarpage','1',"Check to show sidebar on the pages");
		add_option('unnamed_showsidebarsingle','1',"Check to show sidebar on the single pages");
		add_option('unnamed_showsidebarcat','1',"Check to show sidebar on the archive pages");
		add_option('unnamed_dropmenu','1',"Check to show drop down menu");
	}
	
	// update options
	function unnamed_update() {
		if (!empty($_POST)) {
			if (isset($_POST['scriptloader'])) {
				update_option('unnamed_scriptloader','1');
			} else {
				update_option('unnamed_scriptloader','0');
			}
			if (isset($_POST['livesearch'])) {
				update_option('unnamed_livesearch','1');
			} else {
				update_option('unnamed_livesearch','0');
			}
			if (isset($_POST['shelf'])) {
				update_option('unnamed_shelf','1');
			} else {
				update_option('unnamed_shelf','0');
			}
			if (isset($_POST['ajaxcommenting'])) {
				update_option('unnamed_ajaxcommenting','1');
			} else {
				update_option('unnamed_ajaxcommenting','0');
			}
			if (isset($_POST['showsidebarpage'])) {
				update_option('unnamed_showsidebarpage','1');
			} else {
				update_option('unnamed_showsidebarpage','0');
			}
			if (isset($_POST['showsidebarsingle'])) {
				update_option('unnamed_showsidebarsingle','1');
			} else {
				update_option('unnamed_showsidebarsingle','0');
			}
			if (isset($_POST['showsidebarcat'])) {
				update_option('unnamed_showsidebarcat','1');
			} else {
				update_option('unnamed_showsidebarcat','0');
			}
			if (isset($_POST['dropmenu'])) {
				update_option('unnamed_dropmenu','1');
			} else {
				update_option('unnamed_dropmenu','0');
			}
			if (isset($_POST['headerheight'])) { 
				update_option('unnamed_headerheight',$_POST['headerheight']); 
			}
			if (isset($_POST['headerwidth'])) { 
				update_option('unnamed_headerwidth',$_POST['headerwidth']); 
			}
			if (isset($_POST['fontcolor'])) { 
				update_option('unnamed_fontcolor',$_POST['fontcolor']); 
			}
			if (isset($_POST['linkcolor'])) { 
				update_option('unnamed_linkcolor',$_POST['linkcolor']); 
			}
			if (isset($_POST['hovercolor'])) { 
				update_option('unnamed_hovercolor',$_POST['hovercolor']); 
			}
			if (isset($_POST['bgcolor'])) { 
				update_option('unnamed_bgcolor',$_POST['bgcolor']); 
			}
			if (isset($_POST['rss'])) { 
				update_option('unnamed_rss',$_POST['rss']); 
			}
			if (isset($_POST['uninstall'])) {
				UnnamedOptions::unnamed_uninstall();
			}
		}
	}

	// uninstall unnamed
	function unnamed_uninstall() {
		global $wpdb;
		// Remove the options from the database
		$cleanup = $wpdb->query("DELETE FROM $wpdb->options WHERE option_name LIKE 'unnamed%'");
		// Flush the dang cache
		wp_cache_flush();
		// Activate the default Wordpress theme
		update_option('template','default');
		update_option('stylesheet','default');
		do_action('switch_theme','Default');
		// Go back to the themes page
		echo '<meta http-equiv="refresh" content="0;URL=themes.php?activated=true">';
		echo "<script> self.location(\"themes.php?activated=true\");</script>";
		exit;
	}
}
?>
<?php
class UnnamedFunctions {
	function unnamed_admin_js() {
?>
<script type="text/javascript" src="../wp-includes/js/colorpicker.js"></script>
<script type='text/javascript'>
// <![CDATA[
function pickColor(color) {
	ColorPicker_targetInput.value = color;
	colorUpdate(ColorPicker_targetInput.id);
}
function PopupWindow_populate(contents) {
	contents += '<br /><p style="text-align:center;margin-top:0px;"><input type="button" value="<?php _e('Close Color Picker','unnamed') ?>" onclick="cp.hidePopup(\'prettyplease\')"></input></p>';
	this.contents = contents;
	this.populated = false;
}
function PopupWindow_hidePopup(magicword) {
	if (magicword != 'prettyplease')
		return false;
	if (this.divName != null) {
		if (this.use_gebi) {
			document.getElementById(this.divName).style.visibility = "hidden";
		}
		else if (this.use_css) {
			document.all[this.divName].style.visibility = "hidden";
		}
		else if (this.use_layers) {
			document.layers[this.divName].visibility = "hidden";
		}
	}
	else {
		if (this.popupWindow && !this.popupWindow.closed) {
			this.popupWindow.close();
			this.popupWindow = null;
		}
	}
	return false;
}
function colorSelect(t,p) {
	if (cp.p == p && document.getElementById(cp.divName).style.visibility != "hidden")
		cp.hidePopup('prettyplease');
	else {
		cp.p = p;
		cp.select(t,p);
	}
}
var cp = new ColorPicker();
function advUpdate(val,obj) {
	document.getElementById(obj).value = val;
	colorUpdate(obj);
}
function colorUpdate(oid) {
	if ('fontcolor' == oid) {
		document.getElementById('unnamedfontcolor').style.color = document.getElementById('fontcolor').value;
		document.getElementById('advfontcolor').value = document.getElementById('fontcolor').value;
	}
	
	if ('linkcolor' == oid) {
		document.getElementById('unnamedlinkcolor').style.color = document.getElementById('linkcolor').value;
		document.getElementById('advlinkcolor').value = document.getElementById('linkcolor').value;
	}
	
	if ('hovercolor' == oid) {
		document.getElementById('unnamedhovercolor').style.color = document.getElementById('hovercolor').value;
		document.getElementById('advhovercolor').value = document.getElementById('hovercolor').value;
	}
	
	if ('bgcolor' == oid) {
		document.getElementById('unnamedbgcolor').style.background = document.getElementById('bgcolor').value;
		document.getElementById('advbgcolor').value = document.getElementById('bgcolor').value;
	}
}
function toggleAdvanced() {
	a = document.getElementById('advanced');
	if (a.style.display == 'none')
		a.style.display = 'block';
	else
		a.style.display = 'none';
}
function toggleStyle() {
	m = document.getElementById('togglestyle');
	if (m.style.display == 'none')
		m.style.display = 'block';
	else
		m.style.display = 'none';
}
function toggleMisc() {
	m = document.getElementById('togglemisc');
	if (m.style.display == 'none')
		m.style.display = 'block';
	else
		m.style.display = 'none';
}
function colorDefaults() {
	document.getElementById('unnamedfontcolor').style.color = '#ddd';
	document.getElementById('unnamedlinkcolor').style.color = '#5D8BB3';
	document.getElementById('unnamedhovercolor').style.color = '#fc0';
	document.getElementById('unnamedbgcolor').style.background = '#333';
	document.getElementById('advfontcolor').value = document.getElementById('fontcolor').value = '#ddd';
	document.getElementById('advlinkcolor').value = document.getElementById('linkcolor').value = '#5D8BB3';
	document.getElementById('advhovercolor').value = document.getElementById('hovercolor').value = '#fc0';
	document.getElementById('advbgcolor').value = document.getElementById('bgcolor').value = '#333';
}
// ]]>
</script>
<?php } function unnamed_admin_css() { ?>
<style type="text/css">	
body {font:62.5% "Lucida Grande", Verdana, Lucida, Helvetica, Arial, sans-serif;}
h2 {font:2.4em "Trebuchet MS", Arial, Verdana, Tahoma, sans-serif;border:0;margin:5px 0 !important;}
h3 {font:1.8em "Trebuchet MS", Arial, Verdana, Tahoma, sans-serif;margin:5px 0;color:#333;}
h4 {font:1.5em "Trebuchet MS", Arial, Verdana, Tahoma, sans-serif;margin:5px 0 0;color:#333;}
small {color:#777;font-size:.9em;}
.wrap {font-size:1.2em;}
.unnamedcontainer {width:800px;margin:0 auto;text-align:left;color:#333;}
.unnamedcontainer input[type=checkbox],.unnamedcontainer input[type=radio] {border:0;}
.unnamedoptions {clear:both;width:780px;margin:0 0 20px;padding:10px;border:1px solid #ccc;}
.floatleft {float:left;width:250px;padding:0 5px;}
#admin-content {height:50px;width:390px;margin:0 100px;background:#555;border-left:5px solid #444;border-right:5px solid #444;}
#unnamedbgcolor {margin:8px 0 0;height:50px;width:600px;}
#unnamedfontcolor {float:left;text-align:center;margin:15px 10px 5px 40px;}
#unnamedlinkcolor {float:left;text-align:center;margin:15px 10px 5px 30px;}
#unnamedhovercolor {float:left;text-align:center;margin:15px 40px 5px 30px;}
#advanced,#togglestyle,#togglemisc {marign:10px 0;}
#colorPickerDiv a,#colorPickerDiv a:hover {padding:1px;text-decoration: none;border-bottom: 0px;}
.clear {clear:both;}
</style>
<?php } } function unnamed_admin() {
	global $wpdb;
	// Update
	$update = UnnamedOptions::unnamed_update();
?>
<?php if(isset($_POST['submit'])) : ?>
<div id="message2" class="updated fade">
  <p>
    <?php _e('Options have been updated.','unnamed'); ?>
  </p>
</div>
<?php endif; ?>
<div class="wrap">
  <h2>
    <?php _e('Unnamed Options','unnamed'); ?>
  </h2>
  <p style="margin-left:5px;"><small><?php printf(__('You can always get the latest version <a href="http://xuyiyang.com/wordpress-themes/unnamed/">here</a>.','unnamed')) ?></small></p>
  <div class="unnamedcontainer">
    <form name="dofollow" action="" method="post">
      <input type="hidden" name="action" value="<?php echo($update); ?>" />
      <input type="hidden" name="page_options" value="'dofollow_timeout'" />
      <p class="submit">
        <input type="submit" name="submit" value="<?php _e('Update Options','unnamed'); ?> &raquo;" />
      </p>
      <h3>
        <?php _e('AJAX Options','unnamed'); ?>
      </h3>
      <div class="unnamedoptions">
        <div class="floatleft">
          <h4>
            <?php _e('Live Search','unnamed'); ?>
          </h4>
          <p>
            <input name="livesearch" id="livesearch" type="checkbox" value="1" <?php checked('1',get_option('unnamed_livesearch')); ?> />
            <label for="livesearch">
            <?php _e('Enable Livesearch','unnamed'); ?>
            </label>
          </p>
        </div>
        <div class="floatleft">
          <h4>
            <?php _e('Live Commenting','unnamed'); ?>
          </h4>
          <p>
            <input name="ajaxcommenting" id="ajaxcommenting" type="checkbox" value="1" <?php checked('1',get_option('unnamed_ajaxcommenting')); ?> />
            <label for="ajaxcommenting">
            <?php _e('Enable Live Commenting','unnamed'); ?>
            </label>
          </p>
        </div>
        <div class="floatleft">
          <h4>
            <?php _e('Sliding Effect','unnamed'); ?>
          </h4>
          <p>
            <input name="shelf" id="shelf" type="checkbox" value="1" <?php checked('1',get_option('unnamed_shelf')); ?> />
            <label for="shelf">
            <?php _e('Enable Sliding Effect','unnamed'); ?>
            </label>
          </p>
        </div>
        <div class="floatleft">
          <h4>
            <?php _e('Script Loader','unnamed'); ?>
          </h4>
          <p>
            <input name="scriptloader" id="scriptloader" type="checkbox" value="1" <?php checked('1',get_option('unnamed_scriptloader')); ?> />
            <label for="scriptloader">
            <?php _e('Enable Script Loader','unnamed'); ?>
            </label>
          </p>
        </div>
        <p class="clear"><small>
          <?php _e('Enable WordPress 2.1 Script Loader for better plugin compatibility. Disable it for better performance.','unnamed'); ?>
          </small></p>
      </div>
      <h3>
        <?php _e('Custom Styles','unnamed'); ?>
      </h3>
      <div class="unnamedoptions">
        <div style="width:100%;">
          <h4>
            <?php _e('Colors','unnamed'); ?>
          </h4>
          <div id="unnamedbgcolor" style="background:<?php echo unnamed_bgcolor(); ?>;">
            <div id="admin-content">
              <p id="unnamedfontcolor" style="color:<?php echo unnamed_fontcolor(); ?>;">
                <?php _e('Text Color','unnamed'); ?>
              </p>
              <p id="unnamedlinkcolor" style="color:<?php echo unnamed_linkcolor(); ?>;">
                <?php _e('Link Color','unnamed'); ?>
              </p>
              <p id="unnamedhovercolor" style="color:<?php echo unnamed_hovercolor(); ?>;">
                <?php _e('Link Hover Color','unnamed'); ?>
              </p>
            </div>
          </div>
          <br class="clear" />
          <input type="button" onclick="tgt=document.getElementById('fontcolor');colorSelect(tgt,'pick1');return false;" name="pick1" id="pick1" value="<?php _e('Font Color','unnamed'); ?>" />
          <input type="button" onclick="tgt=document.getElementById('linkcolor');colorSelect(tgt,'pick2');return false;" name="pick2" id="pick2" value="<?php _e('Link Color','unnamed'); ?>" />
          <input type="button" onclick="tgt=document.getElementById('hovercolor');colorSelect(tgt,'pick3');return false;" name="pick3" id="pick3" value="<?php _e('Link Hover Color','unnamed'); ?>" />
          <input type="button" onclick="tgt=document.getElementById('bgcolor');colorSelect(tgt,'pick4');return false;" name="pick4" id="pick4" value="<?php _e('Background Color','unnamed'); ?>" />
          <input type="hidden" name="fontcolor" id="fontcolor" value="<?php echo get_option('unnamed_fontcolor'); ?>" />
          <input type="hidden" name="linkcolor" id="linkcolor" value="<?php echo get_option('unnamed_linkcolor'); ?>" />
          <input type="hidden" name="hovercolor" id="hovercolor" value="<?php echo get_option('unnamed_hovercolor'); ?>" />
          <input type="hidden" name="bgcolor" id="bgcolor" value="<?php echo get_option('unnamed_bgcolor'); ?>" />
          <input type="button" name="default" value="<?php _e('Default Colors','unnamed'); ?>" onclick="colorDefaults()" />
          <input type="button" value="<?php _e('Advanced','unnamed'); ?>" onclick="toggleAdvanced()" />
          <div id="colorPickerDiv" style="z-index:100;background:#eee;border:1px solid #ccc;position:absolute;visibility:hidden;"> </div>
          <div id="advanced" style="display:none;"> <br />
            <label for="advfontcolor">
            <?php _e('Font Color:','unnamed'); ?>
            </label>
            <input type="text" id="advfontcolor" onchange="advUpdate(this.value,'fontcolor')" value="<?php echo get_option('unnamed_fontcolor'); ?>" />
            <br />
            <label for="advlinkcolor">
            <?php _e('Link Color:','unnamed'); ?>
            </label>
            <input type="text" id="advlinkcolor" onchange="advUpdate(this.value,'linkcolor')" value="<?php echo get_option('unnamed_linkcolor'); ?>" />
            <br />
            <label for="advhovercolor">
            <?php _e('Link Hover Color:','unnamed'); ?>
            </label>
            <input type="text" id="advhovercolor" onchange="advUpdate(this.value,'hovercolor')" value="<?php echo get_option('unnamed_hovercolor'); ?>" />
            <br />
            <label for="advbgcolor">
            <?php _e('Background Color:','unnamed'); ?>
            </label>
            <input type="text" id="advbgcolor" onchange="advUpdate(this.value,'bgcolor')" value="<?php echo get_option('unnamed_bgcolor'); ?>" />
            <br />
          </div>
        </div>
      </div>
      <span style="float:right">
      <input type="button" value="<?php _e('More Options','unnamed'); ?> &raquo;" onclick="toggleMisc()" />
      </span>
      <h3>
        <?php _e('Miscellaneous','unnamed'); ?>
      </h3>
      <div class="unnamedoptions">
        <h4>
          <?php _e('Feed Address','unnamed'); ?>
        </h4>
        <p>
          <input type="text" style="width:350px;" name="rss" value="<?php echo (get_option('unnamed_rss')); ?>" />
        </p>
        <p><small>
          <?php _e('You may use your burned feed to replace the default RSS 2.0.<br />For example: http://feeds.feedburner.com/yourfeedaddress','unnamed'); ?>
          </small></p>
        <div id="togglemisc" style="display:none;">
          <div class="floatleft">
            <h4>
              <?php _e('Header Size','unnamed'); ?>
            </h4>
            <p>
              <label for="headerheight">
              <?php _e('Header Height','unnamed'); ?>
              </label>
              <input type="text" style="width:32px;" id="headerheight" name="headerheight" value="<?php echo get_option('unnamed_headerheight'); ?>" />
              px. <br />
              <label for="headerwidth">
              <?php _e('Header Width','unnamed'); ?>
              </label>
              <input type="text" style="width:32px;" id="headerwidth" name="headerwidth" value="<?php echo get_option('unnamed_headerwidth'); ?>" />
              px. </p>
          </div>
          <div class="floatleft">
            <h4>
              <?php _e('Display Sidebar Items','unnamed'); ?>
            </h4>
            <p>
              <input name="showsidebarpage" id="onpage" type="checkbox" value="1" <?php checked('1',get_option('unnamed_showsidebarpage')); ?> />
              <label for="onpage">
              <?php _e('on static pages','unnamed'); ?>
              </label>
              <br />
              <input name="showsidebarsingle" id="onsingle" type="checkbox" value="1" <?php checked('1',get_option('unnamed_showsidebarsingle')); ?> />
              <label for="onsingle">
              <?php _e('on single post pages','unnamed'); ?>
              </label>
              <br />
              <input name="showsidebarcat" id="onarchive" type="checkbox" value="1" <?php checked('1',get_option('unnamed_showsidebarcat')); ?> />
              <label for="onarchive">
              <?php _e('on archive pages','unnamed'); ?>
              </label>
            </p>
          </div>
          <div class="floatleft">
            <h4>
              <?php _e('Drop Down Menu','unnamed'); ?>
            </h4>
            <p>
              <input name="dropmenu" id="dropmenu-on" type="checkbox" value="1" <?php checked('1',get_option('unnamed_dropmenu')); ?> />
              <label for="dropmenu-on">
              <?php _e('Enable Drop Down Menu','unnamed'); ?>
              </label>
            </p>
          </div>
          <p class="clear"><small>
            <?php _e('Crop the header to suit your requirements when you <a href="themes.php?page=custom-header">upload an image</a>.','unnamed'); ?>
            </small></p>
        </div>
      </div>
      <br class="clear" />
      <p class="submit">
        <input type="submit" name="submit" value="<?php _e('Update Options','unnamed'); ?> &raquo;" />
      </p>
    </form>
    <h3>
      <?php _e('Donate','unnamed'); ?>
    </h3>
    <p><?php printf(__('Consider make a donation with <a href="http://www.paypal.com">Paypal</a> to keep the project going. Any and all donations are sincerely appreciated. Thanks.','unnamed')) ?></p>
    <form action="https://www.paypal.com/cgi-bin/webscr" method="post">
      <p>
        <input type="hidden" name="cmd" value="_s-xclick" />
        <input type="image" src="https://www.paypal.com/en_US/i/btn/x-click-but21.gif" style="border:0;" name="submit" alt="Make payments with PayPal - it's fast, free and secure!" />
        <input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----MIIHTwYJKoZIhvcNAQcEoIIHQDCCBzwCAQExggEwMIIBLAIBADCBlDCBjjELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtQYXlQYWwgSW5jLjETMBEGA1UECxQKbGl2ZV9jZXJ0czERMA8GA1UEAxQIbGl2ZV9hcGkxHDAaBgkqhkiG9w0BCQEWDXJlQHBheXBhbC5jb20CAQAwDQYJKoZIhvcNAQEBBQAEgYB61Mmat6Cf1zLhOn9zcsWJZ/noGe6pwwwb854LK0wOzlmDxxLmnt7DaHA+V9rEKYLlR4u9iTf5V4VV0V13xUdpnHRGsipmpktH3pPQWbQFTuQ2DRtyUfQ0vTFG5Xv3IuBeIAtckMiUEWE6cVBdXj7yi3SI4LM+1IB48mnvHXKctjELMAkGBSsOAwIaBQAwgcwGCSqGSIb3DQEHATAUBggqhkiG9w0DBwQI26IyRIrYZxGAgaiII0CKwIWMKvU5D2r5yE8xvmz0Ecric4fGaxGOih/3LpRGgYOCMqDuIl5awsd12vJ07fMCfMhvEMZrDnHlyqBSX770XM5Ic50nD8Oo2Xw8+SDmUZm8yxs/yEEK3MW9zdRaZzrrF7WIRjguJjMuLEMtejA5K2mAhk5BxoC9oXksVpMjb1qfONp7npAz8F7gZIWXqocgnUf3Vf/S7/8hSEVst5PfnkzsfSmgggOHMIIDgzCCAuygAwIBAgIBADANBgkqhkiG9w0BAQUFADCBjjELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtQYXlQYWwgSW5jLjETMBEGA1UECxQKbGl2ZV9jZXJ0czERMA8GA1UEAxQIbGl2ZV9hcGkxHDAaBgkqhkiG9w0BCQEWDXJlQHBheXBhbC5jb20wHhcNMDQwMjEzMTAxMzE1WhcNMzUwMjEzMTAxMzE1WjCBjjELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRYwFAYDVQQHEw1Nb3VudGFpbiBWaWV3MRQwEgYDVQQKEwtQYXlQYWwgSW5jLjETMBEGA1UECxQKbGl2ZV9jZXJ0czERMA8GA1UEAxQIbGl2ZV9hcGkxHDAaBgkqhkiG9w0BCQEWDXJlQHBheXBhbC5jb20wgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAMFHTt38RMxLXJyO2SmS+Ndl72T7oKJ4u4uw+6awntALWh03PewmIJuzbALScsTS4sZoS1fKciBGoh11gIfHzylvkdNe/hJl66/RGqrj5rFb08sAABNTzDTiqqNpJeBsYs/c2aiGozptX2RlnBktH+SUNpAajW724Nv2Wvhif6sFAgMBAAGjge4wgeswHQYDVR0OBBYEFJaffLvGbxe9WT9S1wob7BDWZJRrMIG7BgNVHSMEgbMwgbCAFJaffLvGbxe9WT9S1wob7BDWZJRroYGUpIGRMIGOMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExFjAUBgNVBAcTDU1vdW50YWluIFZpZXcxFDASBgNVBAoTC1BheVBhbCBJbmMuMRMwEQYDVQQLFApsaXZlX2NlcnRzMREwDwYDVQQDFAhsaXZlX2FwaTEcMBoGCSqGSIb3DQEJARYNcmVAcGF5cGFsLmNvbYIBADAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4GBAIFfOlaagFrl71+jq6OKidbWFSE+Q4FqROvdgIONth+8kSK//Y/4ihuE4Ymvzn5ceE3S/iBSQQMjyvb+s2TWbQYDwcp129OPIbD9epdr4tJOUNiSojw7BHwYRiPh58S1xGlFgHFXwrEBb3dgNbMUa+u4qectsMAXpVHnD9wIyfmHMYIBmjCCAZYCAQEwgZQwgY4xCzAJBgNVBAYTAlVTMQswCQYDVQQIEwJDQTEWMBQGA1UEBxMNTW91bnRhaW4gVmlldzEUMBIGA1UEChMLUGF5UGFsIEluYy4xEzARBgNVBAsUCmxpdmVfY2VydHMxETAPBgNVBAMUCGxpdmVfYXBpMRwwGgYJKoZIhvcNAQkBFg1yZUBwYXlwYWwuY29tAgEAMAkGBSsOAwIaBQCgXTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0wNzAzMTkwNjExMjRaMCMGCSqGSIb3DQEJBDEWBBRi8HOU1qy0SsgDs3sWD/xYuFof3TANBgkqhkiG9w0BAQEFAASBgImpmmEOX5yBr3jOLMDdxcEke1ndRb++NdTgTA3ouJSBeAbo+NEMpdUlmlQ6ZaqXK9UqbZwKDbFnApKG5J+oVlxyBPeURGSU37E4ZVZf4tNDmSubURmu1QW1GqHwJTpMKpl9ArSs4fYxEW3tFw6pdfgQfKozGFCbxjBlfnMnUxgK-----END PKCS7-----" />
      </p>
    </form>
    <h3>
      <?php _e('Uninstall','unnamed'); ?>
    </h3>
    <p><?php printf(__('Press the uninstall button to clean things up in the database. You will be redirected to the <a href="themes.php">Themes admin interface</a>. <br />This will not remove your settings of custom image header,you can restore original header in <a href="themes.php?page=custom-header">this page</a>.','unnamed')) ?></p>
    <form action="" method="post">
      <p class="submit">
        <input name="uninstall" id="uninstall" class="button" type="submit" value="<?php _e('Uninstall Theme','unnamed'); ?> &raquo;" />
      </p>
    </form>
  </div>
</div>
<?php  } 
// Custom Image Header Functions
define('HEADER_TEXTCOLOR','FFFFFF');
define('HEADER_IMAGE','%s/images/bg_header.jpg'); // %s is theme dir uri

if (get_option('unnamed_headerheight') == "") { define('HEADER_IMAGE_HEIGHT',150);
} else {
define('HEADER_IMAGE_HEIGHT',get_option('unnamed_headerheight'));
}

if (get_option('unnamed_headerwidth') == "") { define('HEADER_IMAGE_WIDTH',960);
} else {
define('HEADER_IMAGE_WIDTH',get_option('unnamed_headerwidth'));
}

function custom_css() {
?>
<style type="text/css">
body {
color:<?php echo unnamed_fontcolor(); ?>;
background:<?php echo unnamed_bgcolor(); ?>;
}

a,a:link,a:active,a:visited {
color:<?php echo unnamed_linkcolor(); ?>;
}

a:hover {
color:<?php echo unnamed_hovercolor(); ?>;
}

#header {
height:<?php echo HEADER_IMAGE_HEIGHT; ?>px;
background:url(<?php header_image() ?>) transparent repeat top center;
}

<?php if (get_header_textcolor()=='blank' ) { ?>
#header h1, .description {
display:none;
}
<?php } else { ?>
#header h1 a,.description {
color:#<?php header_textcolor() ?>;
}
<?php } ?>
</style>
<?php
}

function admin_header_style() {
?>
<style type="text/css">
#headimg {
background-image:url(<?php header_image() ?>);
background-repeat:repeat !important;
height:<?php echo HEADER_IMAGE_HEIGHT; ?>px;
width:<?php echo HEADER_IMAGE_WIDTH; ?>px;
margin:0 0 10px;
}
#headimg h1 {
font-size:2.2em;
text-align:left;
margin:0;
padding:45px 0 0 20px;
}
#headimg h1 a {
color:#<?php header_textcolor() ?>;
text-decoration: none;
border-bottom: none;
}
#headimg #desc {
color:#<?php header_textcolor() ?>;
font-size:1em;
text-align:left;
padding:0 0 5px 20px;
}
<?php if ('blank' == get_header_textcolor()) { ?>
#headimg h1,#headimg #desc {
display:none;
}
#headimg h1 a,#headimg #desc {
color:#<?php echo HEADER_TEXTCOLOR ?>;
}
<?php } ?>
</style>
<?php }

UnnamedOptions::unnamed_init();

wp_register_script('unnamed_livesearch',get_bloginfo('template_directory') . '/js/livesearch.js.php',array('scriptaculous-effects'));
wp_register_script('unnamed_comments',get_bloginfo('template_directory') . '/js/comments.js.php',array('scriptaculous-effects'));
wp_register_script('unnamed_functions',get_bloginfo('template_directory') . '/js/functions.js.php',array('scriptaculous-effects'));
add_custom_image_header('custom_css','admin_header_style');
?>
