<?php
/*
Template Name: news
*/
?>
<?php 
get_header();
?>
	<div id="right">
		<div id="rightbox">
			<div class="entry">
				<div class="text">
					<ul>
						<?php
						$myposts = get_posts('numberposts=5&offset=1&category=1');
						foreach($myposts as $post) :
						?>
							<li><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a> --- <?php the_excerpt(); ?></li>
						<?php endforeach; ?>
					</ul>
	  			</div>
			</div>
			
			<?php the_post(); ?>
			<div class="entry" id="post-<?php the_ID(); ?>">
				<h2><a href="<?php the_permalink() ?>" rel="bookmark"><?php the_title(); ?></a></h2>
				<div class="meta">
					<div><p><?php _e("Last Modified on"); ?> <?php the_modified_date('Y年Fj日lG時i分') ?></p></div>
					<div class="print"><p><?php _e("Last Modified on"); ?> <?php the_modified_date('Y年Fj日lG時i分') ?> <?php _e("Posted by"); ?> <?php the_author() ?></p></div>
			          <div><?php wp_link_pages(); ?></div>
					<div class="print"><p class="trackback_to"><?php _e('URI: '); ?>&nbsp;&nbsp;&nbsp;<cite><?php the_permalink() ?></cite></p></div>
				</div>
				<div class="text">
					<?php the_content(__('(more...)')); ?>
				</div>
				<!--
					<?php trackback_rdf(); ?>
				-->
				<div class="meta">
			          <?php wp_link_pages(); ?>
					<div><p><?php _e("Posted by"); ?> <?php the_author() ?> | <?php _e("Category "); ?> <?php the_category(' | ') ?>&nbsp;<?php edit_post_link(__('Edit')); ?></p></div>
					<div class="print"><p><?php bloginfo('name'); ?>&nbsp;-&nbsp;<?php _e("Category "); ?>&nbsp;&nbsp;&nbsp;<?php the_category(' | ') ?></p></div>
					<p><?php comments_popup_link(__('No Comment'), __('<strong>1</strong> Comment'), __('Comments <strong>%</strong>')); ?></p>
				</div>
				<div class="comments"><?php comments_template(); ?></div>
			</div>
			<div class="post_navi"><?php posts_nav_link(' &#8212; ', __('&laquo; Previous Page'), __('Next Page &raquo;')); ?></div>
			<div class="entry_navi">
				<ul>
					<li><?php previous_post_link('&laquo; %link') ?></li>
					<li>| <a href="<?php bloginfo('url'); ?>"><?php _e("Go to Top"); ?></a> |</li>
					<li><?php next_post_link('%link &raquo;') ?></li>
				</ul>
			</div>
		</div>
		<div id="rightpanel">
			<div id="rightpanel_bg">
				<div class="sidebar">
					<?php include (TEMPLATEPATH.'/sidebar_right.php') ?>
				</div>
			</div>
		</div>
		<br style="clear:both;" />
	</div>
	<br style="clear:both;" />
</div>
<?php get_footer(); ?>
