<?php get_header(); ?>

<div id="content">
  
  <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
  
    <div class="post" id="post-<?php the_ID(); ?>">

        <h2><a href="<?php echo get_permalink() ?>" rel="bookmark" title="Permanent Link: <?php the_title(); ?>"><?php the_title(); ?></a> <?php edit_post_link('<img alt="Edit" title="Edit This Entry" src="' . get_bloginfo('template_directory') . '/images/edit.png" />', '', ''); ?></h2>
		<span class="post-cat"><?php the_category(', ') ?></span> <span class="post-author"><?php the_author_posts_link() ?></span> <span class="post-calendar"><?php the_time('F jS. Y, g:ia') ?></span>

		<div class="post-content">
		  <?php the_content('Read the rest of this entry &raquo;'); ?>		
		  <?php link_pages('<p><strong>Pages:</strong> ', '</p>', 'number'); ?>
		</div>

		<div class="entrymeta">
		  <ul>
		  <?php
		  // *** Trackback URI: only if ping is enabled
		  if ( pings_open() ) { ?>
			  <li class="trackback-leftalign"><a title="Trackback-URL for &#39;<?php the_title() ?>&#39;" href="<?php trackback_url() ?>" rel="nofollow">Trackback-URL</a></li>
<?php     }
		  ?>

		  <?php
	  	  // *** RSS Comments: only if comments are enabled 
		  if ( comments_open() ) { ?>
			  <li class="feed-leftalign"><span title="Subscribe to comments feed"><?php comments_rss_link('comments feed for this post') ?></span></li>
<?php	  }
		  ?>
				
		  <?php
		  // *** Tags: only if there is any
		  if ( (function_exists('UTW_ShowTagsForCurrentPost')) ) { ?>
		      <li class="utwtags"><span title="tags"><?php UTW_ShowTagsForCurrentPost("commalist") ?></span></li>
<?php     }
		  ?>
		  </ul>
		</div><!-- [entrymeta] -->
		
		<?php comments_template(); // Get wp-comments.php template ?>

	</div><!-- [post] -->
		
  <?php endwhile; else: ?>

	<p><?php _e('No Entries found.'); ?></p>

  <?php endif; ?>

</div><!-- [content] -->

<?php get_sidebar(); ?>
  
<?php get_footer(); ?>

