<?php
//
// Credits for this go to theundersigned.net
//
$themename = "AjaxBerlee";
$shortname = "Berlee";
$options = array (
	array(	"name" => "Recent Article Links",
			"description" => "Number of Recent Article Links that are displayed in the Ticker. 0 means disable",
			"id" => $shortname."_Ticker",
			"type" => "text",
			"std" => "15"),

	array(	"name" => "Left Sidebar",
			"description" => "If disabled, the left sidebar will not be displayed and the space for articles is bigger.",
			"id" => $shortname."_LeftSidebar",
			"type" => "select",
			"std" => "Enabled",
			"options" => array("Enabled", "Disabled")),

	array(	"name" => "Google Analytics Account ID",
			"description" => "Use the following format: UA-123456-7<br />Leave it blank if you are not using Google Analytics.",
			"id" => $shortname."_GoogleAnalytics",
			"std" => "",
			"type" => "text",
			"length" => "12"),

	array(	"name" => "About Box",
			"description" => "Text you want have on the frontpage next to the latest article.",
			"id" => $shortname."_About",
			"std" => "",
			"type" => "text",
			"length" => "100"),


	array(	"name" => "About \"read more\" link",
			"description" => "URL (can start with http or just /) which will be linked to the read more link in the About Box. <br />Leave it blank if you don't want to a Read more link.",
			"id" => $shortname."_AboutLink",
			"std" => "",
			"type" => "text",
			"length" => "50"),

);

function Berlee_add_admin() {

	global $themename, $options;

	if ( $_GET['page'] == basename(__FILE__) ) {
	
		if ( 'save' == $_REQUEST['action'] ) {

				foreach ($options as $value) {
					if( isset( $_REQUEST[ $value['id'] ] ) ) { update_option( $value['id'], htmlentities($_REQUEST[ $value['id'] ] )); } else { delete_option( $value['id'] ); } }

				header("Location: themes.php?page=".basename(__FILE__)."&saved=true");
				die;

		} else if( 'reset' == $_REQUEST['action'] ) {

			foreach ($options as $value) {
				delete_option( $value['id'] ); }

			header("Location: themes.php?page=".basename(__FILE__)."&reset=true");
			die;

		}
	}

    add_theme_page($themename." Options", "AjaxBerlee Options", 'edit_themes', basename(__FILE__), 'berlee_admin');

}

function Berlee_admin() {

	global $themename, $options;

	if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings saved.</strong></p></div>';
	if ( $_REQUEST['reset'] ) echo '<div id="message" class="updated fade"><p><strong>'.$themename.' settings reset.</strong></p></div>';
	
?>
<div class="wrap">
<h2><?php echo $themename; ?> settings</h2>

<form method="post">

<table class="optiontable">

<?php foreach ($options as $value) { 
	
if ($value['type'] == "text") { ?>
		
<tr valign="top"> 
	<th scope="row"><?php echo $value['name']; ?>:</th>
	<td>
		<input name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>" type="<?php echo $value['type']; ?>" size="<?php echo $value['length']; ?>" value="<?php if ( get_option( $value['id'] ) != "") { echo stripslashes(get_option( $value['id'] )); } else { echo $value['std']; } ?>" />
		<?php if ( $value['description']) { echo "<br />".$value['description'];} ?>
	</td>
</tr>

<?php } elseif ($value['type'] == "select") { ?>

	<tr valign="top"> 
		<th scope="row"><?php echo $value['name']; ?>:</th>
		<td>
			<select name="<?php echo $value['id']; ?>" id="<?php echo $value['id']; ?>">
				<?php foreach ($value['options'] as $option) { ?>
				<option<?php if ( get_option( $value['id'] ) == $option) { echo ' selected="selected"'; } elseif ($option == $value['std']) { echo ' selected="selected"'; } ?>><?php echo $option; ?></option>
				<?php } ?>
			</select>
			<?php if ( $value['description']) { echo "<br />".$value['description'];} ?>
		</td>
	</tr>

<?php 
} 
}
?>

</table>

<p class="submit">
<input name="save" type="submit" value="Save changes" />	
<input type="hidden" name="action" value="save" />
</p>
</form>
<form method="post">
<p class="submit">
<input name="reset" type="submit" value="Reset" />
<input type="hidden" name="action" value="reset" />
</p>
</form>

<?php
}

function Berlee_NoLeftSidebar() { ?>
    <style type="text/css">
	#col-main { width: 550px; }
	#wrap { background: url(<?php echo bloginfo("template_url"); ?>/i/wrap1.gif) repeat-y; }
    </style>
<?php }

function Berlee_header_Ticker() { 
	global $Berlee_ticker;
	wp_get_archives("type=postbypost&limit=".$Berlee_ticker."&format=link");
}

function Berlee_footer_Ticker() { ?>
	<script type="text/javascript" src="<?php bloginfo("template_directory"); ?>/ticker.js" defer="defer"></script>
<?php }

function Berlee_GoogleAnalytics() { ?>
    <script type="text/javascript" src="http://www.google-analytics.com/urchin.js"></script>
    <script type="text/javascript"><!--
	_uacct = "<?php echo get_option("Berlee_GoogleAnalytics"); ?>";
	urchinTracker();
    --></script>
<?php }

include (TEMPLATEPATH . "/acf-functions.php");

if ( get_option("Berlee_LeftSidebar") == "Disabled" ) add_action('wp_head',   'Berlee_NoLeftSidebar');

if ( intval(get_option("Berlee_ticker")) ) $Berlee_ticker = intval(get_option("Berlee_ticker"));
if ( get_option("Berlee_ticker") == "" ) $Berlee_ticker = 15;

if ( $Berlee_ticker ) {
	add_action('wp_head',   'Berlee_header_Ticker');
	add_action('wp_footer', 'Berlee_footer_Ticker');
}
if ( get_option("Berlee_GoogleAnalytics") ) add_action('wp_footer', 'Berlee_GoogleAnalytics');

add_action('admin_menu', 'Berlee_add_admin'); 

if ( function_exists('register_sidebar') ) {
    if ( get_option("Berlee_leftsidebar") != "Disabled" ) {
        register_sidebar(array(
		'name' => 'Left',
                'before_widget' => '<div class="left-sec %2$s">', // Removes <li>
                'after_widget' => '</div>', // Removes </li>
                'before_title' => '<h3 class="sec-title">', // Replaces <h2>
                'after_title' => '</h3>', // Replaces </h2>
        ));
    }
    register_sidebar(array(
	'name' => 'Right-Article',
        'before_widget' => '<div class="right-sec %2$s">', // Removes <li>
        'after_widget' => '</div>', // Removes </li>
        'before_title' => '<h3 class="sec-title">', // Replaces <h2>
        'after_title' => '</h3>', // Replaces </h2>
    ));
    register_sidebar(array(
        'name' => 'Right-Page',
        'before_widget' => '<div class="right-sec %2$s">', // Removes <li>
        'after_widget' => '</div>', // Removes </li>
        'before_title' => '<h3 class="sec-title">', // Replaces <h2>
        'after_title' => '</h3>', // Replaces </h2>
    ));
}	
?>
