<?php

/*********************
These variables will define the default settings for the theme
*********************/

$ah_themename = 'Winter'; // Admin Panel Display Name
$ah_leftdesc = 'Sidebar on Right'; // default sidebar position description
$ah_rightdesc = 'Sidebar on Left'; // alternate sidebar position
$ah_stylename = 'winter'; // option name - no spaces
$ah_left = '#content'; // comma separated element(s) defaulting to left
$ah_right = '#menu';// comma separated element(s) defaulting to right
$ah_fontsize = '14'; // default font size (8-14)
// enclose font families with spaces in single quotes 
$ah_fontlist = "Georgia, 'Times New Roman', Times, serif"; 

/*********************
Add the appropriate functionality to wordpress
*********************/

add_action('wp_head', 'ah_style_head');
add_action('admin_menu', 'ah_add_theme_page');
if ( function_exists('register_sidebar') )
	register_sidebar();

/*********************
Add the styles to the output
*********************/

function ah_style_head() {
	$style = get_option(ah_theme_option_name('style'));
	if(!$style) {
		$style = ah_build_style();
	}
	if($style) {
		echo $style;
	}
}

/*********************
Build a unique option name for storage in wp options table
*********************/

function ah_theme_option_name($option = '') {
	global $ah_stylename;
	if(!$option) {
		return '';
	}
	return 'ah_' . $ah_stylename . '_' . $option;
}

/*********************
Build a style string based on the values stored in the 
global variables
*********************/

function ah_build_style() {
	global $ah_left, $ah_right, $ah_fontsize, $ah_fontlist;
	// define a few strings
	$ob = ' { ';
	$cb = " }\n";
	$sc = '; ';
	$fl = 'float: ';
	$lt = 'left';
	$rt = 'right';
	// read options
	$ah_swap = get_option(ah_theme_option_name('swap'));
	$ah_size = get_option(ah_theme_option_name('fontsize'));
	$ah_font = stripslashes(get_option(ah_theme_option_name('fontlist')));
	// take defaults if not stored in options
	if(!$ah_size) {
		$ah_size = $ah_fontsize;
	}
	if(!$ah_font) {
		$ah_font = $ah_fontlist;
	}

	$head = "<style type='text/css'>\n<!--\n\t";
	// float sides
	if($ah_left && $ah_right) {
		$result = $ah_left . $ob . $fl;
		if ( $ah_swap ) {
			$result .= $rt;
		} else {
			$result .= $lt;
		}
		$result .= $sc . $cb . $ah_right . $ob . $fl;
		if ( $ah_swap ) {
			$result .= $lt;
		} else {
			$result .= $rt;
		}
		$result .= $sc . $cb;
	}
	// set font list and size
	$result .= 'body' . $ob . 'font-size: ' . $ah_size .
		'px' . $sc . 'font-family: ' . $ah_font . $sc . $cb;
	$foot = "--></style>\n";
	
	return $head . $result . $foot;
}

function ah_add_theme_page() {
	global $ah_stylename, $ah_fontsize, $ah_fontlist;
	if ( $_GET['page'] == basename(__FILE__) ) {
		if ( '1' == $_REQUEST['restore'] ) {
			delete_option(ah_theme_option_name('style'));
			delete_option(ah_theme_option_name('swap'));
			delete_option(ah_theme_option_name('fontsize'));
			delete_option(ah_theme_option_name('fontlist'));
			header("Location: themes.php?page=functions.php&restored=true");
			die;
		} else if ( 'save' == $_REQUEST['action'] ) {
			$ah_swap = $_REQUEST['ah_swap'];
			$ah_size = $_REQUEST['ah_size'];
			$ah_font = $_REQUEST['ah_font'];

			update_option(ah_theme_option_name('swap'), $ah_swap);
			update_option(ah_theme_option_name('fontsize'), $ah_size);
			update_option(ah_theme_option_name('fontlist'), $ah_font);
			update_option(ah_theme_option_name('style'), ah_build_style());

			header("Location: themes.php?page=functions.php&saved=true");
			die;
		} 
	} 
	add_theme_page($ah_stylename." Theme Options", "Current Theme Options", 'edit_themes', basename(__FILE__), 'ah_theme_page');
}

function ah_theme_page() {
	global $ah_themename, $ah_leftdesc, $ah_rightdesc, $ah_fontsize, $ah_fontlist;
	$checked = ' checked="checked"';
	$ah_swap = get_option(ah_theme_option_name('swap'));
	$ah_size = get_option(ah_theme_option_name('fontsize'));
	$ah_font = stripslashes(get_option(ah_theme_option_name('fontlist')));
	// take defaults if not stored in options
	if(!$ah_size) {
		$ah_size = $ah_fontsize;
	}
	if(!$ah_font) {
		$ah_font = $ah_fontlist;
	}
	$msgopen = '<div id="message" class="updated fade"><p><strong>Options ';
	$msgclose = '.</strong></p></div>';
	if ( $_REQUEST['saved'] ) {
		echo $msgopen.'saved'.$msgclose;
	} else if ( $_REQUEST['restored'] ) {
		echo $msgopen.'restored'.$msgclose;
	} ?>
<div class='wrap'>
	<?php echo "<h2>" . $ah_themename; ?> Options</h2>
	<form id="ah_theme" method="POST">
		<div id="templateside"><h3>Font size</h3><br />
			<?php $thesize = 'ah_font' . $ah_size;
			for($i = 14; $i > 7; $i--) {
				$id = 'ah_font' . $i;
				echo '<input type="radio" id="' . $id . '" name="ah_size" value="' . $i .'"'; 
				if($id == $thesize) { 
					echo $checked; 
				} 
				echo ' /><label for="' . $id . '">' . $i . '</label><br />' . "\n";
			} ?>
		</div>
		<div><h3>Positioning</h3>
			<input type="radio" id="ah_left" name="ah_swap" value="0"<?php 
				if(!$ah_swap) { 
					echo $checked; 
				} ?> /><label for="ah_left"><?php echo $ah_leftdesc; ?></label><br />
			<input type="radio" id="ah_right" name="ah_swap" value="1"<?php 
				if($ah_swap) { 
					echo $checked; 
				} ?> /><label for="ah_right"><?php echo $ah_rightdesc; ?></label><br /><br />
		<h3>Font list</h3>
			Default: <?php echo $ah_fontlist; ?><br />
			Current:<br />
			<input type="text" name="ah_font" id="ah_font" size="80" value="<?php echo $ah_font; ?>" /><br />
		</div>
		<p class="submit">
			<input type="submit" name="submitform" value="&nbsp;&nbsp;Save Theme Settings&nbsp;&nbsp;" />
			<input type="submit" name="defaults" value="&nbsp;&nbsp;Restore Defaults&nbsp;&nbsp;" onClick="restore.value='1'" /></p>
			<input type="hidden" name="action" value="save" />
			<input type="hidden" name="restore" value="0" />
	</form>
</div>
<?php } ?>