<?php get_header(); ?>

	<div id="wp-content">
		<div id="wp-content-pri">
			
			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
			
			<div class="post" id="post-<?php the_ID(); ?>">
				<h2><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php _e('Permanent Link to '); ?><?php the_title(); ?>"><?php the_title(); ?></a></h2>
				<div class="post-meta">
					<p>
					<span class="post-meta-date"><?php the_time('F jS, Y'); ?></span>
					<span class="post-meta-time"><?php the_time(); ?></span>
					<span class="post-meta-category"><?php the_category(', '); ?></span>
					<span class="post-meta-comments"><?php comments_popup_link('Leave a comment', '1 comment', '% comments'); ?></span>
					<?php edit_post_link('Edit', ' | <span>', '</span>'); ?>
					</p>
				</div>
				<?php the_content('Read the rest of this entry &raquo;'); ?>
			</div>
			
			<!-- <?php trackback_rdf(); ?> -->
			
			<?php endwhile; ?>
			
			<div id="post-navigation-bot">
				<div class="next"><?php next_posts_link('&laquo; Older Entries') ?></div>
				<div class="prev"><?php previous_posts_link('Newer Entries &raquo;') ?></div>
			</div>
			
			<?php else : ?>
			
			<div class="post" id="post">
				<h2><?php _e('Not Found'); ?></h2>
				<p><?php _e('Sorry, but you are looking for something that isn\'t here.'); ?></p>
				<?php include(TEMPLATEPATH . "/searchform.php"); ?>
			</div>
			
			<?php endif; ?>
			
		</div>

		<?php get_sidebar(); ?>

<?php get_footer(); ?>