<?php
/*
Template Name: Articles
*/
?>

<?php get_header(); ?>

<div class="narrowcolumn">
<?php
    if ( have_posts( ) )
    {
        while ( have_posts( ) )
        {
            the_post( );

            sp_post_head_default( );
            
            the_content( '[more]', 0, '' );

            if(($list = wp_list_pages("title_li=child_of=".$post->ID."&echo=0")))
            {
                echo '<dl>';
                $pages = get_pages("child_of=$post->ID&sort_column=menu_order");
                foreach ($pages as $page)
                {
                    echo "<dt><a href=\"".get_permalink($page->ID)."\">$page->post_title</a></dt>";
                    $custom = get_post_custom( $page->ID );
                    // since pages can't have excerpts, we'll use a custom field to get a description
                    if ( isset( $custom['description'] ) )
                    {
                        echo "<dd>".$custom['description'][0]."</dd>";
                    }
                    else
                    {
                        echo "<dd></dd>";
                    }
                }
                echo '</dl>';
            }

            sp_post_foot_default( );
        }
    }
?>
</div>

<?php get_sidebar(); ?>

<?php get_footer(); ?>
