<?php
function greenday_get_title() {
$title = get_bloginfo('name');
if ($pos = strpos($title, ' ', 3)) {
	$title = substr_replace($title,strtolower(substr($title,0,$pos)) , 0,$pos);
	$title = substr_replace($title, '</span>', $pos, 1);
	$title = '<span>'.$title;
}
return $title;
}

function greenday_get_menu_from_pages() {

	$pages = & get_pages($args);
	if ( $pages ) {

		foreach ($pages as $page) {
			$output = '<li><a href="' . get_page_link($page->ID) . '">' . $page->post_title . '</a></li>';
			echo $output;
		}
	}

}

function greenday_head() {
	$head = "<style type='text/css'>\n<!--";
	$output = '';

	if ('Y'== get_settings('press_adsidebar')) {
		$output .= "#container {	width: 850px; }\n";
	} else {
		$output .= "#container {	width: 660px; }\n";
		$output .= "#rightads { display: none; }\n";
	}

	$foot = "--></style>\n";
	echo $head . $output . $foot;
}

add_action('wp_head', 'greenday_head');

function greenday_styles(){
	if ( $_GET['page'] == basename(__FILE__) ) {
		if ( 'save' == $_REQUEST['action'] ) {
				if ( isset($_REQUEST['adssidebar']) ) {
					update_option('greenday_adsidebar','Y');
				} else {
					update_option('greenday_adsidebar','N');
				}
				if ( isset($_REQUEST['gpubid']) ) {
					update_option('greenday_google_pub_id',$_REQUEST['gpubid']);
				}
			wp_redirect("themes.php?page=functions.php&saved=true");
			die;
		}
	}
	add_theme_page('Customize Greenday Theme', 'Greenday Options', 'edit_themes', basename(__FILE__), 'greenday_theme_settings');

}

add_action('admin_menu', 'greenday_styles');

function greenday_theme_settings() {
	if ( $_REQUEST['saved'] ) echo '<div id="message" class="updated fade"><p><strong>Options saved.</strong></p></div>';
	?>
	<div class='wrap'>
		<h2>Google Ads Sidebar</h2>
		<div id="OptionsForm">
			<form method="post" action="">
				<label for="adssidebar">Show Ads Sidebar:</label><input type="checkbox" name="adssidebar" id="adssidebar" value="Y" <?php if ('Y'== get_settings('greenday_adsidebar')) echo 'checked'; ?> /> <br/>
				<label for="gpubid">Google Publisher ID:</label><input type="text" name="gpubid" id="gpubid" value="<?php if (get_settings('greenday_google_pub_id')) echo get_settings('press_google_pub_id'); else echo 'pub-7140399180302037'; ?>" /> <br/>
				<input type="submit" name="submit" id="submit" value="Submit Options" />
				<input type="hidden" name="action" value="save" />
			</form>
		</div>
	</div>
	<?php

}

function greenday_set_defaults() {
if (!get_settings('press_adsidebar')) {
update_option('greenday_adsidebar','N');
update_option('greenday_google_pub_id','pub-7140399180302037');
}
}
greenday_set_defaults();
?>